/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;

public class LayoutInfo
implements Cloneable {
    private Alignment align;
    private FillType fill;
    private Insets insets;
    private Dimension padding;
    public static final Alignment CENTER = new Alignment(0);
    public static final Alignment NORTH = new Alignment(1);
    public static final Alignment SOUTH = new Alignment(2);
    public static final Alignment WEST = new Alignment(4);
    public static final Alignment EAST = new Alignment(8);
    public static final Alignment NORTHEAST = new Alignment(LayoutInfo.NORTH.value + LayoutInfo.EAST.value);
    public static final Alignment SOUTHEAST = new Alignment(LayoutInfo.SOUTH.value + LayoutInfo.EAST.value);
    public static final Alignment NORTHWEST = new Alignment(LayoutInfo.NORTH.value + LayoutInfo.WEST.value);
    public static final Alignment SOUTHWEST = new Alignment(LayoutInfo.SOUTH.value + LayoutInfo.WEST.value);
    public static final FillType NONE = new FillType();
    public static final FillType HORIZONTAL = new FillType();
    public static final FillType VERTICAL = new FillType();
    public static final FillType BOTH = new FillType();

    public LayoutInfo() {
        this(CENTER, NONE, null, null);
    }

    public LayoutInfo(Alignment align, FillType fill) {
        this(align, fill, null, null);
    }

    public LayoutInfo(Alignment align, FillType fill, Insets insets, Dimension padding) {
        this.align = align;
        this.fill = fill;
        this.insets = insets;
        this.padding = padding;
    }

    public Alignment getAlignment() {
        return this.align;
    }

    public void setAlignment(Alignment align) {
        this.align = align;
    }

    public FillType getFill() {
        return this.fill;
    }

    public void setFill(FillType fill) {
        this.fill = fill;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Dimension getPadding() {
        return this.padding;
    }

    public void setPadding(Dimension padding) {
        this.padding = padding;
    }

    public Object clone() {
        return new LayoutInfo(this.align, this.fill, this.insets == null ? null : (Insets)this.insets.clone(), this.padding == null ? null : (Dimension)this.padding.clone());
    }

    public Dimension getPreferredSize(Widget widget) {
        Dimension dim = widget.getPreferredSize().getSize();
        if (this.insets != null) {
            dim.width += this.insets.left + this.insets.right;
            dim.height += this.insets.top + this.insets.bottom;
        }
        if (this.padding != null) {
            dim.width += this.padding.width;
            dim.height += this.padding.height;
        }
        return dim;
    }

    public Dimension getMaximumSize(Widget widget) {
        Dimension dim = widget.getMaximumSize().getSize();
        if (this.insets != null) {
            dim.width += this.insets.left + this.insets.right;
            dim.height += this.insets.top + this.insets.bottom;
        }
        if (this.padding != null) {
            dim.width += this.padding.width;
            dim.height += this.padding.height;
        }
        return dim;
    }

    public Rectangle getWidgetLayout(Widget widget, Rectangle rect) {
        int height;
        int xpad;
        int ypad;
        int left;
        int right;
        int bottom;
        int top;
        Dimension pref = widget.getPreferredSize();
        Dimension max = widget.getMaximumSize();
        if (this.insets == null) {
            top = 0;
            bottom = 0;
            right = 0;
            left = 0;
        } else {
            left = this.insets.left;
            right = this.insets.right;
            bottom = this.insets.bottom;
            top = this.insets.top;
        }
        if (this.padding == null) {
            ypad = 0;
            xpad = 0;
        } else {
            xpad = this.padding.width;
            ypad = this.padding.height;
        }
        int width = this.fill == HORIZONTAL || this.fill == BOTH ? rect.width - left - right : pref.width + xpad;
        int n = height = this.fill == VERTICAL || this.fill == BOTH ? rect.height - top - bottom : pref.height + ypad;
        if (width > max.width) {
            width = max.width;
        }
        if (height > max.height) {
            height = max.height;
        }
        int y = (this.align.value & LayoutInfo.NORTH.value) != 0 ? rect.y + top : ((this.align.value & LayoutInfo.SOUTH.value) != 0 ? rect.y + rect.height - bottom - height : rect.y + (rect.height - height >> 1));
        int x = (this.align.value & LayoutInfo.WEST.value) != 0 ? rect.x + left : ((this.align.value & LayoutInfo.EAST.value) != 0 ? rect.x + rect.width - right - width : rect.x + (rect.width - width >> 1));
        return new Rectangle(x, y, width, height);
    }

    static {
        WidgetEncoder.setPersistenceDelegate(Alignment.class, new StaticFieldDelegate(LayoutInfo.class));
        WidgetEncoder.setPersistenceDelegate(FillType.class, new StaticFieldDelegate(LayoutInfo.class));
    }

    public static class FillType {
        private FillType() {
        }
    }

    public static class Alignment {
        protected int value;

        private Alignment(int value) {
            this.value = value;
        }
    }
}

