/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.SelectionChangedEvent;
import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class BFileChooser
extends Widget {
    private SelectionMode selectMode;
    private static File lastDirectory = FileSystemView.getFileSystemView().getDefaultDirectory();
    public static final SelectionMode OPEN_FILE = new SelectionMode();
    public static final SelectionMode SAVE_FILE = new SelectionMode();
    public static final SelectionMode SELECT_FOLDER = new SelectionMode();

    public BFileChooser() {
        this(OPEN_FILE, null, lastDirectory);
    }

    public BFileChooser(SelectionMode mode, String title) {
        this(mode, title, lastDirectory);
    }

    public BFileChooser(SelectionMode mode, String title, File directory) {
        this.component = this.createComponent();
        this.setMode(mode);
        this.setTitle(title);
        this.setDirectory(directory);
        this.component.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                String name = ev.getPropertyName();
                if ("SelectedFilesChangedProperty".equals(name) || "SelectedFileChangedProperty".equals(name) && !BFileChooser.this.isMultipleSelectionEnabled()) {
                    BFileChooser.this.dispatchEvent(new SelectionChangedEvent(BFileChooser.this));
                }
            }
        });
    }

    protected JFileChooser createComponent() {
        return new JFileChooser();
    }

    public String getTitle() {
        return ((JFileChooser)this.component).getDialogTitle();
    }

    public void setTitle(String title) {
        ((JFileChooser)this.component).setDialogTitle(title);
    }

    public SelectionMode getMode() {
        return this.selectMode;
    }

    public void setMode(SelectionMode mode) {
        this.selectMode = mode;
        ((JFileChooser)this.component).setFileSelectionMode(mode == SELECT_FOLDER ? 1 : 0);
    }

    public boolean isMultipleSelectionEnabled() {
        return ((JFileChooser)this.component).isMultiSelectionEnabled();
    }

    public void setMultipleSelectionEnabled(boolean multiple) {
        ((JFileChooser)this.component).setMultiSelectionEnabled(multiple);
    }

    public FileFilter getFileFilter() {
        return ((JFileChooser)this.component).getFileFilter();
    }

    public void setFileFilter(FileFilter filter) {
        ((JFileChooser)this.component).setFileFilter(filter);
    }

    public File getDirectory() {
        return ((JFileChooser)this.component).getCurrentDirectory();
    }

    public void setDirectory(File directory) {
        ((JFileChooser)this.component).setCurrentDirectory(directory);
        lastDirectory = directory;
    }

    public File getSelectedFile() {
        return ((JFileChooser)this.component).getSelectedFile();
    }

    public void setSelectedFile(File file) {
        ((JFileChooser)this.component).setSelectedFile(file);
    }

    public File[] getSelectedFiles() {
        return ((JFileChooser)this.component).getSelectedFiles();
    }

    public void setSelectedFiles(File[] files) throws IllegalArgumentException {
        if (!this.isMultipleSelectionEnabled()) {
            throw new IllegalArgumentException();
        }
        ((JFileChooser)this.component).setSelectedFiles(files);
    }

    public boolean showDialog(Widget parent) {
        JFileChooser jfc = (JFileChooser)this.component;
        Component parentComponent = parent == null ? null : parent.getComponent();
        int result = this.selectMode == SAVE_FILE ? jfc.showSaveDialog(parentComponent) : jfc.showOpenDialog(parentComponent);
        lastDirectory = jfc.getCurrentDirectory();
        return result == 0;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(SelectionMode.class, new StaticFieldDelegate(SelectionMode.class));
    }

    public static class SelectionMode {
        private SelectionMode() {
        }
    }
}

