/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Vector;

public class SearchlistClassLoader
extends ClassLoader {
    protected Vector list;
    protected Vector search;
    protected Hashtable cache;
    protected Loader content = null;
    protected byte searchMode = 1;
    protected int divide = 0;
    public static final byte SHARED = 1;
    public static final byte NONSHARED = 2;
    public static final byte ORDERED = 3;
    protected static final URL[] EMPTY_URL = new URL[0];

    public SearchlistClassLoader() {
    }

    public SearchlistClassLoader(ClassLoader parent) {
        super(parent);
    }

    public SearchlistClassLoader(URL[] url) {
        this.content = new Loader(new URLClassLoader(url), false);
    }

    public SearchlistClassLoader(URL[] url, ClassLoader parent) {
        super(parent);
        this.content = new Loader(new URLClassLoader(url), false);
    }

    public void setSearchMode(byte mode) {
        byte prev = this.searchMode;
        this.searchMode = mode;
        if (this.searchMode <= 0 || this.searchMode > 3) {
            System.out.println("SearchlistClassLoader.setSearchMode: Invalid search mode: " + mode + "; defaulting to SHARED.");
            this.searchMode = 1;
        }
    }

    public void add(ClassLoader loader) {
        Loader ldr = new Loader(loader, true);
        if (this.list == null) {
            this.list = new Vector(16);
        }
        this.list.add(ldr);
        if (this.search == null) {
            this.search = new Vector(16);
        }
        if (this.search.size() > this.divide) {
            this.search.add(this.divide, ldr);
        } else {
            this.search.add(ldr);
        }
        ++this.divide;
    }

    public void add(URL url) {
        Loader ldr = new Loader(new URLClassLoader(new URL[]{url}), false);
        if (this.list == null) {
            this.list = new Vector(16);
        }
        this.list.add(ldr);
        if (this.search == null) {
            this.search = new Vector(16);
        }
        this.search.add(ldr);
    }

    public URL[] getURLs() {
        return this.content != null ? ((URLClassLoader)this.content.loader).getURLs() : EMPTY_URL;
    }

    public URL[] getSearchPath() {
        Loader ldr;
        int i = 0;
        while ((ldr = this.getLoader(i++, this.searchMode)) != null) {
            Object url = ldr.loader instanceof SearchlistClassLoader ? ((SearchlistClassLoader)ldr.loader).getSearchPath() : (ldr.loader instanceof URLClassLoader ? ((URLClassLoader)ldr.loader).getURLs() : null);
            if (url != null) {
                for (int j = 0; j < ((URL[])url).length; ++j) {
                    this.list.add(url[j]);
                }
            }
            ++i;
        }
        return this.list.size() > 0 ? this.list.toArray(EMPTY_URL) : EMPTY_URL;
    }

    public Class loadLocalClass(String name) throws ClassNotFoundException {
        ClassNotFoundException err = null;
        if (this.getParent() != null) {
            try {
                return this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                err = e;
            }
        }
        if (this.content != null) {
            Class<?> result;
            Class<?> clazz = result = this.cache != null ? (Class<?>)this.cache.get(name) : null;
            if (result != null) {
                return result;
            }
            byte[] data = this.loadClassData(this.content.loader, name);
            if (data != null && (result = this.defineClass(name, data, 0, data.length)) != null) {
                if (this.cache == null) {
                    this.cache = new Hashtable(1024);
                }
                this.cache.put(name, result);
                return result;
            }
        }
        throw err != null ? err : new ClassNotFoundException(name);
    }

    public URL getLocalResource(String name) {
        URL result = null;
        if (this.getParent() != null) {
            result = this.getParent().getResource(name);
        }
        if (result == null && this.content != null) {
            result = this.content.loader.getResource(name);
        }
        return result;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Loader ldr;
        Throwable err = null;
        int i = 0;
        while ((ldr = this.getLoader(i, this.searchMode)) != null) {
            try {
                Class<?> result;
                if (ldr.shared) {
                    return ldr.loader.loadClass(name);
                }
                Class<?> clazz = result = this.cache != null ? (Class<?>)this.cache.get(name) : null;
                if (result != null) {
                    return result;
                }
                byte[] data = this.loadClassData(ldr.loader, name);
                if (data != null && (result = this.defineClass(name, data, 0, data.length)) != null) {
                    if (this.cache == null) {
                        this.cache = new Hashtable(1024);
                    }
                    this.cache.put(name, result);
                    return result;
                }
            }
            catch (Throwable t) {
                err = t;
            }
            ++i;
        }
        throw err != null ? new ClassNotFoundException(name, err) : new ClassNotFoundException(name);
    }

    public URL findResource(String path) {
        Loader ldr;
        System.out.println("findResource: looking in " + this + " for " + path);
        URL url = null;
        int i = 0;
        while ((ldr = this.getLoader(i, this.searchMode)) != null) {
            url = ldr.loader.getResource(path);
            if (url != null) {
                System.out.println("found " + path + " in loader: " + ldr.loader);
                break;
            }
            ++i;
        }
        return url;
    }

    protected Loader getLoader(int index, byte mode) {
        Loader result;
        if (this.content != null) {
            if (index == 0) {
                return this.content;
            }
            --index;
        }
        if (index < 0 || index >= this.list.size()) {
            return null;
        }
        switch (mode) {
            case 1: {
                result = (Loader)this.search.get(index);
                break;
            }
            case 2: {
                int pos = index + this.divide;
                result = (Loader)(pos < this.search.size() ? this.search.get(pos) : this.search.get(pos - this.divide));
                break;
            }
            default: {
                result = (Loader)this.list.get(index);
            }
        }
        return result;
    }

    protected byte[] loadClassData(ClassLoader cl, String name) {
        InputStream in = cl.getResourceAsStream(SearchlistClassLoader.translate(name, ".", "/") + ".class");
        if (in == null) {
            return null;
        }
        try {
            int len;
            ByteArrayOutputStream barray = new ByteArrayOutputStream(16384);
            byte[] buff = new byte[1024];
            do {
                if ((len = in.read(buff, 0, buff.length)) <= 0) continue;
                barray.write(buff, 0, len);
            } while (len >= 0);
            return barray.size() > 0 ? barray.toByteArray() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String translate(String str, String match, String replace) {
        StringBuffer b = new StringBuffer(str.length());
        int pos = 0;
        char c = '\u0000';
        if (match == null) {
            match = "";
        }
        if (replace == null) {
            replace = "";
        }
        boolean copy = match.length() != 0 && match.length() >= replace.length();
        int max = str.length();
        for (int x = 0; x < max; ++x) {
            c = str.charAt(x);
            pos = match.indexOf(c);
            if (pos >= 0) {
                if (pos >= replace.length()) continue;
                b.append(replace.charAt(pos));
                continue;
            }
            if (!copy && replace.indexOf(c) < match.length()) continue;
            b.append(c);
        }
        return b.toString();
    }

    protected static class Loader {
        ClassLoader loader = null;
        boolean shared = false;

        Loader(ClassLoader loader, boolean shared) {
            this.loader = loader;
            this.shared = shared;
        }
    }
}

