/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ModellingApp;
import artofillusion.ui.ThemeManager;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BList;
import buoy.widget.BMenuBar;
import buoy.widget.BOutline;
import buoy.widget.BRadioButton;
import buoy.widget.BScrollPane;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;

public class UIUtilities {
    public static void centerWindow(WindowWidget win) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(win.getComponent().getGraphicsConfiguration());
        screenSize.width -= screenInsets.left + screenInsets.right;
        screenSize.height -= screenInsets.top + screenInsets.bottom;
        Rectangle winBounds = win.getBounds();
        int x = (screenSize.width - winBounds.width) / 2;
        int y = (screenSize.height - winBounds.height) / 2;
        if (x < screenInsets.left) {
            x = screenInsets.left;
        }
        if (y < screenInsets.top) {
            y = screenInsets.top;
        }
        win.setBounds(new Rectangle(x, y, winBounds.width, winBounds.height));
    }

    public static void centerDialog(BDialog dlg, WindowWidget parent) {
        Rectangle r1 = parent.getBounds();
        Rectangle r2 = dlg.getBounds();
        int x = r1.x + (r1.width - r2.width) / 2;
        int y = r1.y + 20;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        dlg.setBounds(new Rectangle(x, y, r2.width, r2.height));
    }

    public static void applyDefaultFont(Widget w) {
        if (ModellingApp.defaultFont == null) {
            return;
        }
        w.setFont(ModellingApp.defaultFont);
        if (w instanceof WidgetContainer && !(w instanceof BMenuBar)) {
            Iterator children = ((WidgetContainer)w).getChildren().iterator();
            while (children.hasNext()) {
                UIUtilities.applyDefaultFont((Widget)children.next());
            }
        }
    }

    public static void applyDefaultBackground(Widget w) {
        UIUtilities.applyBackground(w, ThemeManager.getAppBackgroundColor());
        UIUtilities.applyTextColor(w, ThemeManager.getTextColor());
    }

    public static void applyBackground(Widget w, Color color) {
        if (w instanceof WidgetContainer) {
            w.setBackground(color);
            Iterator children = ((WidgetContainer)w).getChildren().iterator();
            while (children.hasNext()) {
                UIUtilities.applyBackground((Widget)children.next(), color);
            }
        } else if (w instanceof BLabel) {
            w.setBackground(color);
        } else if (w instanceof BButton || w instanceof BComboBox || w instanceof BCheckBox || w instanceof BRadioButton) {
            ((JComponent)w.getComponent()).setOpaque(false);
        }
    }

    public static void applyTextColor(Widget w, Color color) {
        if (w instanceof WidgetContainer) {
            Iterator children = ((WidgetContainer)w).getChildren().iterator();
            while (children.hasNext()) {
                UIUtilities.applyTextColor((Widget)children.next(), color);
            }
        } else if (w instanceof BLabel || w instanceof BCheckBox || w instanceof BRadioButton) {
            w.getComponent().setForeground(color);
        }
    }

    public static WidgetContainer createScrollingList(BList list) {
        BScrollPane scroll = new BScrollPane(list, BScrollPane.SCROLLBAR_AS_NEEDED, BScrollPane.SCROLLBAR_ALWAYS);
        scroll.setBackground(list.getBackground());
        scroll.setForceWidth(true);
        return BOutline.createBevelBorder(scroll, false);
    }

    public static WindowWidget findWindow(Widget w) {
        if (w instanceof WindowWidget) {
            return (WindowWidget)w;
        }
        if (w == null) {
            return null;
        }
        return UIUtilities.findWindow(w.getParent());
    }

    public static BFrame findFrame(Widget w) {
        if (w instanceof BFrame) {
            return (BFrame)w;
        }
        if (w == null) {
            return null;
        }
        return UIUtilities.findFrame(w.getParent());
    }

    public static String[] breakString(String s) {
        int lines = s.length() / 60 + 1;
        if (lines < 2) {
            return new String[]{s};
        }
        int lineLength = s.length() / lines;
        Vector<String> line = new Vector<String>();
        int index = 0;
        while (index + lineLength < s.length()) {
            int next = s.indexOf(32, index + lineLength);
            if (next == -1) {
                next = s.length();
            }
            line.addElement(s.substring(index, next).trim());
            index = next;
        }
        if (index < s.length()) {
            line.addElement(s.substring(index).trim());
        }
        Object[] result = new String[line.size()];
        line.copyInto(result);
        return result;
    }

    public static void setEnabled(Widget w, boolean enabled) {
        w.setEnabled(enabled);
        if (w instanceof WidgetContainer) {
            Iterator children = ((WidgetContainer)w).getChildren().iterator();
            while (children.hasNext()) {
                UIUtilities.setEnabled((Widget)children.next(), enabled);
            }
        }
    }
}

