/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BorderContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import java.awt.Insets;
import java.util.Iterator;

public class PanelDialog
extends BDialog {
    private boolean ok;

    public PanelDialog(WindowWidget parent, String prompt, Widget thePanel) {
        super(parent, true);
        BorderContainer content = new BorderContainer();
        this.setContent(content);
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(10, 10, 10, 10), null));
        if (prompt != null) {
            content.add(new BLabel(prompt), BorderContainer.NORTH);
        }
        content.add(thePanel, BorderContainer.CENTER);
        RowContainer buttons = new RowContainer();
        content.add(buttons, BorderContainer.SOUTH);
        BButton okButton = Translate.button("ok", this, "buttonPressed");
        buttons.add(okButton);
        buttons.add(Translate.button("cancel", this, "buttonPressed"));
        this.addEventLink(WindowClosingEvent.class, new Object(){

            void processEvent() {
                PanelDialog.this.ok = false;
                PanelDialog.this.closeWindow();
            }
        });
        this.addAsListener(this);
        this.setDefaultButton(okButton);
        this.pack();
        this.setResizable(false);
        UIUtilities.centerDialog(this, parent);
        this.setVisible(true);
    }

    public boolean clickedOk() {
        return this.ok;
    }

    private void buttonPressed(CommandEvent e) {
        String command = e.getActionCommand();
        this.ok = !command.equals("cancel");
        this.closeWindow();
    }

    private void closeWindow() {
        this.dispose();
        this.removeAsListener(this);
    }

    private void keyPressed(KeyPressedEvent ev) {
        int code = ev.getKeyCode();
        if (code == 27) {
            this.closeWindow();
        }
    }

    private void addAsListener(Widget w) {
        w.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        if (w instanceof WidgetContainer) {
            Iterator iter = ((WidgetContainer)w).getChildren().iterator();
            while (iter.hasNext()) {
                this.addAsListener((Widget)iter.next());
            }
        }
    }

    private void removeAsListener(Widget w) {
        w.removeEventLink(KeyPressedEvent.class, this);
        if (w instanceof WidgetContainer) {
            Iterator iter = ((WidgetContainer)w).getChildren().iterator();
            while (iter.hasNext()) {
                this.removeAsListener((Widget)iter.next());
            }
        }
    }
}

