/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.Linear2DTriangle;
import artofillusion.texture.Linear3DTriangle;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformTriangle;

public class LayeredTriangle
extends RenderingTriangle {
    private double x1;
    private double x2;
    private double x3;
    private double y1;
    private double y2;
    private double y3;
    private double z1;
    private double z2;
    private double z3;
    RenderingTriangle[] layerTriangle;

    public LayeredTriangle(int v1, int v2, int v3, int n1, int n2, int n3, double t1x, double t1y, double t1z, double t2x, double t2y, double t2z, double t3x, double t3y, double t3z, LayeredMapping theMapping, LayeredTexture theTexture, Vec3[] vert) {
        super(v1, v2, v3, n1, n2, n3);
        this.x1 = t1x;
        this.y1 = t1y;
        this.z1 = t1z;
        this.x2 = t2x;
        this.y2 = t2y;
        this.z2 = t2z;
        this.x3 = t3x;
        this.y3 = t3y;
        this.z3 = t3z;
        this.layerTriangle = new RenderingTriangle[theMapping.getNumLayers()];
        for (int i = 0; i < this.layerTriangle.length; ++i) {
            RenderingTriangle tri = theMapping.getLayerMapping(i).mapTriangle(v1, v2, v3, n1, n2, n3, vert);
            if (tri instanceof UniformTriangle || tri instanceof Linear2DTriangle || tri instanceof Linear3DTriangle) continue;
            this.layerTriangle[i] = tri;
        }
    }

    public void getTextureSpec(TextureSpec spec, double angle, double u, double v, double w, double size, double time) {
        Vec3 pos = new Vec3(this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.z1 * u + this.z2 * v + this.z3 * w);
        LayeredMapping map = (LayeredMapping)this.theMesh.mapping;
        TextureSpec tempSpec = new TextureSpec();
        int[] numParams = map.numParams;
        int[] paramStartIndex = map.paramStartIndex;
        int[] fractParamIndex = map.fractParamIndex;
        int[] blendMode = map.blendMode;
        double[] paramTemp = new double[map.maxParams];
        double[] param = this.getParameters(u, v, w);
        TextureMapping[] mapping = map.mapping;
        float rt = 1.0f;
        float gt = 1.0f;
        float bt = 1.0f;
        double ft = 1.0;
        boolean front = angle > 0.0;
        spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
        spec.specular.setRGB(0.0f, 0.0f, 0.0f);
        spec.hilight.setRGB(0.0f, 0.0f, 0.0f);
        spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
        spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
        spec.cloudiness = 0.0;
        spec.roughness = 0.0;
        spec.bumpGrad.set(0.0, 0.0, 0.0);
        for (int i = 0; i < mapping.length; ++i) {
            if (!mapping[i].appliesToFace(front)) continue;
            double f = param[fractParamIndex[i]];
            if (numParams[i] > 0) {
                for (int j = 0; j < numParams[i]; ++j) {
                    paramTemp[j] = param[paramStartIndex[i] + j];
                }
            }
            if (this.layerTriangle[i] == null) {
                mapping[i].getTextureSpec(pos, tempSpec, angle, size, time, paramTemp);
            } else {
                tempParamValues.set(paramTemp);
                this.layerTriangle[i].getTextureSpec(tempSpec, angle, u, v, w, size, time);
                tempParamValues.set(null);
            }
            float r = rt * (float)f;
            float g = gt * (float)f;
            float b = bt * (float)f;
            spec.diffuse.add(r * tempSpec.diffuse.red, g * tempSpec.diffuse.green, b * tempSpec.diffuse.blue);
            spec.specular.add(r * tempSpec.specular.red, g * tempSpec.specular.green, b * tempSpec.specular.blue);
            spec.hilight.add(r * tempSpec.hilight.red, g * tempSpec.hilight.green, b * tempSpec.hilight.blue);
            spec.emissive.add(r * tempSpec.emissive.red, g * tempSpec.emissive.green, b * tempSpec.emissive.blue);
            if (blendMode[i] == 0) {
                spec.transparent.subtract(r * (1.0f - tempSpec.transparent.red), g * (1.0f - tempSpec.transparent.green), b * (1.0f - tempSpec.transparent.blue));
                f = ft * f;
            } else {
                spec.transparent.subtract(r *= 1.0f - tempSpec.transparent.red, g *= 1.0f - tempSpec.transparent.green, b *= 1.0f - tempSpec.transparent.blue);
                f = Math.max(Math.max(r, g), b);
            }
            spec.roughness += f * tempSpec.roughness;
            spec.cloudiness += f * tempSpec.cloudiness;
            if (blendMode[i] == 2) {
                tempSpec.bumpGrad.scale(param[fractParamIndex[i]]);
            } else {
                tempSpec.bumpGrad.scale(f);
            }
            spec.bumpGrad.add(tempSpec.bumpGrad);
            rt -= r;
            gt -= g;
            bt -= b;
            ft -= f;
            if (!(rt <= 0.0f) || !(gt <= 0.0f) || !(bt <= 0.0f)) continue;
            return;
        }
    }

    public void getTransparency(RGBColor trans, double angle, double u, double v, double w, double size, double time) {
        Vec3 pos = new Vec3(this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.z1 * u + this.z2 * v + this.z3 * w);
        LayeredMapping map = (LayeredMapping)this.theMesh.mapping;
        TextureSpec tempSpec = new TextureSpec();
        int[] numParams = map.numParams;
        int[] paramStartIndex = map.paramStartIndex;
        int[] fractParamIndex = map.fractParamIndex;
        int[] blendMode = map.blendMode;
        double[] paramTemp = new double[map.maxParams];
        double[] param = this.getParameters(u, v, w);
        TextureMapping[] mapping = map.mapping;
        float rt = 1.0f;
        float gt = 1.0f;
        float bt = 1.0f;
        boolean front = angle > 0.0;
        trans.setRGB(1.0f, 1.0f, 1.0f);
        for (int i = 0; i < mapping.length; ++i) {
            if (!mapping[i].appliesToFace(front)) continue;
            double f = param[fractParamIndex[i]];
            if (numParams[i] > 0) {
                for (int j = 0; j < numParams[i]; ++j) {
                    paramTemp[j] = param[paramStartIndex[i] + j];
                }
            }
            if (this.layerTriangle[i] == null) {
                mapping[i].getTransparency(pos, tempSpec.transparent, angle, size, time, paramTemp);
            } else {
                tempParamValues.set(paramTemp);
                this.layerTriangle[i].getTransparency(tempSpec.transparent, angle, u, v, w, size, time);
                tempParamValues.set(null);
            }
            float r = rt * (float)f;
            float g = gt * (float)f;
            float b = bt * (float)f;
            if (blendMode[i] == 0) {
                trans.subtract(r * (1.0f - tempSpec.transparent.red), g * (1.0f - tempSpec.transparent.green), b * (1.0f - tempSpec.transparent.blue));
            } else {
                trans.subtract(r *= 1.0f - tempSpec.transparent.red, g *= 1.0f - tempSpec.transparent.green, b *= 1.0f - tempSpec.transparent.blue);
            }
            rt -= r;
            gt -= g;
            bt -= b;
            if (!(rt <= 0.0f) || !(gt <= 0.0f) || !(bt <= 0.0f)) continue;
            return;
        }
    }

    public double getDisplacement(double u, double v, double w, double size, double time) {
        Vec3 pos = new Vec3(this.x1 * u + this.x2 * v + this.x3 * w, this.y1 * u + this.y2 * v + this.y3 * w, this.z1 * u + this.z2 * v + this.z3 * w);
        LayeredMapping map = (LayeredMapping)this.theMesh.mapping;
        TextureSpec tempSpec = new TextureSpec();
        int[] numParams = map.numParams;
        int[] paramStartIndex = map.paramStartIndex;
        int[] fractParamIndex = map.fractParamIndex;
        int[] blendMode = map.blendMode;
        double[] paramTemp = new double[map.maxParams];
        double[] param = this.getParameters(u, v, w);
        TextureMapping[] mapping = map.mapping;
        double ft = 1.0;
        double height = 0.0;
        for (int i = 0; i < mapping.length; ++i) {
            double tempHeight;
            double f = param[fractParamIndex[i]];
            if (numParams[i] > 0) {
                for (int j = 0; j < numParams[i]; ++j) {
                    paramTemp[j] = param[paramStartIndex[i] + j];
                }
            }
            if (this.layerTriangle[i] == null) {
                tempHeight = mapping[i].getDisplacement(pos, size, time, paramTemp);
            } else {
                tempParamValues.set(paramTemp);
                tempHeight = this.layerTriangle[i].getDisplacement(u, v, w, size, time);
                tempParamValues.set(null);
            }
            f *= ft;
            if (blendMode[i] == 1) {
                mapping[i].getTransparency(pos, tempSpec.transparent, 1.0, size, time, paramTemp);
                float min = tempSpec.transparent.red;
                if (min > tempSpec.transparent.green) {
                    min = tempSpec.transparent.green;
                }
                if (min > tempSpec.transparent.blue) {
                    min = tempSpec.transparent.blue;
                }
                f *= ft * (double)(1.0f - min);
            }
            if (blendMode[i] != 2) {
                ft -= f;
            }
            height += tempHeight * f;
            if (!(ft <= 0.0)) continue;
            return height;
        }
        return height;
    }

    public void setMesh(RenderingMesh mesh, TextureMapping map, int index) {
        super.setMesh(mesh, map, index);
        LayeredMapping layered = (LayeredMapping)map;
        for (int i = 0; i < this.layerTriangle.length; ++i) {
            if (this.layerTriangle[i] == null) continue;
            this.layerTriangle[i].setMesh(mesh, layered.mapping[i], index);
        }
    }
}

