/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.Property;
import artofillusion.Scene;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.script.ObjectScript;
import artofillusion.script.ScriptRunner;
import artofillusion.script.ScriptedObjectController;
import artofillusion.script.ScriptedObjectEditorWindow;
import artofillusion.script.ScriptedObjectEnumeration;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import bsh.EvalError;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Enumeration;
import java.util.Hashtable;

public class ScriptedObject
extends ObjectCollection {
    private String script;
    private ObjectScript parsedScript;
    private String[] paramName;
    private double[] paramValue;

    public ScriptedObject(String scriptText) {
        this.script = scriptText;
        this.paramName = new String[0];
        this.paramValue = new double[0];
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String scriptText) {
        this.script = scriptText;
        this.parsedScript = null;
        this.cachedObjects = null;
        this.cachedBounds = null;
    }

    public ObjectScript getObjectScript() throws EvalError {
        if (this.parsedScript == null) {
            try {
                this.parsedScript = ScriptRunner.parseObjectScript(this.script);
            }
            catch (Exception ex) {
                ScriptRunner.displayError(ex, 1);
                this.parsedScript = new ObjectScript(){

                    public void execute(ScriptedObjectController script) {
                    }
                };
            }
        }
        return this.parsedScript;
    }

    public final int getNumParameters() {
        return this.paramName.length;
    }

    public final String getParameterName(int i) {
        return this.paramName[i];
    }

    public final double getParameterValue(int i) {
        return this.paramValue[i];
    }

    public void setParameterName(int i, String name) {
        this.paramName[i] = name;
    }

    public void setParameterValue(int i, double value) {
        this.paramValue[i] = value;
    }

    public void setParameters(String[] names, double[] values) {
        this.paramName = names;
        this.paramValue = values;
    }

    protected Enumeration enumerateObjects(ObjectInfo info, boolean interactive, Scene scene) {
        return new ScriptedObjectEnumeration(info, interactive, scene);
    }

    public Object3D duplicate() {
        ScriptedObject so = new ScriptedObject(this.script);
        so.paramName = new String[this.paramName.length];
        System.arraycopy(this.paramName, 0, so.paramName, 0, this.paramName.length);
        so.paramValue = new double[this.paramValue.length];
        System.arraycopy(this.paramValue, 0, so.paramValue, 0, this.paramValue.length);
        so.copyTextureAndMaterial(this);
        return so;
    }

    public void copyObject(Object3D obj) {
        ScriptedObject so = (ScriptedObject)obj;
        this.script = so.script;
        this.paramName = new String[so.paramName.length];
        System.arraycopy(so.paramName, 0, this.paramName, 0, this.paramName.length);
        this.paramValue = new double[so.paramValue.length];
        System.arraycopy(so.paramValue, 0, this.paramValue, 0, this.paramValue.length);
        this.parsedScript = null;
        this.copyTextureAndMaterial(obj);
    }

    public void setSize(double xsize, double ysize, double zsize) {
    }

    public Property[] getProperties() {
        Property[] prop = new Property[this.paramName.length];
        for (int i = 0; i < prop.length; ++i) {
            prop[i] = new Property(this.paramName[i], -1.7976931348623157E308, Double.MAX_VALUE, 0.0);
        }
        return prop;
    }

    public Object getPropertyValue(int index) {
        return new Double(this.paramValue[index]);
    }

    public void setPropertyValue(int index, Object value) {
        this.paramValue[index] = (Double)value;
        this.cachedObjects = null;
        this.cachedBounds = null;
    }

    public Keyframe getPoseKeyframe() {
        return new ScriptedObjectKeyframe(this, this.paramName, this.paramValue);
    }

    public void applyPoseKeyframe(Keyframe k) {
        if (this.paramName.length == 0) {
            return;
        }
        ScriptedObjectKeyframe key = (ScriptedObjectKeyframe)k;
        for (int i = 0; i < this.paramName.length; ++i) {
            Double d = (Double)key.valueTable.get(this.paramName[i]);
            this.paramValue[i] = d == null ? 0.0 : d;
        }
        this.cachedObjects = null;
        this.cachedBounds = null;
    }

    public String[] getPoseValueNames() {
        return this.paramName;
    }

    public double[] getDefaultPoseValues() {
        return this.paramValue;
    }

    public void configurePoseTrack(PoseTrack track) {
        String[] name = new String[this.paramValue.length];
        double[] value = new double[this.paramValue.length];
        double[][] range = new double[this.paramValue.length][];
        for (int i = 0; i < this.paramValue.length; ++i) {
            name[i] = this.paramName[i];
            value[i] = this.paramValue[i];
            range[i] = new double[]{-1.7976931348623157E308, Double.MAX_VALUE};
        }
        track.setGraphableValues(name, value, range);
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        ScriptedObjectKeyframe key = (ScriptedObjectKeyframe)k;
        Widget[] valField = new ValueField[this.paramName.length];
        for (int i = 0; i < this.paramName.length; ++i) {
            Double d = (Double)key.valueTable.get(this.paramName[i]);
            valField[i] = d == null ? new ValueField(0.0, 0, 5) : new ValueField(d, 0, 5);
        }
        ComponentsDialog dlg = new ComponentsDialog(parent.getFrame(), Translate.text("editScriptedObjTitle"), valField, this.paramName);
        if (!dlg.clickedOk()) {
            return;
        }
        for (int i = 0; i < this.paramName.length; ++i) {
            key.valueTable.put(this.paramName[i], new Double(((ValueField)valField[i]).getValue()));
        }
    }

    public boolean isEditable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        new ScriptedObjectEditorWindow(parent, info, cb);
    }

    public ScriptedObject(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.script = in.readUTF();
        int numParams = in.readShort();
        this.paramName = new String[numParams];
        this.paramValue = new double[numParams];
        for (int i = 0; i < numParams; ++i) {
            this.paramName[i] = in.readUTF();
            this.paramValue[i] = in.readDouble();
        }
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeUTF(this.script);
        out.writeShort(this.paramName.length);
        for (int i = 0; i < this.paramName.length; ++i) {
            out.writeUTF(this.paramName[i]);
            out.writeDouble(this.paramValue[i]);
        }
    }

    public static class ScriptedObjectKeyframe
    implements Keyframe {
        ScriptedObject script;
        public Hashtable valueTable;

        public ScriptedObjectKeyframe(ScriptedObject object, String[] names, double[] values) {
            this.script = object;
            this.valueTable = new Hashtable();
            for (int i = 0; i < names.length; ++i) {
                this.valueTable.put(names[i], new Double(values[i]));
            }
        }

        public Keyframe duplicate() {
            return this.duplicate(this.script);
        }

        public Keyframe duplicate(Object owner) {
            ScriptedObjectKeyframe key = new ScriptedObjectKeyframe((ScriptedObject)((ObjectInfo)owner).object, new String[0], new double[0]);
            key.valueTable = (Hashtable)this.valueTable.clone();
            return key;
        }

        public double[] getGraphValues() {
            String[] names = this.script.paramName;
            double[] values = new double[names.length];
            for (int i = 0; i < names.length; ++i) {
                Double d = (Double)this.valueTable.get(names[i]);
                values[i] = d == null ? this.script.paramValue[i] : d;
            }
            return values;
        }

        public void setGraphValues(double[] values) {
            String[] names = this.script.paramName;
            for (int i = 0; i < names.length; ++i) {
                this.valueTable.put(names[i], new Double(values[i]));
            }
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            return this.blend(new Keyframe[]{this, o2}, new double[]{weight1, weight2});
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            return this.blend(new Keyframe[]{this, o2, o3}, new double[]{weight1, weight2, weight3});
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            return this.blend(new Keyframe[]{this, o2, o3, o4}, new double[]{weight1, weight2, weight3, weight4});
        }

        private Keyframe blend(Keyframe[] k, double[] weight) {
            String[] names = this.script.paramName;
            double[] values = new double[names.length];
            for (int i = 0; i < names.length; ++i) {
                double d = 0.0;
                for (int j = 0; j < k.length; ++j) {
                    ScriptedObjectKeyframe key = (ScriptedObjectKeyframe)k[j];
                    Double v = (Double)key.valueTable.get(names[i]);
                    if (v == null) continue;
                    d += weight[j] * v;
                }
                values[i] = d;
            }
            return new ScriptedObjectKeyframe(this.script, names, values);
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof ScriptedObjectKeyframe)) {
                return false;
            }
            ScriptedObjectKeyframe key = (ScriptedObjectKeyframe)k;
            String[] names = this.script.paramName;
            for (int i = 0; i < names.length; ++i) {
                Double d1 = (Double)this.valueTable.get(names[i]);
                Double d2 = (Double)key.valueTable.get(names[i]);
                if (d1 == null && d2 == null) continue;
                if (d1 == null || d2 == null) {
                    return false;
                }
                double diff = d1 - d2;
                if (!(diff > 1.0E-12) && !(diff < -1.0E12)) continue;
                return false;
            }
            return true;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeShort(0);
            double[] values = this.getGraphValues();
            for (int i = 0; i < values.length; ++i) {
                out.writeDouble(values[i]);
            }
        }

        public ScriptedObjectKeyframe(DataInputStream in, Object parent) throws IOException {
            int i;
            short version = in.readShort();
            if (version != 0) {
                throw new InvalidObjectException("");
            }
            this.script = (ScriptedObject)((ObjectInfo)parent).object;
            double[] values = new double[this.script.paramName.length];
            for (i = 0; i < values.length; ++i) {
                values[i] = in.readDouble();
            }
            this.valueTable = new Hashtable();
            for (i = 0; i < values.length; ++i) {
                this.valueTable.put(this.script.paramName[i], new Double(values[i]));
            }
        }
    }
}

