/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import java.awt.Point;

public class SqrtModule
extends Module {
    boolean valueOk;
    boolean errorOk;
    boolean gradOk;
    double value;
    double error;
    double valueIn;
    double errorIn;
    double lastBlur;
    Vec3 gradient = new Vec3();

    public SqrtModule(Point position) {
        super("Sqrt", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Value", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Root"})}, position);
    }

    public void init(PointInfo p) {
        this.gradOk = false;
        this.errorOk = false;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        if (this.linkFrom[0] == null) {
            this.error = 0.0;
            this.value = 0.0;
            this.errorOk = true;
            return 0.0;
        }
        this.valueIn = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        this.errorIn = this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        if (this.errorIn == 0.0) {
            this.value = this.valueIn < 0.0 ? -Math.sqrt(-this.valueIn) : Math.sqrt(this.valueIn);
            this.error = 0.0;
            this.errorOk = true;
            return this.value;
        }
        this.value = (this.integral(this.valueIn + this.errorIn) - this.integral(this.valueIn - this.errorIn)) / (2.0 * this.errorIn);
        return this.value;
    }

    private double integral(double x) {
        if (x > 0.0) {
            return 0.6666666666666666 * Math.pow(x, 1.5);
        }
        return 0.6666666666666666 * Math.pow(-x, 1.5);
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        if (this.errorOk) {
            return this.error;
        }
        this.errorOk = true;
        if (this.errorIn == 0.0) {
            this.error = 0.0;
            return 0.0;
        }
        this.error /= 2.0 * Math.sqrt(Math.abs(this.valueIn));
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.gradOk && blur == this.lastBlur) {
            grad.set(this.gradient);
            return;
        }
        if (this.linkFrom[0] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        this.gradOk = true;
        this.linkFrom[0].getValueGradient(this.linkFromIndex[0], this.gradient, blur);
        this.gradient.scale(0.5 / this.value);
        grad.set(this.gradient);
    }
}

