/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.Translate;
import java.awt.Point;

public class SphericalModule
extends Module {
    double[] value = new double[3];
    double[] error = new double[3];
    double r1;
    double r2;
    double r2inv;
    double lastBlur;
    boolean[] valueOk = new boolean[3];
    boolean rOk;
    Vec3[] gradient = new Vec3[]{new Vec3(), new Vec3(), new Vec3()};
    Vec3 tempVec1 = new Vec3();
    Vec3 tempVec2 = new Vec3();
    Vec3 tempVec3 = new Vec3();
    PointInfo point;

    public SphericalModule(Point position) {
        super(Translate.text("menu.sphericalModule"), new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"}), new IOPort(0, 0, 2, new String[]{"Z", "(Z)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"R"}), new IOPort(0, 1, 3, new String[]{"Theta"}), new IOPort(0, 1, 3, new String[]{"Phi"})}, position);
    }

    public void init(PointInfo p) {
        this.point = p;
        this.rOk = false;
        this.valueOk[2] = false;
        this.valueOk[1] = false;
        this.valueOk[0] = false;
    }

    public double getAverageValue(int which, double blur) {
        double zerror;
        double z;
        double yerror;
        double y;
        double xerror;
        double x;
        if (this.valueOk[which] && blur == this.lastBlur) {
            return this.value[which];
        }
        this.lastBlur = blur;
        if (this.linkFrom[0] == null) {
            x = this.point.x;
            xerror = 0.5 * this.point.xsize + blur;
            this.tempVec1.set(1.0, 0.0, 0.0);
        } else {
            x = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
            xerror = this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
            this.linkFrom[0].getValueGradient(this.linkFromIndex[0], this.tempVec1, blur);
        }
        if (this.linkFrom[1] == null) {
            y = this.point.y;
            yerror = 0.5 * this.point.ysize + blur;
            this.tempVec2.set(0.0, 1.0, 0.0);
        } else {
            y = this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
            yerror = this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
            this.linkFrom[1].getValueGradient(this.linkFromIndex[1], this.tempVec2, blur);
        }
        if (this.linkFrom[2] == null) {
            z = this.point.z;
            zerror = 0.5 * this.point.zsize + blur;
            this.tempVec3.set(0.0, 0.0, 1.0);
        } else {
            z = this.linkFrom[2].getAverageValue(this.linkFromIndex[2], blur);
            zerror = this.linkFrom[2].getValueError(this.linkFromIndex[2], blur);
            this.linkFrom[2].getValueGradient(this.linkFromIndex[2], this.tempVec3, blur);
        }
        if (!this.valueOk[0]) {
            this.r2 = x * x + y * y + z * z;
            this.value[0] = Math.sqrt(this.r2);
            if (this.value[0] == 0.0) {
                this.gradient[0].set(0.0, 0.0, 0.0);
                this.error[0] = Math.sqrt(xerror * xerror + yerror * yerror + zerror * zerror);
            } else {
                this.gradient[0].set(x * this.tempVec1.x + y * this.tempVec2.x + z * this.tempVec3.x, x * this.tempVec1.y + y * this.tempVec2.y + z * this.tempVec3.y, x * this.tempVec1.z + y * this.tempVec2.z + z * this.tempVec3.z);
                this.gradient[0].scale(1.0 / this.value[0]);
                this.error[0] = (Math.abs(x * xerror) + Math.abs(y * yerror) + Math.abs(z * zerror)) / this.value[0];
            }
            this.valueOk[0] = true;
        }
        if (which != 0 && !this.rOk) {
            this.r2inv = 1.0 / this.r2;
            this.r1 = x * x + y * y;
        }
        if (which == 1) {
            double p = Math.sqrt(this.r1);
            this.value[1] = Math.atan2(p, z);
            this.gradient[1].set(x * z * this.tempVec1.x + y * z * this.tempVec2.x - this.r1 * this.tempVec3.x, x * z * this.tempVec1.y + y * z * this.tempVec2.y - this.r1 * this.tempVec3.y, x * z * this.tempVec1.z + y * z * this.tempVec2.z - this.r1 * this.tempVec3.z);
            double inv = 1.0 / (p * this.r2);
            this.gradient[1].scale(inv);
            this.error[1] = 1.5 * (Math.abs(x * z * xerror) + Math.abs(y * z * yerror) + Math.abs(this.r1 * zerror)) * inv;
            this.valueOk[1] = true;
        }
        if (which == 2) {
            this.value[2] = Math.atan2(y, x);
            this.gradient[2].set(-y * this.tempVec1.x + x * this.tempVec2.x, -y * this.tempVec1.y + x * this.tempVec2.y, -y * this.tempVec1.z + x * this.tempVec2.z);
            double inv = 1.0 / this.r1;
            this.gradient[2].scale(inv);
            this.error[2] = 1.5 * (Math.abs(y * xerror) + Math.abs(x * yerror)) * inv;
            this.valueOk[2] = true;
        }
        return this.value[which];
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk[which] || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        return this.error[which];
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (!this.valueOk[which] || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        grad.set(this.gradient[which]);
    }
}

