/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Link;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.PointInfo;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class Procedure {
    OutputModule[] output;
    Module[] module;
    Link[] link;
    static /* synthetic */ Class class$java$awt$Point;

    public Procedure(OutputModule[] output) {
        this.output = output;
        this.module = new Module[0];
        this.link = new Link[0];
    }

    public OutputModule[] getOutputModules() {
        return this.output;
    }

    public Module[] getModules() {
        return this.module;
    }

    public int getModuleIndex(Module mod) {
        for (int i = 0; i < this.module.length; ++i) {
            if (this.module[i] != mod) continue;
            return i;
        }
        return -1;
    }

    public int getOutputIndex(Module mod) {
        for (int i = 0; i < this.output.length; ++i) {
            if (this.output[i] != mod) continue;
            return i;
        }
        return -1;
    }

    public void addModule(Module mod) {
        Module[] newmod = new Module[this.module.length + 1];
        for (int i = 0; i < this.module.length; ++i) {
            newmod[i] = this.module[i];
        }
        newmod[this.module.length] = mod;
        this.module = newmod;
    }

    public void deleteModule(int which) {
        Module[] newmod = new Module[this.module.length - 1];
        int j = 0;
        for (int i = 0; i < this.module.length; ++i) {
            if (i == which) continue;
            newmod[j++] = this.module[i];
        }
        this.module = newmod;
    }

    public Link[] getLinks() {
        return this.link;
    }

    public void addLink(Link ln) {
        Link[] newlink = new Link[this.link.length + 1];
        for (int i = 0; i < this.link.length; ++i) {
            newlink[i] = this.link[i];
        }
        newlink[this.link.length] = ln;
        this.link = newlink;
        ln.to.getModule().setInput(ln.to, ln.from);
    }

    public void deleteLink(int which) {
        Link[] newlink = new Link[this.link.length - 1];
        if (this.link[which].to.getType() == 0) {
            this.link[which].to.getModule().setInput(this.link[which].to, null);
        } else {
            this.link[which].from.getModule().setInput(this.link[which].from, null);
        }
        int j = 0;
        for (int i = 0; i < this.link.length; ++i) {
            if (i == which) continue;
            newlink[j++] = this.link[i];
        }
        this.link = newlink;
    }

    public boolean checkFeedback() {
        for (int i = 0; i < this.output.length; ++i) {
            int j;
            for (j = 0; j < this.output.length; ++j) {
                this.output[j].checked = false;
            }
            for (j = 0; j < this.module.length; ++j) {
                this.module[j].checked = false;
            }
            if (!this.output[i].checkFeedback()) continue;
            return true;
        }
        return false;
    }

    public void initForPoint(PointInfo p) {
        for (int i = 0; i < this.module.length; ++i) {
            this.module[i].init(p);
        }
    }

    public double getOutputValue(int which) {
        return this.output[which].getAverageValue(0, 0.0);
    }

    public void getOutputGradient(int which, Vec3 grad) {
        this.output[which].getValueGradient(0, grad, 0.0);
    }

    public void getOutputColor(int which, RGBColor color) {
        this.output[which].getColor(0, color, 0.0);
    }

    public void copy(Procedure proc) {
        int i;
        this.module = new Module[proc.module.length];
        for (i = 0; i < this.module.length; ++i) {
            this.module[i] = proc.module[i].duplicate();
        }
        this.link = new Link[proc.link.length];
        for (i = 0; i < this.link.length; ++i) {
            Module fromModule = proc.link[i].from.getModule();
            Module toModule = proc.link[i].to.getModule();
            int fromIndex = proc.getModuleIndex(fromModule);
            int toIndex = toModule instanceof OutputModule ? proc.getOutputIndex(toModule) : proc.getModuleIndex(toModule);
            IOPort from = this.module[fromIndex].getOutputPorts()[proc.module[fromIndex].getOutputIndex(proc.link[i].from)];
            IOPort to = toModule instanceof OutputModule ? this.output[toIndex].getInputPorts()[proc.output[toIndex].getInputIndex(proc.link[i].to)] : this.module[toIndex].getInputPorts()[proc.module[toIndex].getInputIndex(proc.link[i].to)];
            this.link[i] = new Link(from, to);
            to.getModule().setInput(to, from);
        }
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        int i;
        out.writeShort(0);
        out.writeInt(this.module.length);
        for (i = 0; i < this.module.length; ++i) {
            out.writeUTF(this.module[i].getClass().getName());
            out.writeInt(this.module[i].getBounds().x);
            out.writeInt(this.module[i].getBounds().y);
            this.module[i].writeToStream(out, theScene);
        }
        out.writeInt(this.link.length);
        for (i = 0; i < this.link.length; ++i) {
            out.writeInt(this.getModuleIndex(this.link[i].from.getModule()));
            out.writeInt(this.link[i].from.getModule().getOutputIndex(this.link[i].from));
            if (this.link[i].to.getModule() instanceof OutputModule) {
                out.writeInt(-this.getOutputIndex(this.link[i].to.getModule()) - 1);
                continue;
            }
            out.writeInt(this.getModuleIndex(this.link[i].to.getModule()));
            out.writeInt(this.link[i].to.getModule().getInputIndex(this.link[i].to));
        }
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        int i;
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        for (i = 0; i < this.output.length; ++i) {
            this.output[i].setInput(this.output[i].getInputPorts()[0], null);
        }
        this.module = new Module[in.readInt()];
        try {
            for (i = 0; i < this.module.length; ++i) {
                String classname = in.readUTF();
                Point p = new Point(in.readInt(), in.readInt());
                Class cls = ModellingApp.getClass(classname);
                Constructor con = cls.getConstructor(class$java$awt$Point == null ? Procedure.class$("java.awt.Point") : class$java$awt$Point);
                this.module[i] = (Module)con.newInstance(p);
                this.module[i].readFromStream(in, theScene);
            }
        }
        catch (InvocationTargetException ex) {
            ex.getTargetException().printStackTrace();
            throw new IOException();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException();
        }
        this.link = new Link[in.readInt()];
        for (i = 0; i < this.link.length; ++i) {
            IOPort from = this.module[in.readInt()].getOutputPorts()[in.readInt()];
            int j = in.readInt();
            IOPort to = j < 0 ? this.output[-j - 1].getInputPorts()[0] : this.module[j].getInputPorts()[in.readInt()];
            this.link[i] = new Link(from, to);
            to.getModule().setInput(to, from);
        }
    }
}

