/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import java.awt.Point;

public class ExpModule
extends Module {
    boolean valueOk;
    boolean errorOk;
    boolean gradOk;
    double value;
    double error;
    double valueIn;
    double errorIn;
    double lastBlur;
    Vec3 gradient = new Vec3();

    public ExpModule(Point position) {
        super("Exp", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Value", "(1)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Exponential"})}, position);
    }

    public void init(PointInfo p) {
        this.gradOk = false;
        this.errorOk = false;
        this.valueOk = false;
    }

    public double getAverageValue(int which, double blur) {
        if (this.valueOk && blur == this.lastBlur) {
            return this.value;
        }
        this.valueOk = true;
        this.lastBlur = blur;
        if (this.linkFrom[0] == null) {
            this.error = 0.0;
            this.value = 0.0;
            return 0.0;
        }
        this.valueIn = this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        this.errorIn = this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        if (this.errorIn == 0.0) {
            this.value = Math.exp(this.valueIn);
            this.error = 0.0;
            return this.value;
        }
        this.value = (Math.exp(this.valueIn + this.errorIn) - Math.exp(this.valueIn - this.errorIn)) / (2.0 * this.errorIn);
        this.error = this.errorIn * this.value;
        return this.value;
    }

    public double getValueError(int which, double blur) {
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        return this.error;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.gradOk && blur == this.lastBlur) {
            grad.set(this.gradient);
            return;
        }
        if (this.linkFrom[0] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (!this.valueOk || blur != this.lastBlur) {
            this.getAverageValue(which, blur);
        }
        this.gradOk = true;
        this.linkFrom[0].getValueGradient(this.linkFromIndex[0], this.gradient, blur);
        this.gradient.scale(this.valueIn);
        grad.set(this.gradient);
    }
}

