/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.Property;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.ViewerCanvas;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.Skeleton;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.ConstantParameterValue;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.view.ConstantVertexShader;
import artofillusion.view.FlatVertexShader;
import artofillusion.view.SmoothVertexShader;
import artofillusion.view.TexturedVertexShader;
import artofillusion.view.VertexShader;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;

public abstract class Object3D {
    protected Texture theTexture;
    protected Material theMaterial;
    protected TextureMapping texMapping;
    protected MaterialMapping matMapping;
    protected TextureParameter[] texParam;
    protected ParameterValue[] paramValue;
    public static final int CANT_CONVERT = 0;
    public static final int EXACTLY = 1;
    public static final int APPROXIMATELY = 2;

    public Object3D() {
    }

    public abstract Object3D duplicate();

    public abstract void copyObject(Object3D var1);

    public abstract BoundingBox getBounds();

    public abstract void setSize(double var1, double var3, double var5);

    public boolean isClosed() {
        return true;
    }

    public int canConvertToTriangleMesh() {
        return 0;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        return null;
    }

    public void sceneChanged(ObjectInfo info, Scene scene) {
    }

    public boolean isEditable() {
        return false;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
    }

    public void editGesture(EditingWindow parent, ObjectInfo info, Runnable cb, ObjectInfo realObject) {
        this.edit(parent, info, cb);
    }

    public boolean canSetTexture() {
        return true;
    }

    public boolean canSetMaterial() {
        return this.canSetTexture() && this.isClosed();
    }

    public void setTexture(Texture tex, TextureMapping map) {
        this.theTexture = tex;
        this.texMapping = map;
        if (map instanceof LayeredMapping) {
            this.theTexture = ((LayeredMapping)map).getTexture();
        }
        if (map == null) {
            this.setParameters(new TextureParameter[0]);
            this.setParameterValues(new ParameterValue[0]);
        } else {
            TextureParameter[] oldParam = this.getParameters();
            ParameterValue[] oldValue = this.getParameterValues();
            TextureParameter[] newParam = map.getParameters();
            ParameterValue[] newVal = new ParameterValue[newParam.length];
            for (int i = 0; i < newParam.length; ++i) {
                if (oldParam != null) {
                    for (int j = 0; j < oldParam.length; ++j) {
                        if (!newParam[i].equals(oldParam[j])) continue;
                        newVal[i] = oldValue[j];
                        break;
                    }
                }
                if (newVal[i] != null) continue;
                newVal[i] = newParam[i].type == 0 || !(this instanceof Mesh) ? new ConstantParameterValue(newParam[i].defaultVal) : new VertexParameterValue((Mesh)((Object)this), newParam[i]);
            }
            this.setParameters(newParam);
            this.setParameterValues(newVal);
        }
    }

    public Texture getTexture() {
        return this.theTexture;
    }

    public TextureMapping getTextureMapping() {
        return this.texMapping;
    }

    public void setMaterial(Material mat, MaterialMapping map) {
        this.theMaterial = mat;
        this.matMapping = map;
    }

    public Material getMaterial() {
        return this.theMaterial;
    }

    public MaterialMapping getMaterialMapping() {
        return this.matMapping;
    }

    public TextureParameter[] getParameters() {
        return this.texParam;
    }

    public void setParameters(TextureParameter[] param) {
        this.texParam = param;
    }

    public ParameterValue[] getParameterValues() {
        return this.paramValue;
    }

    public double[] getAverageParameterValues() {
        if (this.paramValue == null) {
            return new double[0];
        }
        double[] d = new double[this.paramValue.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.paramValue[i].getAverageValue();
        }
        return d;
    }

    public void setParameterValues(ParameterValue[] val) {
        this.paramValue = val;
    }

    public ParameterValue getParameterValue(TextureParameter param) {
        for (int i = 0; i < this.texParam.length; ++i) {
            if (!this.texParam[i].equals(param)) continue;
            return this.paramValue[i];
        }
        return null;
    }

    public void setParameterValue(TextureParameter param, ParameterValue val) {
        for (int i = 0; i < this.texParam.length; ++i) {
            if (!this.texParam[i].equals(param)) continue;
            this.paramValue[i] = val;
            return;
        }
    }

    public void copyTextureAndMaterial(Object3D obj) {
        if (obj.getTextureMapping() != null) {
            this.setTexture(obj.getTexture(), obj.getTextureMapping().duplicate(this, obj.getTexture()));
        }
        if (obj.getMaterialMapping() != null) {
            this.setMaterial(obj.getMaterial(), obj.getMaterialMapping().duplicate(this, obj.getMaterial()));
        } else {
            this.setMaterial(null, null);
        }
        TextureParameter[] objParam = obj.getParameters();
        if (objParam != null) {
            TextureParameter[] thisParam = new TextureParameter[objParam.length];
            ParameterValue[] objValue = obj.getParameterValues();
            ParameterValue[] thisValue = new ParameterValue[objValue.length];
            for (int i = 0; i < thisValue.length; ++i) {
                thisParam[i] = i < this.texParam.length ? this.texParam[i] : objParam[i];
                thisValue[i] = objValue[i].duplicate();
            }
            this.setParameters(thisParam);
            this.setParameterValues(thisValue);
        }
    }

    public Skeleton getSkeleton() {
        return null;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        return null;
    }

    public abstract WireframeMesh getWireframeMesh();

    public void renderObject(ObjectInfo obj, ViewerCanvas canvas, Vec3 viewDir) {
        if (!obj.visible) {
            return;
        }
        Camera theCamera = canvas.getCamera();
        if (theCamera.visibility(obj.getBounds()) == 0) {
            return;
        }
        int renderMode = canvas.getRenderMode();
        if (renderMode == 0) {
            canvas.renderWireframe(obj.getWireframePreview(), theCamera, ViewerCanvas.lineColor);
            return;
        }
        RenderingMesh mesh = obj.getPreviewMesh();
        if (mesh != null) {
            if (renderMode == 4) {
                ConstantVertexShader shader = new ConstantVertexShader(ViewerCanvas.transparentColor);
                canvas.renderMeshTransparent(mesh, shader, theCamera, theCamera.getViewToWorld().timesDirection(Vec3.vz()), null);
            } else {
                double time = 0.0;
                if (canvas.getScene() != null) {
                    time = canvas.getScene().getTime();
                }
                VertexShader shader = renderMode == 1 ? new FlatVertexShader(mesh, obj.object, time, obj.coords.toLocal().timesDirection(viewDir)) : (renderMode == 2 ? new SmoothVertexShader(mesh, obj.object, time, obj.coords.toLocal().timesDirection(viewDir)) : new TexturedVertexShader(mesh, obj.object, time, obj.coords.toLocal().timesDirection(viewDir)).optimize());
                canvas.renderMesh(mesh, shader, theCamera, obj.object.isClosed(), null);
            }
        } else {
            canvas.renderWireframe(obj.getWireframePreview(), theCamera, ViewerCanvas.lineColor);
        }
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(1);
        if (this.canSetTexture()) {
            if (this.theMaterial == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(theScene.indexOf(this.theMaterial));
                out.writeUTF(this.matMapping.getClass().getName());
                this.matMapping.writeToFile(out);
            }
            if (this.theTexture instanceof LayeredTexture) {
                out.writeInt(-1);
                ((LayeredMapping)this.texMapping).writeToFile(out, theScene);
            } else {
                out.writeInt(theScene.indexOf(this.theTexture));
                out.writeUTF(this.texMapping.getClass().getName());
                this.texMapping.writeToFile(out);
            }
            for (int i = 0; i < this.paramValue.length; ++i) {
                out.writeUTF(this.paramValue[i].getClass().getName());
                this.paramValue[i].writeToStream(out);
            }
        }
    }

    public Object3D(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        Constructor con;
        Class mapClass;
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        if (!this.canSetTexture()) {
            return;
        }
        int i = in.readInt();
        if (i > -1) {
            try {
                mapClass = ModellingApp.getClass(in.readUTF());
                con = mapClass.getConstructor(DataInputStream.class, Object3D.class, Material.class);
                this.theMaterial = theScene.getMaterial(i);
                this.setMaterial(this.theMaterial, (MaterialMapping)con.newInstance(in, this, this.theMaterial));
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
        }
        if ((i = in.readInt()) > -1) {
            try {
                mapClass = ModellingApp.getClass(in.readUTF());
                con = mapClass.getConstructor(DataInputStream.class, Object3D.class, Texture.class);
                this.theTexture = theScene.getTexture(i);
                this.setTexture(this.theTexture, (TextureMapping)con.newInstance(in, this, this.theTexture));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
        } else {
            LayeredTexture tex = new LayeredTexture(this);
            LayeredMapping map = (LayeredMapping)tex.getDefaultMapping(this);
            map.readFromFile(in, theScene);
            this.setTexture(tex, map);
        }
        this.paramValue = new ParameterValue[this.texParam.length];
        if (version > 0) {
            for (i = 0; i < this.paramValue.length; ++i) {
                this.paramValue[i] = Object3D.readParameterValue(in);
            }
        }
        this.setParameterValues(this.paramValue);
    }

    public static ParameterValue readParameterValue(DataInputStream in) throws IOException {
        try {
            Class valueClass = ModellingApp.getClass(in.readUTF());
            Constructor con = valueClass.getConstructor(DataInputStream.class);
            return (ParameterValue)con.newInstance(in);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public Property[] getProperties() {
        return new Property[0];
    }

    public Object getPropertyValue(int index) {
        return null;
    }

    public void setPropertyValue(int index, Object value) {
    }

    public abstract Keyframe getPoseKeyframe();

    public abstract void applyPoseKeyframe(Keyframe var1);

    public void configurePoseTrack(PoseTrack track) {
        track.setGraphableValues(new String[0], new double[0], new double[0][2]);
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        new BStandardDialog("", Translate.text("noParamsForKeyframe"), BStandardDialog.INFORMATION).showMessageDialog((Widget)((Object)parent));
    }

    public boolean canConvertToActor() {
        return false;
    }

    public Object3D getPosableObject() {
        return this;
    }
}

