/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public abstract class ImplicitObject
extends Object3D {
    public abstract double getFieldValue(double var1, double var3, double var5, double var7, double var9);

    public void getFieldGradient(double x, double y, double z, double size, double time, Vec3 grad) {
        double delta = 0.5 * size;
        double invDelta = 1.0 / delta;
        double val = this.getFieldValue(x, y, z, size, time);
        grad.x = (this.getFieldValue(x + delta, y, z, size, time) - val) * invDelta;
        grad.y = (this.getFieldValue(x, y + delta, z, size, time) - val) * invDelta;
        grad.z = (this.getFieldValue(x, y, z + delta, size, time) - val) * invDelta;
    }

    public double getMaxGradient() {
        return Double.MAX_VALUE;
    }

    public double getCutoff() {
        return 1.0;
    }

    public abstract boolean getPreferDirectRendering();

    public ImplicitObject() {
    }

    public ImplicitObject(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
    }
}

