/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

import artofillusion.math.FastMath;
import buoy.widget.BOutline;
import buoy.widget.CustomWidget;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;

public class RGBColor {
    public float red;
    public float green;
    public float blue;
    private static final float ERGB_SCALE = 0.003921569f;
    private static final float INVLOG2 = 1.0f / (float)Math.log(2.0);
    public static final float[] ERGB_EXP_SCALE = new float[256];

    public RGBColor() {
    }

    public RGBColor(float r, float g, float b) {
        this.setRGB(r, g, b);
    }

    public RGBColor(double r, double g, double b) {
        this.setRGB(r, g, b);
    }

    public final void setRGB(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public final void setRGB(double r, double g, double b) {
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
    }

    public final float getRed() {
        return this.red;
    }

    public final float getGreen() {
        return this.green;
    }

    public final float getBlue() {
        return this.blue;
    }

    public boolean equals(Object c) {
        if (c instanceof RGBColor) {
            RGBColor col = (RGBColor)c;
            return col.red == this.red && col.green == this.green && col.blue == this.blue;
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.red + 10.0f * this.green + 100.0f * this.blue);
    }

    public final RGBColor duplicate() {
        return new RGBColor(this.red, this.green, this.blue);
    }

    public final void copy(RGBColor color) {
        this.setRGB(color.red, color.green, color.blue);
    }

    public final Color getColor() {
        float r = this.red;
        float g = this.green;
        float b = this.blue;
        if (r < 0.0f) {
            r = 0.0f;
        }
        if (r > 1.0f) {
            r = 1.0f;
        }
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (g > 1.0f) {
            g = 1.0f;
        }
        if (b < 0.0f) {
            b = 0.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        return new Color(r, g, b);
    }

    public Widget getSample(int width, int height) {
        final CustomWidget w = new CustomWidget();
        w.setPreferredSize(new Dimension(width, height));
        w.setMaximumSize(new Dimension(width, height));
        w.setBackground(this.getColor());
        BOutline outline = new BOutline(w, BorderFactory.createLoweredBevelBorder()){

            public void setBackground(Color c) {
                w.setBackground(c);
            }
        };
        return outline;
    }

    public final int getARGB() {
        int r = (int)((double)this.red * 255.0);
        int g = (int)((double)this.green * 255.0);
        int b = (int)((double)this.blue * 255.0);
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    public final void setARGB(int color) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        this.setRGB((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public final void add(RGBColor color) {
        this.red += color.red;
        this.green += color.green;
        this.blue += color.blue;
    }

    public final void subtract(RGBColor color) {
        this.red -= color.red;
        this.green -= color.green;
        this.blue -= color.blue;
    }

    public final void multiply(RGBColor color) {
        this.red *= color.red;
        this.green *= color.green;
        this.blue *= color.blue;
    }

    public final void add(float r, float g, float b) {
        this.red += r;
        this.green += g;
        this.blue += b;
    }

    public final void subtract(float r, float g, float b) {
        this.red -= r;
        this.green -= g;
        this.blue -= b;
    }

    public final void multiply(float r, float g, float b) {
        this.red *= r;
        this.green *= g;
        this.blue *= b;
    }

    public final void scale(float s) {
        this.red *= s;
        this.green *= s;
        this.blue *= s;
    }

    public final void scale(double s) {
        float f = (float)s;
        this.red *= f;
        this.green *= f;
        this.blue *= f;
    }

    public final void clip() {
        if (this.red < 0.0f) {
            this.red = 0.0f;
        }
        if (this.red > 1.0f) {
            this.red = 1.0f;
        }
        if (this.green < 0.0f) {
            this.green = 0.0f;
        }
        if (this.green > 1.0f) {
            this.green = 1.0f;
        }
        if (this.blue < 0.0f) {
            this.blue = 0.0f;
        }
        if (this.blue > 1.0f) {
            this.blue = 1.0f;
        }
    }

    public final float getBrightness() {
        return 0.2125f * this.red + 0.7154f * this.green + 0.0721f * this.blue;
    }

    public final float getMaxComponent() {
        float max;
        float f = max = this.green > this.red ? this.green : this.red;
        if (this.blue > max) {
            max = this.blue;
        }
        return max;
    }

    public final void setHSV(float h, float s, float v) {
        if (s == 0.0f) {
            this.setRGB(v, v, v);
            return;
        }
        h = h == 360.0f ? 0.0f : (h /= 60.0f);
        int i = (int)h;
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                this.setRGB(v, t, p);
                break;
            }
            case 1: {
                this.setRGB(q, v, p);
                break;
            }
            case 2: {
                this.setRGB(p, v, t);
                break;
            }
            case 3: {
                this.setRGB(p, q, v);
                break;
            }
            case 4: {
                this.setRGB(t, p, v);
                break;
            }
            case 5: {
                this.setRGB(v, p, q);
            }
        }
    }

    public final float[] getHSV() {
        float min;
        float max = Math.max(this.red, Math.max(this.blue, this.green));
        if (max == (min = Math.min(this.red, Math.min(this.blue, this.green)))) {
            return new float[]{0.0f, 0.0f, max};
        }
        float h = this.red == max ? (this.green - this.blue) / (max - min) : (this.green == max ? 2.0f + (this.blue - this.red) / (max - min) : 4.0f + (this.red - this.green) / (max - min));
        if ((h *= 60.0f) < 0.0f) {
            h += 360.0f;
        }
        return new float[]{h, (max - min) / max, max};
    }

    public final void setHLS(float h, float l, float s) {
        float m2 = l <= 0.5f ? l + l * s : l + s - l * s;
        float m1 = 2.0f * l - m2;
        if (s == 0.0f) {
            this.setRGB(l, l, l);
        } else {
            this.setRGB(RGBColor.value(m1, m2, h + 120.0f), RGBColor.value(m1, m2, h), RGBColor.value(m1, m2, h - 120.0f));
        }
    }

    private static final float value(float n1, float n2, float hue) {
        if (hue > 360.0f) {
            hue -= 360.0f;
        } else if (hue < 0.0f) {
            hue += 360.0f;
        }
        if (hue < 60.0f) {
            return n1 + (n2 - n1) * hue / 60.0f;
        }
        if (hue < 180.0f) {
            return n2;
        }
        if (hue < 240.0f) {
            return n1 + (n2 - n1) * (240.0f - hue) / 60.0f;
        }
        return n1;
    }

    public final float[] getHLS() {
        float min;
        float max = Math.max(this.red, Math.max(this.blue, this.green));
        if (max == (min = Math.min(this.red, Math.min(this.blue, this.green)))) {
            return new float[]{0.0f, max, 0.0f};
        }
        float l = (max + min) / 2.0f;
        float delta = max - min;
        float h = this.red == max ? (this.green - this.blue) / delta : (this.green == max ? 2.0f + (this.blue - this.red) / delta : 4.0f + (this.red - this.green) / delta);
        if ((h *= 60.0f) < 0.0f) {
            h += 360.0f;
        }
        if (l < 0.5f) {
            return new float[]{h, l, delta / (max + min)};
        }
        return new float[]{h, l, delta / (2.0f - max - min)};
    }

    public final int getERGB() {
        float max = this.red;
        if (this.green > max) {
            max = this.green;
        }
        if (this.blue > max) {
            max = this.blue;
        }
        if (max * 0.003921569f < ERGB_EXP_SCALE[0]) {
            return 0;
        }
        int exp = 128 + FastMath.ceil(Math.log(max) * (double)INVLOG2);
        float scale = 1.0f / ERGB_EXP_SCALE[exp];
        byte e = (byte)exp;
        byte r = (byte)FastMath.round(this.red * scale);
        byte g = (byte)FastMath.round(this.green * scale);
        byte b = (byte)FastMath.round(this.blue * scale);
        return ((e & 0xFF) << 24) + ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF);
    }

    public final void setERGB(int ergb) {
        float scale = ERGB_EXP_SCALE[ergb >> 24 & 0xFF];
        this.setRGB((float)(ergb >> 16 & 0xFF) * scale, (float)(ergb >> 8 & 0xFF) * scale, (float)(ergb & 0xFF) * scale);
    }

    public final void setERGB(byte r, byte g, byte b, byte e) {
        float scale = ERGB_EXP_SCALE[e & 0xFF];
        this.setRGB((float)(r & 0xFF) * scale, (float)(g & 0xFF) * scale, (float)(b & 0xFF) * scale);
    }

    public final float[] getYCrCb() {
        float Y = 0.257f * this.red + 0.504f * this.green + 0.098f * this.blue + 0.0625f;
        float Cr = 0.439f * this.red - 0.368f * this.green - 0.071f * this.blue + 0.5f;
        float Cb = -(0.148f * this.red) - 0.291f * this.green + 0.439f * this.blue + 0.5f;
        Y = Math.max(0.0f, Math.min(1.0f, Y));
        Cr = Math.max(0.0f, Math.min(1.0f, Cr));
        Cb = Math.max(0.0f, Math.min(1.0f, Cb));
        return new float[]{Y, Cr, Cb};
    }

    public final void setYCrCb(float Y, float Cr, float Cb) {
        Y = 1.164f * (Y - 0.0625f);
        this.red = Y + 1.596f * (Cr -= 0.5f);
        this.green = Y - 0.813f * Cr - 0.391f * (Cb -= 0.5f);
        this.blue = Y + 2.018f * Cb;
        this.red = Math.max(0.0f, Math.min(1.0f, this.red));
        this.green = Math.max(0.0f, Math.min(1.0f, this.green));
        this.blue = Math.max(0.0f, Math.min(1.0f, this.blue));
    }

    public RGBColor(DataInputStream in) throws IOException {
        this.red = in.readFloat();
        this.green = in.readFloat();
        this.blue = in.readFloat();
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeFloat(this.red);
        out.writeFloat(this.green);
        out.writeFloat(this.blue);
    }

    public String toString() {
        return "RGBColor: " + this.red + ", " + this.green + ", " + this.blue;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            RGBColor.ERGB_EXP_SCALE[i] = (float)(0.003921568859368563 * FastMath.pow(2.0, i - 128));
        }
    }
}

