/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.material;

import artofillusion.MaterialPreviewer;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.material.MaterialSpec;
import artofillusion.material.UniformMaterial;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import buoy.widget.CustomWidget;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class UniformMaterialMapping
extends MaterialMapping {
    public UniformMaterialMapping(Object3D theObject, Material theMaterial) {
        super(theObject, theMaterial);
    }

    public double getStepSize() {
        return this.material.getStepSize();
    }

    public void getMaterialSpec(Vec3 pos, MaterialSpec spec, double size, double t) {
        ((UniformMaterial)this.material).getMaterialSpec(spec);
    }

    public static boolean legalMapping(Object3D obj, Material mat) {
        return mat instanceof UniformMaterial;
    }

    public MaterialMapping duplicate() {
        return new UniformMaterialMapping(this.object, this.material);
    }

    public MaterialMapping duplicate(Object3D obj, Material mat) {
        return new UniformMaterialMapping(obj, mat);
    }

    public void copy(MaterialMapping map) {
        this.material = map.material;
    }

    public Widget getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return new CustomWidget();
    }

    public UniformMaterialMapping(DataInputStream in, Object3D theObject, Material theMaterial) throws IOException, InvalidObjectException {
        super(theObject, theMaterial);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.material = theMaterial;
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(0);
    }
}

