/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.SceneCamera;
import artofillusion.ui.Translate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BrightnessFilter
extends ImageFilter {
    public String getName() {
        return Translate.text("Brightness");
    }

    public void filterImage(ComplexImage image, Scene scene, SceneCamera camera, CoordinateSystem cameraPos) {
        this.filterComponent(image, 4);
        this.filterComponent(image, 2);
        this.filterComponent(image, 1);
    }

    private void filterComponent(ComplexImage image, int component) {
        int width = image.getWidth();
        int height = image.getHeight();
        float brightness = (float)this.paramValue[0];
        float[] filtered = new float[width * height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                filtered[i + j * width] = image.getPixelComponent(i, j, component) * brightness;
            }
        }
        image.setComponentValues(component, filtered);
    }

    public TextureParameter[] getParameters() {
        return new TextureParameter[]{new TextureParameter(this, this.getName(), 0.0, Double.MAX_VALUE, 1.0)};
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.paramValue[0]);
    }

    public void initFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.paramValue[0] = in.readDouble();
    }
}

