/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.IOException;

public class TIFFEncoder {
    static final int IMAGE_START = 768;
    static final int HDR_SIZE = 8;
    static final int MAP_SIZE = 768;
    static final int SCALE_DATA_SIZE = 16;
    public static final int NEW_SUBFILE_TYPE = 254;
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_LENGTH = 257;
    public static final int BITS_PER_SAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTO_INTERP = 262;
    public static final int IMAGE_DESCRIPTION = 270;
    public static final int STRIP_OFFSETS = 273;
    public static final int SAMPLES_PER_PIXEL = 277;
    public static final int ROWS_PER_STRIP = 278;
    public static final int STRIP_BYTE_COUNT = 279;
    public static final int X_RESOLUTION = 282;
    public static final int Y_RESOLUTION = 283;
    public static final int PLANAR_CONFIGURATION = 284;
    public static final int RESOLUTION_UNIT = 296;
    public static final int SOFTWARE = 305;
    public static final int DATE_TIME = 306;
    public static final int COLOR_MAP = 320;
    public static final int EXTRA_SAMPLES = 338;
    public static final int SAMPLE_FORMAT = 339;
    static final int UNSIGNED = 1;
    static final int SIGNED = 2;
    static final int FLOATING_POINT = 3;
    static final int BYTE = 1;
    static final int ASCII = 2;
    static final int SHORT = 3;
    static final int LONG = 4;
    private Image im;
    int width;
    int height;
    private int bitsPerSample;
    private int photoInterp;
    private int samplesPerPixel;
    private int nEntries;
    private int ifdSize;
    private int imageOffset = 768;
    private int imageSize;
    private byte[] description;
    private int[] data;
    private boolean transparent;

    public TIFFEncoder(Image im) throws InterruptedException {
        this.im = im;
        this.recordData();
        this.width = im.getWidth(null);
        this.height = im.getHeight(null);
        this.bitsPerSample = 8;
        this.samplesPerPixel = this.transparent ? 4 : 3;
        this.nEntries = 10;
        if (this.transparent) {
            ++this.nEntries;
        }
        int bytesPerPixel = this.transparent ? 4 : 3;
        this.photoInterp = 2;
        this.makeDescriptionString();
        this.ifdSize = 2 + this.nEntries * 12 + 4;
        this.imageSize = this.width * this.height * bytesPerPixel;
    }

    public void writeImage(DataOutputStream out) throws IOException {
        this.writeHeader(out);
        int nextIFD = 0;
        this.writeIFD(out, this.imageOffset, nextIFD);
        int scaleSize = 0;
        int bpsSize = this.writeBitsPerPixel(out);
        int descriptionSize = this.writeDescription(out);
        byte[] filler = new byte[768 - (8 + this.ifdSize + bpsSize + descriptionSize + scaleSize)];
        out.write(filler);
        this.writeImageData(out);
    }

    private void recordData() throws InterruptedException {
        PixelGrabber pg = new PixelGrabber(this.im, 0, 0, -1, -1, true);
        pg.grabPixels();
        this.data = (int[])pg.getPixels();
        for (int i = 0; i < this.data.length; ++i) {
            if ((this.data[i] & 0xFF000000) == -16777216) continue;
            this.transparent = true;
            return;
        }
    }

    private void writeHeader(DataOutputStream out) throws IOException {
        byte[] hdr = new byte[]{77, 77, 0, 42, 0, 0, 0, 8};
        out.write(hdr);
    }

    private void writeEntry(DataOutputStream out, int tag, int fieldType, int count, int value) throws IOException {
        out.writeShort(tag);
        out.writeShort(fieldType);
        out.writeInt(count);
        if (count == 1 && fieldType == 1) {
            value <<= 24;
        }
        if (count == 1 && fieldType == 3) {
            value <<= 16;
        }
        out.writeInt(value);
    }

    private void writeIFD(DataOutputStream out, int imageOffset, int nextIFD) throws IOException {
        int tagDataOffset = 8 + this.ifdSize;
        out.writeShort(this.nEntries);
        this.writeEntry(out, 254, 4, 1, 0);
        this.writeEntry(out, 256, 3, 1, this.width);
        this.writeEntry(out, 257, 3, 1, this.height);
        this.writeEntry(out, 258, 3, this.transparent ? 4 : 3, tagDataOffset);
        tagDataOffset += this.transparent ? 8 : 6;
        this.writeEntry(out, 262, 3, 1, this.photoInterp);
        this.writeEntry(out, 273, 4, 1, imageOffset);
        this.writeEntry(out, 277, 3, 1, this.samplesPerPixel);
        this.writeEntry(out, 278, 3, 1, this.height);
        this.writeEntry(out, 279, 4, 1, this.imageSize);
        this.writeEntry(out, 305, 2, this.description.length, tagDataOffset);
        tagDataOffset += this.description.length;
        if (this.transparent) {
            this.writeEntry(out, 338, 3, 1, 1);
        }
        out.writeInt(nextIFD);
    }

    private int writeBitsPerPixel(DataOutputStream out) throws IOException {
        out.writeShort(8);
        out.writeShort(8);
        out.writeShort(8);
        if (this.transparent) {
            out.writeShort(8);
        }
        return this.transparent ? 8 : 6;
    }

    private int writeDescription(DataOutputStream out) throws IOException {
        out.write(this.description, 0, this.description.length);
        return this.description.length;
    }

    private void writeImageData(DataOutputStream out) throws IOException {
        for (int i = 0; i < this.data.length; ++i) {
            out.writeByte(this.data[i] >> 16 & 0xFF);
            out.writeByte(this.data[i] >> 8 & 0xFF);
            out.writeByte(this.data[i] & 0xFF);
            if (!this.transparent) continue;
            out.writeByte(this.data[i] >> 24 & 0xFF);
        }
    }

    private void makeDescriptionString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("Art of Illusion v2.5.1\n");
        sb.append("");
        this.description = new String(sb).getBytes();
        this.description[this.description.length - 1] = 0;
    }
}

