/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.ui.ImageFileChooser;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.MouseClickedEvent;
import buoy.event.RepaintEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.CustomWidget;
import buoy.widget.RowContainer;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.File;

public class ImagesDialog
extends BDialog {
    private Scene theScene;
    private BFrame parent;
    private int selection;
    private BScrollPane sp;
    private ImagesCanvas ic;
    private BButton[] b;
    static /* synthetic */ Class class$buoy$event$RepaintEvent;
    static /* synthetic */ Class class$buoy$event$MouseClickedEvent;

    public ImagesDialog(BFrame fr, Scene sc, ImageMap selected) {
        super(fr, "Images", true);
        BorderContainer content = new BorderContainer();
        this.setContent(content);
        this.parent = fr;
        this.theScene = sc;
        this.selection = 0;
        while (this.selection < sc.getNumImages() && sc.getImage(this.selection) != selected) {
            ++this.selection;
        }
        if (this.selection == sc.getNumImages()) {
            this.selection = -1;
        }
        this.sp = new BScrollPane(BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_ALWAYS);
        content.add(this.sp, BorderContainer.CENTER);
        this.ic = new ImagesCanvas(5);
        this.sp.setContent(this.ic);
        RowContainer buttons = new RowContainer();
        content.add(buttons, BorderContainer.SOUTH);
        this.b = new BButton[4];
        this.b[0] = Translate.button("load", "...", this, "doLoad");
        buttons.add(this.b[0]);
        this.b[1] = Translate.button("delete", "...", this, "doDelete");
        buttons.add(this.b[1]);
        this.b[2] = Translate.button("selectNone", this, "doSelectNone");
        buttons.add(this.b[2]);
        this.b[3] = Translate.button("ok", this, "dispose");
        buttons.add(this.b[3]);
        this.hilightButtons();
        this.sp.setPreferredViewSize(new Dimension(this.ic.getGridWidth() * 5 + 4, this.ic.getGridHeight() * 4 + 4));
        this.pack();
        this.setResizable(false);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "dispose");
        this.ic.imagesChanged();
        this.ic.scrollToSelection();
        UIUtilities.centerWindow(this);
        this.setVisible(true);
    }

    public ImageMap getSelection() {
        if (this.selection < 0) {
            return null;
        }
        return this.theScene.getImage(this.selection);
    }

    private void hilightButtons() {
        this.b[1].setEnabled(this.selection >= 0);
        this.b[2].setEnabled(this.selection >= 0);
    }

    private void doLoad() {
        ImageFileChooser fc = new ImageFileChooser(Translate.text("selectImagesToLoad"));
        fc.setMultipleSelectionEnabled(true);
        if (!fc.showDialog(this)) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        this.setCursor(Cursor.getPredefinedCursor(3));
        for (int i = 0; i < files.length; ++i) {
            try {
                this.theScene.addImage(ImageMap.loadImage(files[i]));
                continue;
            }
            catch (Exception ex) {
                new BStandardDialog("", Translate.text("errorLoadingImage", files[i].getName()), BStandardDialog.ERROR).showMessageDialog(this);
                ex.printStackTrace();
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.selection = this.theScene.getNumImages() - 1;
        this.ic.imagesChanged();
        this.ic.scrollToSelection();
        this.hilightButtons();
    }

    private void doDelete() {
        String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
        BStandardDialog dlg = new BStandardDialog(null, Translate.text("deleteSelectedImage"), BStandardDialog.QUESTION);
        if (dlg.showOptionDialog(this, options, options[1]) == 1) {
            return;
        }
        boolean success = this.theScene.removeImage(this.selection);
        if (!success) {
            new BStandardDialog(null, UIUtilities.breakString(Translate.text("imageInUse")), BStandardDialog.ERROR).showMessageDialog(this);
            return;
        }
        this.selection = -1;
        this.ic.imagesChanged();
        this.hilightButtons();
    }

    private void doSelectNone() {
        this.selection = -1;
        this.ic.imagesChanged();
        this.hilightButtons();
    }

    private class ImagesCanvas
    extends CustomWidget {
        private int w;
        private int h;
        private int gridw;
        private int gridh;

        public ImagesCanvas(int width) {
            this.w = width;
            this.gridw = 60;
            this.gridh = 60;
            ImagesDialog.this.sp.getVerticalScrollBar().setUnitIncrement(this.gridh);
            this.addEventLink(class$buoy$event$RepaintEvent == null ? (class$buoy$event$RepaintEvent = ImagesDialog.class$("buoy.event.RepaintEvent")) : class$buoy$event$RepaintEvent, (Object)this, "paint");
            this.addEventLink(class$buoy$event$MouseClickedEvent == null ? (class$buoy$event$MouseClickedEvent = ImagesDialog.class$("buoy.event.MouseClickedEvent")) : class$buoy$event$MouseClickedEvent, (Object)this, "mouseClicked");
        }

        public void imagesChanged() {
            this.h = (ImagesDialog.this.theScene.getNumImages() - 1) / this.w + 1;
            this.setPreferredSize(new Dimension(this.w * this.gridw, this.h * this.gridh));
            ImagesDialog.this.sp.layoutChildren();
            this.repaint();
        }

        public int getGridWidth() {
            return this.gridw;
        }

        public int getGridHeight() {
            return this.gridh;
        }

        public void scrollToSelection() {
            if (ImagesDialog.this.selection < 0) {
                return;
            }
            ImagesDialog.this.sp.getVerticalScrollBar().setValue(ImagesDialog.this.selection / this.w * this.gridh);
        }

        private void paint(RepaintEvent ev) {
            Graphics2D g = ev.getGraphics();
            for (int i = 0; i < ImagesDialog.this.theScene.getNumImages(); ++i) {
                g.drawImage(ImagesDialog.this.theScene.getImage(i).getPreview(), i % this.w * this.gridw + 5, i / this.w * this.gridh + 5, this.getComponent());
            }
            if (ImagesDialog.this.selection >= 0) {
                int x = ImagesDialog.this.selection % this.w * this.gridw;
                int y = ImagesDialog.this.selection / this.w * this.gridh;
                g.drawRect(x + 1, y + 1, this.gridw - 2, this.gridh - 2);
                g.drawRect(x + 2, y + 2, this.gridw - 4, this.gridh - 4);
            }
        }

        private void mouseClicked(MouseClickedEvent ev) {
            Point p = ev.getPoint();
            int i = p.x / this.gridw;
            int j = p.y / this.gridh;
            if (i < 5 && i + j * this.w < ImagesDialog.this.theScene.getNumImages()) {
                ImagesDialog.this.selection = i + j * this.w;
            } else {
                ImagesDialog.this.selection = -1;
            }
            this.repaint();
            ImagesDialog.this.hilightButtons();
        }
    }
}

