/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.animation.ArrayKeyframe;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.animation.distortion.CustomDistortion;
import artofillusion.object.ObjectInfo;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class CustomDistortionTrack
extends Track
implements ProcedureOwner {
    ObjectInfo info;
    Procedure proc;
    Timecourse tc;
    TextureParameter[] parameter;
    int smoothingMethod;
    int procVersion;
    WeightTrack theWeight;
    boolean worldCoords;

    public CustomDistortionTrack(ObjectInfo info) {
        super("Deform");
        this.info = info;
        this.proc = new Procedure(new OutputModule[]{new OutputModule("X", "X", 0.0, null, 0), new OutputModule("Y", "Y", 0.0, null, 0), new OutputModule("Z", "Z", 0.0, null, 0)});
        this.parameter = new TextureParameter[0];
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.worldCoords = false;
        this.theWeight = new WeightTrack(this);
    }

    public void apply(double time) {
        PointInfo point = new PointInfo();
        OutputModule[] output = this.proc.getOutputModules();
        ArrayKeyframe params = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        point.t = time;
        if (params != null) {
            point.param = params.val;
        }
        double weight = this.theWeight.getWeight(time);
        if (this.worldCoords) {
            this.info.addDistortion(new CustomDistortion(this.proc, this.procVersion, point, weight, this.info.coords.fromLocal(), this.info.coords.toLocal()));
        } else {
            this.info.addDistortion(new CustomDistortion(this.proc, this.procVersion, point, weight, null, null));
        }
    }

    public Track duplicate(Object obj) {
        CustomDistortionTrack t = new CustomDistortionTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.proc.copy(this.proc);
        t.worldCoords = this.worldCoords;
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        return t;
    }

    public void copy(Track tr) {
        CustomDistortionTrack t = (CustomDistortionTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.proc.copy(t.proc);
        this.worldCoords = t.worldCoords;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.info);
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        double[] p;
        if (this.parameter.length == 0) {
            return null;
        }
        ArrayKeyframe params = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (params == null) {
            p = this.getDefaultGraphValues();
        } else {
            p = new double[params.val.length];
            System.arraycopy(params.val, 0, p, 0, p.length);
        }
        ArrayKeyframe k = new ArrayKeyframe(p);
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return false;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public String[] getValueNames() {
        String[] names = new String[this.parameter.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.parameter[i].name;
        }
        return names;
    }

    public double[] getDefaultGraphValues() {
        double[] val = new double[this.parameter.length];
        for (int i = 0; i < val.length; ++i) {
            val[i] = this.parameter[i].defaultVal;
        }
        return val;
    }

    public double[][] getValueRange() {
        double[][] range = new double[this.parameter.length][2];
        for (int i = 0; i < range.length; ++i) {
            range[i][0] = this.parameter[i].minVal;
            range[i][1] = this.parameter[i].maxVal;
        }
        return range;
    }

    public ObjectInfo[] getDependencies() {
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
    }

    private TextureParameter[] findParameters() {
        Module[] module = this.proc.getModules();
        int count = 0;
        for (int i = 0; i < module.length; ++i) {
            if (!(module[i] instanceof ParameterModule)) continue;
            ++count;
        }
        TextureParameter[] params = new TextureParameter[count];
        count = 0;
        for (int i = 0; i < module.length; ++i) {
            if (!(module[i] instanceof ParameterModule)) continue;
            params[count] = ((ParameterModule)module[i]).getParameter(this);
            ((ParameterModule)module[i]).setIndex(count++);
        }
        return params;
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        this.proc.writeToStream(out, scene);
        out.writeInt(this.smoothingMethod);
        out.writeBoolean(this.worldCoords);
        out.writeInt(t.length);
        for (int i = 0; i < t.length; ++i) {
            out.writeDouble(t[i]);
            ((ArrayKeyframe)v[i]).writeToStream(out);
            s[i].writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.proc.readFromStream(in, scene);
        this.smoothingMethod = in.readInt();
        this.worldCoords = in.readBoolean();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        for (int i = 0; i < keys; ++i) {
            t[i] = in.readDouble();
            v[i] = new ArrayKeyframe(in, this);
            s[i] = new Smoothness(in);
        }
        this.tc = new Timecourse(v, t, s);
        this.theWeight.initFromStream(in, scene);
        this.parameter = this.findParameters();
    }

    public void editKeyframe(LayoutWindow win, int which) {
        ArrayKeyframe key = (ArrayKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !s.isForceSame());
        Widget[] widget = new Widget[this.parameter.length + 5];
        String[] label = new String[this.parameter.length + 5];
        for (int i = 0; i < this.parameter.length; ++i) {
            widget[i] = this.parameter[i].getEditingWidget(key.val[i]);
            label[i] = this.parameter[i].name;
        }
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        int n = this.parameter.length;
        widget[n] = timeField;
        widget[n + 1] = sameBox;
        widget[n + 2] = new BLabel(Translate.text("Smoothness") + ':');
        widget[n + 3] = s1Slider;
        widget[n + 4] = s2Slider;
        label[n] = Translate.text("Time");
        label[n + 3] = "(" + Translate.text("left") + ")";
        label[n + 4] = "(" + Translate.text("right") + ")";
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("editKeyframe"), widget, label);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        for (int i = 0; i < this.parameter.length; ++i) {
            key.val[i] = widget[i] instanceof ValueField ? ((ValueField)widget[i]).getValue() : ((ValueSlider)widget[i]).getValue();
        }
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        ProcedureEditor editor = new ProcedureEditor(this.proc, this, win.getScene());
        editor.setEditingWindow(win);
    }

    public String getWindowTitle() {
        return "Custom Deformation Track";
    }

    public Object getPreview(ProcedureEditor editor) {
        return null;
    }

    public void updatePreview(Object preview) {
    }

    public void disposePreview(Object preview) {
    }

    public boolean allowParameters() {
        return true;
    }

    public boolean allowViewAngle() {
        return true;
    }

    public boolean canEditName() {
        return true;
    }

    public void acceptEdits(ProcedureEditor editor) {
        EditingWindow win = editor.getEditingWindow();
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        TextureParameter[] newparams = this.findParameters();
        int[] index = new int[newparams.length];
        for (int i = 0; i < newparams.length; ++i) {
            index[i] = -1;
            for (int j = 0; j < this.parameter.length; ++j) {
                if (!this.parameter[j].equals(newparams[i])) continue;
                index[i] = j;
            }
        }
        this.parameter = newparams;
        Keyframe[] key = this.tc.getValues();
        for (int i = 0; i < key.length; ++i) {
            double[] newval = new double[this.parameter.length];
            for (int j = 0; j < newval.length; ++j) {
                newval[j] = index[j] > -1 ? ((ArrayKeyframe)key[i]).val[index[j]] : this.parameter[j].defaultVal;
            }
            ((ArrayKeyframe)key[i]).val = newval;
        }
        ++this.procVersion;
        ((LayoutWindow)win).getScore().finishEditingTrack(this);
    }

    public void editProperties(ProcedureEditor editor) {
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        BComboBox coordsChoice = new BComboBox(new String[]{Translate.text("Local"), Translate.text("World")});
        coordsChoice.setSelectedIndex(this.worldCoords ? 1 : 0);
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), Translate.text("deformTrackTitle"), new Widget[]{smoothChoice, coordsChoice}, new String[]{Translate.text("SmoothingMethod"), Translate.text("CoordinateSystem")});
        if (!dlg.clickedOk()) {
            return;
        }
        editor.saveState(false);
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.worldCoords = coordsChoice.getSelectedIndex() == 1;
    }
}

