/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.UndoRecord;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Marker;
import artofillusion.animation.Score;
import artofillusion.animation.SelectionInfo;
import artofillusion.animation.Track;
import artofillusion.animation.TrackDisplay;
import artofillusion.ui.TreeList;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.widget.CustomWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

public class TracksPanel
extends CustomWidget
implements TrackDisplay {
    LayoutWindow window;
    TreeList theList;
    Score theScore;
    double start;
    double scale;
    double[] dragKeyTime;
    int subdivisions;
    int mode;
    int effectiveMode;
    Point lastPos;
    Point dragPos;
    boolean draggingBox;
    int yoffset;
    Vector markers;
    UndoRecord undo;
    private static final Polygon handle = new Polygon(new int[]{-3, 0, 3, 0}, new int[]{0, 3, 0, -3, 0}, 4);
    private static final int HANDLE_SIZE = 7;

    public TracksPanel(LayoutWindow win, TreeList list, Score sc, int subdivisions, double scale) {
        this.window = win;
        this.theList = list;
        this.theScore = sc;
        this.subdivisions = subdivisions;
        this.scale = scale;
        this.markers = new Vector();
        this.setPreferredSize(new Dimension(200, 100));
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
    }

    public void setStartTime(double time) {
        this.start = time;
    }

    public void setScale(double s) {
        this.scale = s;
    }

    public void setSubdivisions(int s) {
        this.subdivisions = s;
    }

    public void setYOffset(int offset) {
        this.yoffset = offset;
    }

    public void addMarker(Marker m) {
        this.markers.addElement(m);
    }

    public void setMode(int m) {
        this.mode = m;
    }

    private void paint(RepaintEvent ev) {
        int x;
        int i;
        Graphics2D g = ev.getGraphics();
        Object[] obj = this.theList.getVisibleObjects();
        SelectionInfo[] selection = this.theScore.getSelectedKeyframes();
        Rectangle dim = this.getBounds();
        int rowHeight = this.theList.getRowHeight();
        for (i = 0; i < obj.length; ++i) {
            Track tr;
            if (obj[i] instanceof Track) {
                g.setColor(Color.lightGray);
            } else {
                g.setColor(Color.darkGray);
            }
            int y = this.yoffset + i * rowHeight;
            g.fillRect(0, y, dim.width, rowHeight - 2);
            if (!(obj[i] instanceof Track) || (tr = (Track)obj[i]).getTimecourse() == null) continue;
            double[] t = tr.getKeyTimes();
            Keyframe[] key = tr.getTimecourse().getValues();
            g.setColor(Color.black);
            for (int j = 0; j < t.length; ++j) {
                int k;
                for (k = 0; k < selection.length && selection[k].key != key[j]; ++k) {
                }
                if (k < selection.length) {
                    g.setColor(Color.red);
                }
                x = (int)Math.round(this.scale * (t[j] - this.start));
                handle.translate(x, y + rowHeight / 2);
                g.drawPolygon(handle);
                handle.translate(-x, -y - rowHeight / 2);
                if (k >= selection.length) continue;
                g.setColor(Color.black);
            }
        }
        for (i = 0; i < this.markers.size(); ++i) {
            Marker m = (Marker)this.markers.elementAt(i);
            g.setColor(m.color);
            x = (int)Math.round(this.scale * (m.position - this.start));
            g.drawLine(x, 0, x, dim.height);
        }
    }

    private void findInitialKeyTimes() {
        SelectionInfo[] sel = this.theScore.getSelectedKeyframes();
        this.dragKeyTime = new double[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            double[] t = sel[i].track.getKeyTimes();
            this.dragKeyTime[i] = t[sel[i].keyIndex];
        }
    }

    private void mousePressed(MousePressedEvent ev) {
        this.lastPos = ev.getPoint();
        int rowHeight = this.theList.getRowHeight();
        int y = this.lastPos.y - this.yoffset;
        int row = y / rowHeight;
        Object[] obj = this.theList.getVisibleObjects();
        this.undo = null;
        this.dragPos = null;
        this.draggingBox = false;
        int n = this.effectiveMode = ev.isMetaDown() ? 1 : this.mode;
        if (this.effectiveMode != 0) {
            return;
        }
        if (row < 0 || row >= obj.length || !(obj[row] instanceof Track)) {
            if (!ev.isShiftDown()) {
                this.theScore.setSelectedKeyframes(new SelectionInfo[0]);
            }
            this.findInitialKeyTimes();
            this.draggingBox = true;
            this.theScore.repaintGraphs();
            return;
        }
        double[] t = ((Track)obj[row]).getKeyTimes();
        for (int i = 0; i < t.length; ++i) {
            int x = (int)Math.round(this.scale * (t[i] - this.start));
            if (x < this.lastPos.x - 3 || x > this.lastPos.x + 3) continue;
            Track tr = (Track)obj[row];
            Keyframe key = tr.getTimecourse().getValues()[i];
            if (ev.isShiftDown()) {
                if (this.theScore.isKeyframeSelected(key)) {
                    this.theScore.removeSelectedKeyframe(key);
                } else {
                    this.theScore.addSelectedKeyframes(new SelectionInfo[]{new SelectionInfo(tr, key)});
                }
            } else if (!this.theScore.isKeyframeSelected(key)) {
                this.theScore.setSelectedKeyframes(new SelectionInfo[]{new SelectionInfo(tr, key)});
            }
            this.findInitialKeyTimes();
            this.theScore.repaintGraphs();
            return;
        }
        if (!ev.isShiftDown()) {
            this.theScore.setSelectedKeyframes(new SelectionInfo[0]);
        }
        this.draggingBox = true;
        this.theScore.repaintAll();
    }

    private void mouseDragged(MouseDraggedEvent ev) {
        Point pos = ev.getPoint();
        if (this.effectiveMode == 0) {
            int j;
            int i;
            if (this.draggingBox) {
                Graphics g = this.getComponent().getGraphics();
                g.setXORMode(Color.white);
                g.setColor(Color.black);
                if (this.dragPos != null) {
                    g.drawRect(Math.min(this.lastPos.x, this.dragPos.x), Math.min(this.lastPos.y, this.dragPos.y), Math.abs(this.dragPos.x - this.lastPos.x), Math.abs(this.dragPos.y - this.lastPos.y));
                }
                this.dragPos = pos;
                g.drawRect(Math.min(this.lastPos.x, this.dragPos.x), Math.min(this.lastPos.y, this.dragPos.y), Math.abs(this.dragPos.x - this.lastPos.x), Math.abs(this.dragPos.y - this.lastPos.y));
                g.dispose();
                return;
            }
            SelectionInfo[] sel = this.theScore.getSelectedKeyframes();
            if (this.undo == null) {
                this.undo = new UndoRecord(this.window, false);
                for (i = 0; i < sel.length; ++i) {
                    Track tr = sel[i].track;
                    for (j = 0; j < i && tr != sel[j].track; ++j) {
                    }
                    if (j != i) continue;
                    this.undo.addCommand(12, new Object[]{tr, tr.duplicate(tr.getParent())});
                }
                this.window.setUndoRecord(this.undo);
            }
            double dt = (double)(pos.x - this.lastPos.x) / this.scale;
            for (i = 0; i < sel.length; ++i) {
                int newindex;
                int oldindex = sel[i].keyIndex;
                double t = this.dragKeyTime[i] + dt;
                if (sel[i].track.isQuantized()) {
                    t = (double)Math.round(t * (double)this.subdivisions) / (double)this.subdivisions;
                }
                if (oldindex == (newindex = sel[i].track.moveKeyframe(oldindex, t))) continue;
                for (j = 0; j < sel.length; ++j) {
                    if (sel[j].keyIndex < oldindex && sel[j].keyIndex > newindex) {
                        ++sel[j].keyIndex;
                        continue;
                    }
                    if (sel[j].keyIndex <= oldindex || sel[j].keyIndex >= newindex) continue;
                    --sel[j].keyIndex;
                }
                sel[i].keyIndex = newindex;
            }
            this.repaint();
            return;
        }
        if (this.effectiveMode != 1) {
            return;
        }
        if (ev.isShiftDown()) {
            if (pos.x > this.lastPos.x) {
                this.window.getScore().setScale(this.scale * Math.pow(1.01, pos.x - this.lastPos.x));
            } else {
                this.window.getScore().setScale(this.scale / Math.pow(1.01, this.lastPos.x - pos.x));
            }
            this.lastPos = pos;
            return;
        }
        double dt = (double)(pos.x - this.lastPos.x) / this.scale;
        if (this.lastPos.y != pos.y) {
            this.window.getScore().setScrollPosition(this.lastPos.y - pos.y - this.yoffset);
        }
        if (this.lastPos.x != pos.x) {
            this.window.getScore().setStartTime(this.start - dt);
        }
        this.lastPos = pos;
    }

    private void mouseReleased(MouseReleasedEvent ev) {
        if (this.dragPos != null) {
            int row2;
            int row1;
            float rowHeight = this.theList.getRowHeight();
            int y1 = this.lastPos.y - this.yoffset;
            int y2 = this.dragPos.y - this.yoffset;
            int x1 = Math.min(this.lastPos.x, this.dragPos.x);
            int x2 = Math.max(this.lastPos.x, this.dragPos.x);
            if (y1 < y2) {
                row1 = Math.round((float)y1 / rowHeight);
                row2 = Math.round((float)y2 / rowHeight);
            } else {
                row1 = Math.round((float)y2 / rowHeight);
                row2 = Math.round((float)y1 / rowHeight);
            }
            Object[] obj = this.theList.getVisibleObjects();
            if (row1 < 0) {
                row1 = 0;
            }
            if (row2 > obj.length) {
                row2 = obj.length;
            }
            Vector<SelectionInfo> v = new Vector<SelectionInfo>();
            for (int row = row1; row < row2; ++row) {
                if (!(obj[row] instanceof Track)) continue;
                Track tr = (Track)obj[row];
                double[] t = tr.getKeyTimes();
                for (int i = 0; i < t.length; ++i) {
                    int x = (int)Math.round(this.scale * (t[i] - this.start));
                    if (x < x1 || x > x2) continue;
                    Keyframe key = tr.getTimecourse().getValues()[i];
                    v.addElement(new SelectionInfo(tr, key));
                }
            }
            SelectionInfo[] sel = new SelectionInfo[v.size()];
            for (int i = 0; i < sel.length; ++i) {
                sel[i] = (SelectionInfo)v.elementAt(i);
            }
            this.theScore.addSelectedKeyframes(sel);
            this.theScore.repaintGraphs();
        }
    }

    private void mouseClicked(MouseClickedEvent ev) {
        if (ev.getClickCount() == 2 && this.effectiveMode == 0) {
            this.theScore.editSelectedKeyframe();
        }
    }
}

