/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Actor;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.animation.distortion.PoseDistortion;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import buoy.widget.BComboBox;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;

public class PoseTrack
extends Track {
    private ObjectInfo info;
    private Timecourse tc;
    private int smoothingMethod;
    private boolean relative;
    private Track[] subtracks;
    private WeightTrack theWeight;
    private String[] valueName;
    private double[] defaultValue;
    private double[][] valueRange;

    public PoseTrack(ObjectInfo info) {
        super("Pose");
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.theWeight = new WeightTrack(this);
        this.subtracks = new Track[]{this.theWeight};
        info.object.configurePoseTrack(this);
    }

    public void apply(double time) {
        Keyframe pose = this.tc.evaluate(time, this.smoothingMethod);
        if (pose != null) {
            if (this.info.isDistorted()) {
                Actor actor = Actor.getActor(this.info.object);
                this.info.addDistortion(new PoseDistortion(this.theWeight.getWeight(time), pose, actor, this.relative));
            } else if (this.info.pose == null) {
                this.info.pose = pose;
            } else {
                double weight = this.theWeight.getWeight(time);
                this.info.pose = this.relative ? this.info.pose.blend(pose, 1.0, weight) : this.info.pose.blend(pose, 1.0 - weight, weight);
            }
        }
        for (int i = 0; i < this.subtracks.length; ++i) {
            this.subtracks[i].apply(time);
        }
    }

    public Track duplicate(Object obj) {
        PoseTrack t = new PoseTrack((ObjectInfo)obj);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.relative = this.relative;
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        t.subtracks = new Track[]{this.theWeight};
        return t;
    }

    public void copy(Track tr) {
        PoseTrack t = (PoseTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.info);
        this.relative = t.relative;
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
        this.subtracks = new Track[]{this.theWeight};
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        Keyframe pose = this.info.object.getPoseKeyframe();
        this.tc.addTimepoint(pose, time, new Smoothness());
        return pose;
    }

    public Keyframe setKeyframeIfModified(double time, Scene sc) {
        Keyframe pose2;
        for (int i = 0; i < this.subtracks.length; ++i) {
            this.subtracks[i].setKeyframeIfModified(time, sc);
        }
        if (this.tc.getTimes().length == 0) {
            return this.setKeyframe(time, sc);
        }
        Keyframe pose1 = this.tc.evaluate(time, this.smoothingMethod);
        Keyframe keyframe = pose2 = this.info.pose == null ? this.info.object.getPoseKeyframe() : this.info.pose;
        if (!pose1.equals(pose2)) {
            return this.setKeyframe(time, sc);
        }
        return null;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public Track[] getSubtracks() {
        return this.subtracks;
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo && ((ObjectInfo)obj).object == this.info.object;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public void setRelative(boolean rel) {
        this.relative = rel;
    }

    public String[] getValueNames() {
        return this.valueName;
    }

    public double[] getDefaultGraphValues() {
        return this.defaultValue;
    }

    public double[][] getValueRange() {
        return this.valueRange;
    }

    public void setGraphableValues(String[] names, double[] defaults, double[][] ranges) {
        this.valueName = names;
        this.defaultValue = defaults;
        this.valueRange = ranges;
    }

    public void setSubtracks(Track[] extraSubtracks) {
        this.subtracks = new Track[extraSubtracks.length + 1];
        this.subtracks[0] = this.theWeight;
        System.arraycopy(extraSubtracks, 0, this.subtracks, 1, extraSubtracks.length);
    }

    public void writeToStream(DataOutputStream out, Scene sc) throws IOException {
        int i;
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(2);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeBoolean(this.relative);
        out.writeInt(t.length);
        if (t.length > 0) {
            out.writeUTF(v[0].getClass().getName());
        }
        for (i = 0; i < t.length; ++i) {
            out.writeDouble(t[i]);
            v[i].writeToStream(out);
            s[i].writeToStream(out);
        }
        for (i = 0; i < this.subtracks.length; ++i) {
            this.subtracks[i].writeToStream(out, sc);
        }
    }

    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 2) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.relative = version > 0 ? in.readBoolean() : false;
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        if (keys > 0) {
            try {
                Class cl = ModellingApp.getClass(in.readUTF());
                Constructor con = cl.getConstructor(DataInputStream.class, Object.class);
                for (int i = 0; i < keys; ++i) {
                    t[i] = in.readDouble();
                    v[i] = (Keyframe)con.newInstance(in, this.info);
                    s[i] = new Smoothness(in);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new InvalidObjectException("");
            }
        }
        this.tc = new Timecourse(v, t, s);
        this.info.object.configurePoseTrack(this);
        if (version == 0) {
            this.theWeight.initFromStream(in, scene);
        } else {
            for (int i = 0; i < this.subtracks.length; ++i) {
                this.subtracks[i].initFromStream(in, scene);
            }
        }
    }

    public void editKeyframe(LayoutWindow win, int which) {
        this.info.object.editKeyframe(win, this.tc.getValues()[which], this.info);
    }

    public void edit(LayoutWindow win) {
        BTextField nameField = new BTextField(this.getName());
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        BComboBox modeChoice = new BComboBox(new String[]{Translate.text("Absolute"), Translate.text("Relative")});
        modeChoice.setSelectedIndex(this.relative ? 1 : 0);
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("poseTrackTitle"), new Widget[]{nameField, smoothChoice, modeChoice}, new String[]{Translate.text("trackName"), Translate.text("SmoothingMethod"), Translate.text("trackMode")});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.relative = modeChoice.getSelectedIndex() == 1;
    }
}

