/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.animation.ArrayKeyframe;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.image.filter.ImageFilter;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class FilterParameterTrack
extends Track {
    private Object parent;
    private ImageFilter filter;
    private Timecourse tc;
    private int smoothingMethod;

    public FilterParameterTrack(Object parent, ImageFilter filter) {
        super(filter.getName());
        this.parent = parent;
        this.filter = filter;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
    }

    public ImageFilter getFilter() {
        return this.filter;
    }

    public void apply(double time) {
        ArrayKeyframe k = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (k == null) {
            return;
        }
        for (int i = 0; i < k.val.length; ++i) {
            this.filter.setParameterValue(i, k.val[i]);
        }
    }

    public Track duplicate(Object obj) {
        FilterParameterTrack t = new FilterParameterTrack(obj, this.filter);
        t.name = this.name;
        t.enabled = this.enabled;
        t.quantized = this.quantized;
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate(this.filter);
        return t;
    }

    public void copy(Track tr) {
        FilterParameterTrack t = (FilterParameterTrack)tr;
        this.name = t.name;
        this.enabled = t.enabled;
        this.quantized = t.quantized;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.filter);
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        double[] val = this.filter.getParameterValues();
        double[] key = new double[val.length];
        for (int i = 0; i < val.length; ++i) {
            key[i] = val[i];
        }
        ArrayKeyframe k = new ArrayKeyframe(key);
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public Keyframe setKeyframeIfModified(double time, Scene sc) {
        if (this.tc.getTimes().length == 0) {
            return this.setKeyframe(time, sc);
        }
        double[] val1 = ((ArrayKeyframe)this.tc.evaluate((double)time, (int)this.smoothingMethod)).val;
        double[] val2 = this.filter.getParameterValues();
        for (int i = 0; i < val1.length; ++i) {
            if (val1[i] == val2[i]) continue;
            return this.setKeyframe(time, sc);
        }
        return null;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public Track[] getSubtracks() {
        return new Track[0];
    }

    public boolean canAcceptAsParent(Object obj) {
        return false;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object obj) {
        this.parent = obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public String[] getValueNames() {
        TextureParameter[] param = this.filter.getParameters();
        String[] name = new String[param.length];
        for (int i = 0; i < param.length; ++i) {
            name[i] = param[i].name;
        }
        return name;
    }

    public double[] getDefaultGraphValues() {
        return this.filter.getParameterValues();
    }

    public double[][] getValueRange() {
        TextureParameter[] param = this.filter.getParameters();
        double[][] range = new double[param.length][];
        for (int i = 0; i < param.length; ++i) {
            range[i] = new double[]{param[i].minVal, param[i].maxVal};
        }
        return range;
    }

    public void writeToStream(DataOutputStream out, Scene sc) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeInt(t.length);
        for (int i = 0; i < t.length; ++i) {
            out.writeDouble(t[i]);
            v[i].writeToStream(out);
            s[i].writeToStream(out);
        }
    }

    public void initFromStream(DataInputStream in, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        for (int i = 0; i < keys; ++i) {
            t[i] = in.readDouble();
            v[i] = new ArrayKeyframe(in, this.filter);
            s[i] = new Smoothness(in);
        }
        this.tc = new Timecourse(v, t, s);
    }

    public void editKeyframe(LayoutWindow win, int which) {
        ArrayKeyframe key = (ArrayKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !s.isForceSame());
        TextureParameter[] parameter = this.filter.getParameters();
        Widget[] widget = new Widget[parameter.length + 5];
        String[] label = new String[parameter.length + 5];
        for (int i = 0; i < parameter.length; ++i) {
            widget[i] = parameter[i].getEditingWidget(key.val[i]);
            label[i] = parameter[i].name;
        }
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        int n = parameter.length;
        widget[n] = timeField;
        widget[n + 1] = sameBox;
        widget[n + 2] = new BLabel(Translate.text("Smoothness") + ':');
        widget[n + 3] = s1Slider;
        widget[n + 4] = s2Slider;
        label[n] = Translate.text("Time");
        label[n + 3] = "(" + Translate.text("left") + ")";
        label[n + 4] = "(" + Translate.text("right") + ")";
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("editKeyframe"), widget, label);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.filter)}));
        for (int i = 0; i < parameter.length; ++i) {
            key.val[i] = widget[i] instanceof ValueSlider ? ((ValueSlider)widget[i]).getValue() : ((ValueField)widget[i]).getValue();
        }
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        BTextField nameField = new BTextField(this.getName());
        BComboBox smoothChoice = new BComboBox(new String[]{Translate.text("Discontinuous"), Translate.text("Linear"), Translate.text("Interpolating"), Translate.text("Approximating")});
        smoothChoice.setSelectedIndex(this.smoothingMethod);
        ComponentsDialog dlg = new ComponentsDialog(win, Translate.text("filterTrackTitle"), new Widget[]{nameField, smoothChoice}, new String[]{Translate.text("trackName"), Translate.text("SmoothingMethod")});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.filter)}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
    }
}

