/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.LayoutWindow;
import artofillusion.animation.Skeleton;
import artofillusion.animation.Track;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MeshEditController;
import java.util.Vector;

public class UndoRecord {
    Vector command;
    Vector data;
    boolean redo;
    EditingWindow theWindow;
    public static final int COPY_OBJECT = 0;
    public static final int COPY_COORDS = 1;
    public static final int COPY_OBJECT_INFO = 2;
    public static final int SET_OBJECT = 3;
    public static final int ADD_OBJECT = 4;
    public static final int DELETE_OBJECT = 5;
    public static final int RENAME_OBJECT = 6;
    public static final int ADD_TO_GROUP = 7;
    public static final int REMOVE_FROM_GROUP = 8;
    public static final int SET_GROUP_CONTENTS = 9;
    public static final int SET_TRACK = 10;
    public static final int SET_TRACK_LIST = 11;
    public static final int COPY_TRACK = 12;
    public static final int COPY_VERTEX_POSITIONS = 13;
    public static final int COPY_SKELETON = 14;
    public static final int SET_MESH_SELECTION = 15;
    public static final int SET_SCENE_SELECTION = 16;

    public UndoRecord(EditingWindow win, boolean isRedo) {
        this.theWindow = win;
        this.redo = isRedo;
        this.command = new Vector();
        this.data = new Vector();
    }

    public UndoRecord(EditingWindow win, boolean isRedo, int theCommand, Object[] commandData) {
        this(win, isRedo);
        this.addCommand(theCommand, commandData);
    }

    public boolean isRedo() {
        return this.redo;
    }

    public void addCommand(int theCommand, Object[] commandData) {
        this.command.addElement(new Integer(theCommand));
        this.data.addElement(commandData);
    }

    public void addCommandAtBeginning(int theCommand, Object[] commandData) {
        this.command.insertElementAt(new Integer(theCommand), 0);
        this.data.insertElementAt(commandData, 0);
    }

    public UndoRecord execute() {
        UndoRecord redoRecord = new UndoRecord(this.theWindow, !this.redo);
        int[] selection = this.theWindow.getScene().getSelection();
        boolean needRestoreSelection = false;
        block19: for (int i = 0; i < this.command.size(); ++i) {
            int c = (Integer)this.command.elementAt(i);
            Object[] d = (Object[])this.data.elementAt(i);
            switch (c) {
                case 0: {
                    Object3D obj1 = (Object3D)d[0];
                    Object3D obj2 = (Object3D)d[1];
                    redoRecord.addCommandAtBeginning(0, new Object[]{obj1, obj1.duplicate()});
                    obj1.copyObject(obj2);
                    if (this.theWindow.getScene() == null) continue block19;
                    this.theWindow.getScene().objectModified(obj1);
                    continue block19;
                }
                case 1: {
                    CoordinateSystem coords1 = (CoordinateSystem)d[0];
                    CoordinateSystem coords2 = (CoordinateSystem)d[1];
                    redoRecord.addCommandAtBeginning(1, new Object[]{coords1, coords1.duplicate()});
                    coords1.copyCoords(coords2);
                    continue block19;
                }
                case 2: {
                    ObjectInfo info1 = (ObjectInfo)d[0];
                    ObjectInfo info2 = (ObjectInfo)d[1];
                    redoRecord.addCommandAtBeginning(2, new Object[]{info1, info1.duplicate()});
                    info1.copyInfo(info2);
                    continue block19;
                }
                case 3: {
                    ObjectInfo info = (ObjectInfo)d[0];
                    Object3D obj = (Object3D)d[1];
                    redoRecord.addCommandAtBeginning(3, new Object[]{info, info.object});
                    info.object = obj;
                    continue block19;
                }
                case 4: {
                    ObjectInfo info = (ObjectInfo)d[0];
                    LayoutWindow win = (LayoutWindow)this.theWindow;
                    int index = (Integer)d[1];
                    win.addObject(info, index, redoRecord);
                    if (info.selected) {
                        win.getScene().addToSelection(index);
                    }
                    needRestoreSelection = true;
                    continue block19;
                }
                case 5: {
                    int which = (Integer)d[0];
                    LayoutWindow win = (LayoutWindow)this.theWindow;
                    win.removeObject(which, redoRecord);
                    needRestoreSelection = true;
                    continue block19;
                }
                case 6: {
                    LayoutWindow win = (LayoutWindow)this.theWindow;
                    int which = (Integer)d[0];
                    String oldName = win.getScene().getObject((int)which).name;
                    redoRecord.addCommandAtBeginning(6, new Object[]{d[0], oldName});
                    win.setObjectName(which, (String)d[1]);
                    continue block19;
                }
                case 7: {
                    int pos = (Integer)d[2];
                    ObjectInfo group = (ObjectInfo)d[0];
                    ObjectInfo child = (ObjectInfo)d[1];
                    redoRecord.addCommandAtBeginning(8, new Object[]{group, child});
                    group.addChild(child, pos);
                    continue block19;
                }
                case 8: {
                    int pos;
                    ObjectInfo group = (ObjectInfo)d[0];
                    ObjectInfo child = (ObjectInfo)d[1];
                    for (pos = 0; pos < group.children.length && group.children[pos] != child; ++pos) {
                    }
                    if (pos == group.children.length) continue block19;
                    redoRecord.addCommandAtBeginning(7, new Object[]{group, child, new Integer(pos)});
                    group.removeChild(child);
                    continue block19;
                }
                case 9: {
                    int j;
                    ObjectInfo group = (ObjectInfo)d[0];
                    ObjectInfo[] oldobj = group.children;
                    ObjectInfo[] newobj = (ObjectInfo[])d[1];
                    redoRecord.addCommandAtBeginning(9, new Object[]{group, oldobj});
                    for (j = 0; j < oldobj.length; ++j) {
                        oldobj[j].parent = null;
                    }
                    for (j = 0; j < newobj.length; ++j) {
                        newobj[j].parent = group;
                    }
                    group.children = newobj;
                    continue block19;
                }
                case 10: {
                    ObjectInfo info = (ObjectInfo)d[0];
                    int which = (Integer)d[1];
                    redoRecord.addCommandAtBeginning(10, new Object[]{info, d[1], info.tracks[which]});
                    info.tracks[which] = (Track)d[2];
                    continue block19;
                }
                case 11: {
                    ObjectInfo info = (ObjectInfo)d[0];
                    redoRecord.addCommandAtBeginning(11, new Object[]{info, info.tracks});
                    info.tracks = (Track[])d[1];
                    continue block19;
                }
                case 12: {
                    Track tr1 = (Track)d[0];
                    Track tr2 = (Track)d[1];
                    redoRecord.addCommandAtBeginning(12, new Object[]{tr1, tr1.duplicate(tr1.getParent())});
                    tr1.copy(tr2);
                    continue block19;
                }
                case 13: {
                    Mesh mesh = (Mesh)d[0];
                    Vec3[] pos = (Vec3[])d[1];
                    redoRecord.addCommandAtBeginning(13, new Object[]{mesh, mesh.getVertexPositions()});
                    mesh.setVertexPositions(pos);
                    if (this.theWindow.getScene() == null) continue block19;
                    this.theWindow.getScene().objectModified((Object3D)((Object)mesh));
                    continue block19;
                }
                case 14: {
                    Skeleton s1 = (Skeleton)d[0];
                    Skeleton s2 = (Skeleton)d[1];
                    redoRecord.addCommandAtBeginning(14, new Object[]{s1, s1.duplicate()});
                    s1.copy(s2);
                    continue block19;
                }
                case 15: {
                    MeshEditController controller = (MeshEditController)d[0];
                    int mode = (Integer)d[1];
                    boolean[] selected = (boolean[])d[2];
                    redoRecord.addCommandAtBeginning(15, new Object[]{controller, new Integer(controller.getSelectionMode()), controller.getSelection().clone()});
                    controller.setSelectionMode(mode);
                    controller.setSelection(selected);
                    continue block19;
                }
                case 16: {
                    int[] selected = (int[])d[0];
                    needRestoreSelection = true;
                    if (this.theWindow instanceof LayoutWindow) {
                        ((LayoutWindow)this.theWindow).setSelection(selected);
                        continue block19;
                    }
                    this.theWindow.getScene().setSelection(selected);
                    continue block19;
                }
            }
        }
        if (needRestoreSelection) {
            redoRecord.addCommand(16, new Object[]{selection});
        }
        this.theWindow.setModified();
        return redoRecord;
    }
}

