/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.RenderingMesh;
import artofillusion.math.RGBColor;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;

public abstract class RenderingTriangle {
    public int index;
    public int v1;
    public int v2;
    public int v3;
    public int n1;
    public int n2;
    public int n3;
    public RenderingMesh theMesh;
    private static double[] EMPTY_ARRAY = new double[0];
    protected static ThreadLocal tempParamValues = new ThreadLocal();

    public RenderingTriangle(int v1, int v2, int v3, int n1, int n2, int n3) {
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
        this.n1 = n1;
        this.n2 = n2;
        this.n3 = n3;
    }

    public TextureMapping getTextureMapping() {
        return this.theMesh.mapping;
    }

    public abstract void getTextureSpec(TextureSpec var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public abstract void getTransparency(RGBColor var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public abstract double getDisplacement(double var1, double var3, double var5, double var7, double var9);

    public void setMesh(RenderingMesh mesh, TextureMapping map, int index) {
        this.theMesh = mesh;
        this.index = index;
    }

    public double[] getParameters(double u, double v, double w) {
        ParameterValue[] param = this.theMesh.param;
        if (param.length == 0) {
            return EMPTY_ARRAY;
        }
        double[] value = (double[])tempParamValues.get();
        if (value != null) {
            return value;
        }
        value = new double[param.length];
        for (int i = value.length - 1; i >= 0; --i) {
            value[i] = param[i].getValue(this.index, this.v1, this.v2, this.v3, u, v, w);
        }
        return value;
    }
}

