/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.Renderer;
import artofillusion.RenderingDialog;
import artofillusion.Scene;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.MeshEditController;
import artofillusion.ui.UIUtilities;
import buoy.event.WidgetMouseEvent;
import buoy.widget.RowContainer;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.Vector;

public abstract class ObjectViewer
extends ViewerCanvas {
    protected MeshEditController controller;
    protected boolean showScene;
    protected boolean useWorldCoords;
    protected boolean freehandSelection;
    protected boolean draggingBox;
    protected boolean squareBox;
    protected boolean sentClick;
    protected Point clickPoint;
    protected Point dragPoint;
    protected Vector selectBoundsPoints;
    protected Shape selectBounds;
    protected ObjectInfo thisObjectInScene;
    protected Scene theScene;

    public ObjectViewer(MeshEditController controller, RowContainer p) {
        super(ModellingApp.getPreferences().getUseOpenGL() && ObjectViewer.isOpenGLAvailable());
        this.controller = controller;
        this.buildChoices(p);
    }

    public MeshEditController getController() {
        return this.controller;
    }

    public double[] estimateDepthRange() {
        Mat4 toView = this.theCamera.getWorldToView();
        ObjectInfo info = this.getController().getObject();
        BoundingBox bounds = info.getBounds();
        double dx = bounds.maxx - bounds.minx;
        double dy = bounds.maxy - bounds.miny;
        double dz = bounds.maxz - bounds.minz;
        double size = 0.5 * Math.sqrt(dx * dx + dy * dy + dz * dz);
        Vec3 origin = this.getDisplayCoordinates().fromLocal().times(bounds.getCenter());
        double depth = toView.times((Vec3)origin).z;
        double min = depth - size;
        double max = depth + size;
        if (this.showScene) {
            for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
                info = this.theScene.getObject(i);
                if (info == this.thisObjectInScene) continue;
                bounds = info.getBounds();
                dx = bounds.maxx - bounds.minx;
                dy = bounds.maxy - bounds.miny;
                dz = bounds.maxz - bounds.minz;
                size = 0.5 * Math.sqrt(dx * dx + dy * dy + dz * dz);
                origin = info.coords.fromLocal().times(bounds.getCenter());
                if (!this.useWorldCoords) {
                    origin = this.thisObjectInScene.coords.toLocal().times(origin);
                }
                if ((depth = toView.times((Vec3)origin).z) - size < min) {
                    min = depth - size;
                }
                if (!(depth + size > max)) continue;
                max = depth + size;
            }
        }
        return new double[]{min, max};
    }

    public synchronized void updateImage() {
        this.adjustCamera(this.isPerspective());
        super.updateImage();
        if (this.controller.getObject() == null) {
            return;
        }
        if (this.showScene && this.theScene != null) {
            Vec3 viewdir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
            for (int i = 0; i < this.theScene.getNumObjects(); ++i) {
                ObjectInfo obj = this.theScene.getObject(i);
                if (obj == this.thisObjectInScene) continue;
                Mat4 objectTransform = obj.coords.fromLocal();
                if (!this.useWorldCoords && this.thisObjectInScene != null) {
                    objectTransform = this.thisObjectInScene.coords.toLocal().times(objectTransform);
                }
                this.theCamera.setObjectTransform(objectTransform);
                obj.object.renderObject(obj, this, viewdir);
            }
        }
        this.theCamera.setObjectTransform(this.getDisplayCoordinates().fromLocal());
        this.drawObject();
        this.drawBorder();
        if (this.showAxes) {
            this.drawCoordinateAxes();
        }
    }

    protected abstract void drawObject();

    public CoordinateSystem getDisplayCoordinates() {
        if (this.useWorldCoords && this.thisObjectInScene != null) {
            return this.thisObjectInScene.coords;
        }
        return this.controller.getObject().coords;
    }

    public boolean getFreehandSelection() {
        return this.freehandSelection;
    }

    public void setFreehandSelection(boolean freehand) {
        this.freehandSelection = freehand;
    }

    public Scene getScene() {
        return this.theScene;
    }

    public void setScene(Scene sc, ObjectInfo thisObject) {
        this.theScene = sc;
        this.thisObjectInScene = thisObject;
    }

    public boolean getSceneVisible() {
        return this.showScene;
    }

    public void setSceneVisible(boolean visible) {
        this.showScene = visible;
    }

    public boolean getUseWorldCoords() {
        return this.useWorldCoords;
    }

    public void setUseWorldCoords(boolean use) {
        this.useWorldCoords = use;
    }

    public void beginDraggingSelection(Point p, boolean square) {
        this.draggingBox = true;
        this.clickPoint = p;
        this.squareBox = square;
        this.dragPoint = null;
        if (this.freehandSelection) {
            this.selectBoundsPoints = new Vector();
        }
    }

    public void endDraggingSelection() {
        if (!this.draggingBox || this.dragPoint == null) {
            this.selectBounds = null;
            return;
        }
        this.repaint();
        this.selectBounds = this.freehandSelection ? this.createPolygonFromSelection() : new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
    }

    private Polygon createPolygonFromSelection() {
        int n = this.selectBoundsPoints.size();
        int[] x = new int[n];
        int[] y = new int[n];
        for (int i = 0; i < n; ++i) {
            Point p = (Point)this.selectBoundsPoints.elementAt(i);
            x[i] = p.x;
            y[i] = p.y;
        }
        return new Polygon(x, y, n);
    }

    public boolean selectionRegionContains(Point p) {
        if (this.selectBounds instanceof Rectangle) {
            return ((Rectangle)this.selectBounds).contains(p);
        }
        if (this.selectBounds instanceof Polygon) {
            return ((Polygon)this.selectBounds).contains(p);
        }
        return false;
    }

    public boolean selectionRegionIntersects(Point p1, Point p2) {
        if (this.selectionRegionContains(p1) || this.selectionRegionContains(p2)) {
            return true;
        }
        if (this.selectBounds instanceof Rectangle) {
            return ((Rectangle)this.selectBounds).intersectsLine(p1.x, p1.y, p2.x, p2.y);
        }
        if (this.selectBounds instanceof Polygon) {
            Polygon polygon = (Polygon)this.selectBounds;
            int[] xpoints = polygon.xpoints;
            int[] ypoints = polygon.ypoints;
            int npoints = polygon.npoints;
            int lastx = xpoints[npoints - 1];
            int lasty = ypoints[npoints - 1];
            for (int i = 0; i < npoints; ++i) {
                int curx = xpoints[i];
                int cury = ypoints[i];
                boolean intersect = Line2D.linesIntersect(lastx, lasty, curx, cury, p1.x, p1.y, p2.x, p2.y);
                if (intersect) {
                    return true;
                }
                lastx = curx;
                lasty = cury;
            }
            return false;
        }
        return false;
    }

    protected void mouseDragged(WidgetMouseEvent e) {
        this.moveToGrid(e);
        if (this.draggingBox && this.freehandSelection) {
            this.dragPoint = e.getPoint();
            this.selectBoundsPoints.addElement(this.dragPoint);
            this.drawDraggedShape(this.createPolygonFromSelection());
        } else if (this.draggingBox) {
            if (this.dragPoint != null) {
                this.drawDraggedShape(new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y)));
            }
            this.dragPoint = e.getPoint();
            if (this.squareBox) {
                if (Math.abs(this.dragPoint.x - this.clickPoint.x) > Math.abs(this.dragPoint.y - this.clickPoint.y)) {
                    this.dragPoint.y = this.dragPoint.y < this.clickPoint.y ? this.clickPoint.y - Math.abs(this.dragPoint.x - this.clickPoint.x) : this.clickPoint.y + Math.abs(this.dragPoint.x - this.clickPoint.x);
                } else {
                    this.dragPoint.x = this.dragPoint.x < this.clickPoint.x ? this.clickPoint.x - Math.abs(this.dragPoint.y - this.clickPoint.y) : this.clickPoint.x + Math.abs(this.dragPoint.y - this.clickPoint.y);
                }
            }
            this.drawDraggedShape(new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y)));
        }
        if (this.sentClick) {
            this.activeTool.mouseDragged(e, this);
        }
    }

    public void previewObject() {
        Scene sc = new Scene();
        Renderer rend = ModellingApp.getPreferences().getObjectPreviewRenderer();
        if (rend == null) {
            return;
        }
        sc.addObject(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), this.theCamera.getCameraCoordinates(), "", null);
        sc.addObject(this.getController().getObject(), null);
        this.adjustCamera(true);
        rend.configurePreview();
        ObjectInfo cameraInfo = new ObjectInfo(new SceneCamera(), this.theCamera.getCameraCoordinates(), "");
        new RenderingDialog(UIUtilities.findFrame(this), rend, sc, this.theCamera, cameraInfo);
        this.adjustCamera(this.isPerspective());
    }
}

