/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.SceneViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BComboBox;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import java.awt.Point;

public class CreateSplineMeshTool
extends EditingTool {
    static int counter = 1;
    static final int FLAT = 0;
    static final int CYLINDER = 1;
    static final int TORUS = 2;
    boolean shiftDown;
    Point clickPoint;
    int usize = 5;
    int vsize = 5;
    int shape = 0;
    int smoothing = 3;
    double thickness = 0.5;

    public CreateSplineMeshTool(EditingWindow fr) {
        super(fr);
        this.initButton("splineMesh");
    }

    public void activate() {
        super.activate();
        this.setHelpText();
    }

    private void setHelpText() {
        String shapeDesc = this.shape == 0 ? "flat" : (this.shape == 1 ? "cylindrical" : "toroidal");
        String smoothingDesc = this.smoothing == 2 ? "interpolating" : "approximating";
        this.theWindow.setHelpText(Translate.text("createSplineMeshTool.helpText", new Object[]{Integer.toString(this.usize), Integer.toString(this.vsize), Translate.text("createSplineMeshTool." + shapeDesc).toLowerCase(), Translate.text("menu." + smoothingDesc).toLowerCase()}));
    }

    public int whichClicks() {
        return 1;
    }

    public String getToolTipText() {
        return Translate.text("createSplineMeshTool.tipText");
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        this.clickPoint = e.getPoint();
        this.shiftDown = e.isShiftDown();
        ((SceneViewer)view).beginDraggingBox(this.clickPoint, this.shiftDown);
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        int i;
        Scene theScene = ((LayoutWindow)this.theWindow).getScene();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (this.shiftDown) {
            if (Math.abs(dragPoint.x - this.clickPoint.x) > Math.abs(dragPoint.y - this.clickPoint.y)) {
                dragPoint.y = dragPoint.y < this.clickPoint.y ? this.clickPoint.y - Math.abs(dragPoint.x - this.clickPoint.x) : this.clickPoint.y + Math.abs(dragPoint.x - this.clickPoint.x);
            } else {
                dragPoint.x = dragPoint.x < this.clickPoint.x ? this.clickPoint.x - Math.abs(dragPoint.y - this.clickPoint.y) : this.clickPoint.x + Math.abs(dragPoint.y - this.clickPoint.y);
            }
        }
        if (dragPoint.x == this.clickPoint.x || dragPoint.y == this.clickPoint.y) {
            ((SceneViewer)view).repaint();
            return;
        }
        Vec3 v1 = cam.convertScreenToWorld(this.clickPoint, 20.0);
        Vec3 v2 = cam.convertScreenToWorld(new Point(dragPoint.x, this.clickPoint.y), 20.0);
        Vec3 v3 = cam.convertScreenToWorld(dragPoint, 20.0);
        Vec3 orig = v1.plus(v3).times(0.5);
        Vec3 xdir = dragPoint.x < this.clickPoint.x ? v1.minus(v2) : v2.minus(v1);
        Vec3 ydir = dragPoint.y < this.clickPoint.y ? v3.minus(v2) : v2.minus(v3);
        double xsize = xdir.length();
        double ysize = ydir.length();
        xdir = xdir.times(1.0 / xsize);
        ydir = ydir.times(1.0 / ysize);
        Vec3 zdir = xdir.cross(ydir);
        Vec3[][] v = this.getMeshPoints(xsize, ysize);
        float[] usmoothness = new float[this.usize];
        float[] vsmoothness = new float[this.vsize];
        for (i = 0; i < this.usize; ++i) {
            usmoothness[i] = 1.0f;
        }
        for (i = 0; i < this.vsize; ++i) {
            vsmoothness[i] = 1.0f;
        }
        SplineMesh obj = new SplineMesh(v, usmoothness, vsmoothness, this.smoothing, this.shape != 0, this.shape == 2);
        ObjectInfo info = new ObjectInfo(obj, new CoordinateSystem(orig, zdir, ydir), "Spline Mesh " + counter++);
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        UndoRecord undo = new UndoRecord(this.theWindow, false);
        int[] sel = theScene.getSelection();
        ((LayoutWindow)this.theWindow).addObject(info, undo);
        undo.addCommand(16, new Object[]{sel});
        this.theWindow.setUndoRecord(undo);
        ((LayoutWindow)this.theWindow).setSelection(theScene.getNumObjects() - 1);
        this.theWindow.updateImage();
    }

    private Vec3[][] getMeshPoints(double xsize, double ysize) {
        Vec3[][] v = new Vec3[this.usize][this.vsize];
        if (this.shape == 0) {
            double xmin = -xsize * 0.5;
            double ymin = -ysize * 0.5;
            double uscale = 1.0 / (double)(this.usize - 1);
            double vscale = 1.0 / (double)(this.vsize - 1);
            for (int i = 0; i < this.usize; ++i) {
                for (int j = 0; j < this.vsize; ++j) {
                    v[i][j] = new Vec3(xsize * (double)i * uscale + xmin, ysize * (double)j * vscale + ymin, 0.0);
                }
            }
        } else if (this.shape == 1) {
            double rad = xsize * 0.5;
            double ymin = -ysize * 0.5;
            double uscale = Math.PI * 2 / (double)this.usize;
            double vscale = 1.0 / (double)(this.vsize - 1);
            for (int i = 0; i < this.usize; ++i) {
                for (int j = 0; j < this.vsize; ++j) {
                    v[i][j] = new Vec3(rad * Math.sin(uscale * (double)i), ysize * (double)j * vscale + ymin, rad * Math.cos(uscale * (double)i));
                }
            }
        } else {
            double rad = Math.min(xsize, ysize) * 0.25 * this.thickness;
            double radx = xsize * 0.5 - rad;
            double rady = ysize * 0.5 - rad;
            double uscale = Math.PI * 2 / (double)this.usize;
            double vscale = Math.PI * 2 / (double)this.vsize;
            Vec3 vr = new Vec3();
            Vec3 vc = new Vec3();
            for (int i = 0; i < this.usize; ++i) {
                vc.set(radx * Math.cos(uscale * (double)i), rady * Math.sin(uscale * (double)i), 0.0);
                vr.set(rad * Math.cos(uscale * (double)i), rad * Math.sin(uscale * (double)i), 0.0);
                for (int j = 0; j < this.vsize; ++j) {
                    v[i][j] = new Vec3(vc.x + vr.x * Math.cos(vscale * (double)j), vc.y + vr.y * Math.cos(vscale * (double)j), rad * Math.sin(vscale * (double)j));
                }
            }
        }
        return v;
    }

    public void iconDoubleClicked() {
        int minv;
        final ValueSlider thicknessSlider = new ValueSlider(0.0, 1.0, 100, this.thickness);
        thicknessSlider.setEnabled(this.shape == 2);
        ValueField usizeField = new ValueField((double)this.usize, 7);
        ValueField vsizeField = new ValueField((double)this.vsize, 7);
        BComboBox smoothingChoice = new BComboBox(new String[]{Translate.text("Interpolating"), Translate.text("Approximating")});
        if (this.smoothing == 2) {
            smoothingChoice.setSelectedIndex(0);
        } else {
            smoothingChoice.setSelectedIndex(1);
        }
        final BComboBox shapeChoice = new BComboBox(new String[]{Translate.text("Flat"), Translate.text("Cylinder"), Translate.text("Torus")});
        if (this.shape == 0) {
            shapeChoice.setSelectedIndex(0);
        } else if (this.shape == 1) {
            shapeChoice.setSelectedIndex(1);
        } else {
            shapeChoice.setSelectedIndex(2);
        }
        shapeChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                thicknessSlider.setEnabled(shapeChoice.getSelectedIndex() == 2);
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(this.theFrame, Translate.text("selectMeshSizeShape"), new Widget[]{usizeField, vsizeField, shapeChoice, smoothingChoice, thicknessSlider}, new String[]{Translate.text("uSize"), Translate.text("vSize"), Translate.text("Shape"), Translate.text("Smoothing Method"), Translate.text("Thickness")});
        if (!dlg.clickedOk()) {
            return;
        }
        int minu = shapeChoice.getSelectedIndex() == 0 ? 2 : 3;
        int n = minv = shapeChoice.getSelectedIndex() == 2 ? 3 : 2;
        if (usizeField.getValue() < (double)minu) {
            new BStandardDialog("", Translate.text("uSizeTooSmall", Integer.toString(minu)), BStandardDialog.ERROR).showMessageDialog(this.theFrame);
            return;
        }
        if (vsizeField.getValue() < (double)minv) {
            new BStandardDialog("", Translate.text("vSizeTooSmall", Integer.toString(minv)), BStandardDialog.ERROR).showMessageDialog(this.theFrame);
            return;
        }
        this.usize = (int)usizeField.getValue();
        this.vsize = (int)vsizeField.getValue();
        int i = smoothingChoice.getSelectedIndex();
        this.smoothing = i == 0 ? 2 : 3;
        i = shapeChoice.getSelectedIndex();
        this.shape = i == 0 ? 0 : (i == 1 ? 1 : 2);
        this.thickness = thicknessSlider.getValue();
        this.setHelpText();
    }
}

