/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.ThemeManager;
import artofillusion.ui.Translate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class ApplicationPreferences {
    private Properties properties;
    private int defaultDisplayMode;
    private int undoLevels;
    private double interactiveTol;
    private boolean keepBackupFiles;
    private boolean useOpenGL;
    private boolean useCompoundMeshTool;
    private Renderer objectPreviewRenderer;
    private Renderer texturePreviewRenderer;
    private Renderer defaultRenderer;

    public ApplicationPreferences() {
        this.loadPreferences();
    }

    public void loadPreferences() {
        File f2;
        this.properties = new Properties();
        this.initDefaultPreferences();
        File f = new File(ApplicationPreferences.getPreferencesDirectory(), "aoiprefs");
        if (!f.exists() && (f2 = new File(System.getProperty("user.home"), ".aoiprefs")).exists()) {
            f2.renameTo(f);
        }
        if (!f.exists()) {
            Translate.setLocale(Locale.getDefault());
            return;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            this.properties.load(in);
            ((InputStream)in).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.parsePreferences();
    }

    public void savePreferences() {
        this.properties.put("theme", ThemeManager.getSelectedTheme().resource.getId());
        ThemeManager.ColorSet[] colorSets = ThemeManager.getSelectedTheme().getColorSets();
        for (int i = 0; i < colorSets.length; ++i) {
            if (colorSets[i] != ThemeManager.getSelectedColorSet()) continue;
            this.properties.put("themeColorSet", Integer.toString(i));
        }
        File f = new File(ApplicationPreferences.getPreferencesDirectory(), "aoiprefs");
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            this.properties.store(out, "Art of Illusion Preferences File");
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static File getPreferencesDirectory() {
        File dir2 = new File(System.getProperty("user.home"), ".artofillusion");
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
        return dir2;
    }

    private void initDefaultPreferences() {
        Renderer[] renderers = ModellingApp.getRenderers();
        if (renderers.length > 0) {
            this.texturePreviewRenderer = this.defaultRenderer = this.getNamedRenderer("Raytracer");
            this.objectPreviewRenderer = this.defaultRenderer;
        }
        this.defaultDisplayMode = 2;
        this.interactiveTol = 0.05;
        this.undoLevels = 6;
        this.useOpenGL = true;
        this.keepBackupFiles = false;
        this.useCompoundMeshTool = false;
    }

    private void parsePreferences() {
        this.objectPreviewRenderer = this.getNamedRenderer(this.properties.getProperty("objectPreviewRenderer"));
        this.texturePreviewRenderer = this.getNamedRenderer(this.properties.getProperty("texturePreviewRenderer"));
        this.defaultRenderer = this.getNamedRenderer(this.properties.getProperty("defaultRenderer"));
        this.defaultDisplayMode = this.parseIntProperty("defaultDisplayMode", this.defaultDisplayMode);
        this.interactiveTol = this.parseDoubleProperty("interactiveSurfaceError", this.interactiveTol);
        this.undoLevels = this.parseIntProperty("undoLevels", this.undoLevels);
        this.useOpenGL = this.parseBooleanProperty("useOpenGL", this.useOpenGL);
        this.keepBackupFiles = this.parseBooleanProperty("keepBackupFiles", this.keepBackupFiles);
        this.useCompoundMeshTool = this.parseBooleanProperty("useCompoundMeshTool", this.useCompoundMeshTool);
        Translate.setLocale(this.parseLocaleProperty("language"));
        if (this.properties.getProperty("theme") == null) {
            ThemeManager.setSelectedTheme(ThemeManager.getDefaultTheme());
            ThemeManager.setSelectedColorSet(ThemeManager.getSelectedTheme().getColorSets()[this.parseIntProperty("colorScheme", 0)]);
        } else {
            String themeId = this.properties.getProperty("theme");
            List themes = ThemeManager.getThemes();
            for (int i = 0; i < themes.size(); ++i) {
                ThemeManager.ThemeInfo theme = (ThemeManager.ThemeInfo)themes.get(i);
                if (!theme.resource.getId().equals(themeId)) continue;
                ThemeManager.setSelectedTheme(theme);
                int colorSetIndex = this.parseIntProperty("themeColorSet", 0);
                ThemeManager.ColorSet[] colorSets = theme.getColorSets();
                if (colorSetIndex <= -1 || colorSetIndex >= colorSets.length) break;
                ThemeManager.setSelectedColorSet(colorSets[colorSetIndex]);
                break;
            }
        }
    }

    private int parseIntProperty(String name, int defaultVal) {
        try {
            return Integer.parseInt(this.properties.getProperty(name));
        }
        catch (Exception ex) {
            return defaultVal;
        }
    }

    private double parseDoubleProperty(String name, double defaultVal) {
        try {
            return new Double(this.properties.getProperty(name));
        }
        catch (Exception ex) {
            return defaultVal;
        }
    }

    private boolean parseBooleanProperty(String name, boolean defaultVal) {
        String prop = this.properties.getProperty(name);
        if (prop == null) {
            return defaultVal;
        }
        return Boolean.valueOf(prop);
    }

    private Locale parseLocaleProperty(String name) {
        try {
            String desc = this.properties.getProperty(name);
            String language = desc.substring(0, 2);
            String country = desc.substring(3);
            return new Locale(language, country);
        }
        catch (Exception ex) {
            return Locale.getDefault();
        }
    }

    private Renderer getNamedRenderer(String name) {
        Renderer[] renderers = ModellingApp.getRenderers();
        if (renderers.length == 0) {
            return null;
        }
        for (int i = 0; i < renderers.length; ++i) {
            if (!renderers[i].getName().equals(name)) continue;
            return renderers[i];
        }
        return renderers[renderers.length - 1];
    }

    public final Renderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public final void setDefaultRenderer(Renderer rend) {
        this.defaultRenderer = rend;
        this.properties.put("defaultRenderer", rend.getName());
    }

    public final Renderer getObjectPreviewRenderer() {
        return this.objectPreviewRenderer;
    }

    public final void setObjectPreviewRenderer(Renderer rend) {
        this.objectPreviewRenderer = rend;
        this.properties.put("objectPreviewRenderer", rend.getName());
    }

    public final Renderer getTexturePreviewRenderer() {
        return this.texturePreviewRenderer;
    }

    public final void setTexturePreviewRenderer(Renderer rend) {
        this.texturePreviewRenderer = rend;
        this.properties.put("texturePreviewRenderer", rend.getName());
    }

    public final int getDefaultDisplayMode() {
        return this.defaultDisplayMode;
    }

    public final void setDefaultDisplayMode(int mode) {
        this.defaultDisplayMode = mode;
        this.properties.put("defaultDisplayMode", Integer.toString(mode));
    }

    public final double getInteractiveSurfaceError() {
        return this.interactiveTol;
    }

    public final void setInteractiveSurfaceError(double tol) {
        boolean changed = this.interactiveTol != tol;
        this.interactiveTol = tol;
        this.properties.put("interactiveSurfaceError", Double.toString(tol));
        if (changed) {
            EditingWindow[] windows = ModellingApp.getWindows();
            for (int i = 0; i < windows.length; ++i) {
                Scene sc = windows[i].getScene();
                if (sc == null) continue;
                for (int j = 0; j < sc.getNumObjects(); ++j) {
                    ObjectInfo info = sc.getObject(j);
                    Vec3 size = info.getBounds().getSize();
                    info.object.setSize(size.x, size.y, size.z);
                    info.clearCachedMeshes();
                }
                windows[i].updateImage();
            }
        }
    }

    public final Locale getLocale() {
        return Translate.getLocale();
    }

    public final void setLocale(Locale locale) {
        Translate.setLocale(locale);
        this.properties.put("language", locale.getLanguage() + '_' + locale.getCountry());
    }

    public final int getUndoLevels() {
        return this.undoLevels;
    }

    public final void setUndoLevels(int levels) {
        this.undoLevels = levels;
        this.properties.put("undoLevels", Integer.toString(levels));
    }

    public final boolean getUseOpenGL() {
        return this.useOpenGL;
    }

    public final void setUseOpenGL(boolean use) {
        this.useOpenGL = use;
        this.properties.put("useOpenGL", Boolean.toString(use));
    }

    public final boolean getKeepBackupFiles() {
        return this.keepBackupFiles;
    }

    public final void setKeepBackupFiles(boolean keep) {
        this.keepBackupFiles = keep;
        this.properties.put("keepBackupFiles", Boolean.toString(keep));
    }

    public final boolean getUseCompoundMeshTool() {
        return this.useCompoundMeshTool;
    }

    public final void setUseCompoundMeshTool(boolean use) {
        this.useCompoundMeshTool = use;
        this.properties.put("useCompoundMeshTool", Boolean.toString(use));
    }
}

