/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.Tube;
import artofillusion.texture.Texture;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Dimension;

public class TubeDialog
extends BDialog {
    LayoutWindow window;
    Curve theCurve;
    ObjectInfo curveInfo;
    Tube theTube;
    BButton okButton;
    BButton cancelButton;
    ValueField thicknessField;
    BComboBox endsChoice;
    ObjectPreviewCanvas preview;
    private static int counter = 1;

    public TubeDialog(LayoutWindow window, ObjectInfo curve) {
        super((WindowWidget)window, "Tube", true);
        this.window = window;
        this.curveInfo = curve;
        this.theCurve = (Curve)curve.object;
        Scene scene = window.getScene();
        FormContainer content = new FormContainer(4, 10);
        this.setContent((Widget)BOutline.createEmptyBorder((Widget)content, (int)ModellingApp.standardDialogInsets));
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
        content.add((Widget)new BLabel("Tube Width"), 0, 0);
        content.add((Widget)new BLabel("Cap Ends"), 0, 1);
        this.thicknessField = new ValueField(0.1, 3, 5);
        content.add((Widget)this.thicknessField, 1, 0);
        this.thicknessField.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        this.endsChoice = new BComboBox((Object[])new String[]{"Open Ends", "Flat Ends"});
        content.add((Widget)this.endsChoice, 1, 1);
        this.endsChoice.setEnabled(!this.theCurve.isClosed());
        this.endsChoice.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        this.preview = new ObjectPreviewCanvas(null);
        content.add((Widget)this.preview, 0, 2, 2, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.preview.setPreferredSize(new Dimension(150, 150));
        RowContainer buttons = new RowContainer();
        content.add((Widget)buttons, 0, 3, 2, 1, new LayoutInfo());
        this.okButton = Translate.button((String)"ok", (Object)((Object)this), (String)"doOk");
        buttons.add((Widget)this.okButton);
        this.cancelButton = Translate.button((String)"cancel", (Object)((Object)this), (String)"dispose");
        buttons.add((Widget)this.cancelButton);
        this.makeObject();
        this.pack();
        UIUtilities.centerDialog((BDialog)this, (WindowWidget)window);
        this.setVisible(true);
    }

    private void doOk() {
        this.window.addObject((Object3D)this.theTube, this.curveInfo.coords.duplicate(), "Tube " + counter++, null);
        this.window.setSelection(this.window.getScene().getNumObjects() - 1);
        this.window.setUndoRecord(new UndoRecord((EditingWindow)this.window, false, 5, new Object[]{new Integer(this.window.getScene().getNumObjects() - 1)}));
        this.window.updateImage();
        this.dispose();
    }

    private void makeObject() {
        MeshVertex[] vert = this.theCurve.getVertices();
        double[] thickness = new double[vert.length];
        for (int i = 0; i < thickness.length; ++i) {
            thickness[i] = this.thicknessField.getValue();
        }
        int endsStyle = this.theCurve.isClosed() ? 1 : (this.endsChoice.getSelectedIndex() == 0 ? 0 : 2);
        this.theTube = new Tube(this.theCurve, thickness, endsStyle);
        ObjectInfo tubeInfo = new ObjectInfo((Object3D)this.theTube, new CoordinateSystem(), "");
        Texture tex = this.window.getScene().getDefaultTexture();
        tubeInfo.setTexture(tex, tex.getDefaultMapping((Object3D)this.theTube));
        this.preview.setObject((Object3D)this.theTube);
        this.preview.repaint();
    }
}

