/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.ModellingTool;
import artofillusion.Scene;
import artofillusion.object.Curve;
import artofillusion.object.ObjectInfo;
import artofillusion.tools.SkinDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import java.util.Vector;

public class SkinTool
implements ModellingTool {
    public String getName() {
        return Translate.text((String)"menu.skin");
    }

    public void commandSelected(LayoutWindow window) {
        Scene scene = window.getScene();
        int[] selection = scene.getSelection();
        Vector<ObjectInfo> curves = new Vector<ObjectInfo>();
        for (int i = 0; i < selection.length; ++i) {
            ObjectInfo obj = scene.getObject(selection[i]);
            if (!(obj.object instanceof Curve)) continue;
            curves.addElement(obj);
        }
        if (curves.size() < 2) {
            new BStandardDialog("", (Object)UIUtilities.breakString((String)"You must select two or more curves to create a skin across."), BStandardDialog.INFORMATION).showMessageDialog((Widget)window.getFrame());
            return;
        }
        Curve c = (Curve)((ObjectInfo)curves.elementAt((int)0)).object;
        for (int i = 1; i < curves.size(); ++i) {
            Curve c2 = (Curve)((ObjectInfo)curves.elementAt((int)i)).object;
            if (c2.getVertices().length != c.getVertices().length) {
                new BStandardDialog("", (Object)UIUtilities.breakString((String)"All the curves must have the same number of points."), BStandardDialog.INFORMATION).showMessageDialog((Widget)window.getFrame());
                return;
            }
            if (c2.isClosed() != c.isClosed()) {
                new BStandardDialog("", (Object)UIUtilities.breakString((String)"You cannot create a skin between a closed curve and an open one."), BStandardDialog.INFORMATION).showMessageDialog((Widget)window.getFrame());
                return;
            }
            if (c2.getSmoothingMethod() == c.getSmoothingMethod() || c.getSmoothingMethod() == 0 || c2.getSmoothingMethod() == 0) continue;
            new BStandardDialog("", (Object)UIUtilities.breakString((String)"You cannot create a skin between an interpolating curve and an approximating one."), BStandardDialog.INFORMATION).showMessageDialog((Widget)window.getFrame());
            return;
        }
        new SkinDialog(window, curves);
    }
}

