/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.ModellingTool;
import artofillusion.Scene;
import artofillusion.object.Curve;
import artofillusion.object.Mesh;
import artofillusion.object.ObjectInfo;
import artofillusion.tools.LatheDialog;
import artofillusion.ui.Translate;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;

public class LatheTool
implements ModellingTool {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    public static final int AXIS_THROUGH_ENDS = 3;

    public String getName() {
        return Translate.text((String)"menu.lathe");
    }

    public void commandSelected(LayoutWindow window) {
        Scene scene = window.getScene();
        int[] selection = scene.getSelection();
        if (selection.length == 1) {
            ObjectInfo obj = scene.getObject(selection[0]);
            if (obj.object instanceof Curve) {
                new LatheDialog(window, obj);
                return;
            }
        }
        new BStandardDialog("", (Object)"You must select a single curve to lathe.", BStandardDialog.INFORMATION).showMessageDialog((Widget)window.getFrame());
    }

    public static Mesh latheCurve(Curve curve, int axis, int segments, double angle, double radius) {
        return LatheDialog.latheCurve(curve, axis, segments, angle, radius);
    }
}

