/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.SpotLight;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.Ray;
import artofillusion.util.ThreadManager;

public class SpotlightPhotonSource
implements PhotonSource {
    private SpotLight light;
    private CoordinateSystem coords;
    private RGBColor color;
    private float lightIntensity;
    private double minu;

    public SpotlightPhotonSource(SpotLight light, CoordinateSystem coords, BoundingBox sceneBounds) {
        this.light = light;
        this.coords = coords;
        double exp = light.getExponent() + 1.0;
        this.minu = Math.pow(light.getAngleCosine(), exp) / exp;
        Vec3[] corner = sceneBounds.getCorners();
        Vec3 pos = coords.getOrigin();
        double maxDist2 = 0.0;
        for (int i = 0; i < corner.length; ++i) {
            double dist2 = pos.distance2(corner[i]);
            if (!(dist2 > maxDist2)) continue;
            maxDist2 = dist2;
        }
        this.color = new RGBColor();
        double radius = Math.sqrt(maxDist2) * 0.5;
        light.getLight(this.color, (float)radius);
        this.lightIntensity = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
        if (this.lightIntensity == 0.0f) {
            return;
        }
        this.color.scale(1.0f / this.lightIntensity);
        this.lightIntensity *= (float)((1.0 / exp - this.minu) * 2.0 * Math.PI * radius * radius);
    }

    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    public void generatePhotons(final PhotonMap map, double intensity, ThreadManager threads) {
        int n;
        final Thread currentThread = Thread.currentThread();
        final Vec3 pos = this.coords.getOrigin();
        final Vec3 xdir = this.coords.fromLocal().timesDirection(Vec3.vx());
        final Vec3 ydir = this.coords.fromLocal().timesDirection(Vec3.vy());
        final Vec3 zdir = this.coords.getZDirection();
        final double exp = this.light.getExponent() + 1.0;
        final double expInv = 1.0 / exp;
        double maxu = 1.0 / exp;
        double usize = maxu - this.minu;
        final boolean randomizeOrigin = map.getRaytracer().penumbra;
        for (int num = (int)intensity; num > 0; num -= n * n) {
            n = Math.max((int)Math.sqrt(num), 1);
            final double du = usize / (double)n;
            final double dv = Math.PI * 2 / (double)n;
            threads.setNumIndices(n * n);
            threads.setTask(new ThreadManager.Task(){

                public void execute(int index) {
                    if (map.getRaytracer().renderThread != currentThread) {
                        return;
                    }
                    int i = index / n;
                    int j = index - i * n;
                    double baseu = SpotlightPhotonSource.this.minu + (double)i * du;
                    double basev = (double)j + dv;
                    Ray r = new Ray(map.getContext());
                    Vec3 orig = r.getOrigin();
                    Vec3 dir = r.getDirection();
                    double u = baseu + map.random.nextDouble() * du;
                    double v = basev + map.random.nextDouble() * dv;
                    double ctheta = Math.pow(u * exp, expInv);
                    double stheta = Math.sqrt(1.0 - ctheta * ctheta);
                    double cphi = Math.cos(v);
                    double sphi = Math.sin(v);
                    double x = stheta * sphi;
                    double y = stheta * cphi;
                    double z = ctheta;
                    dir.set(x * xdir.x + y * ydir.x + z * zdir.x, x * xdir.y + y * ydir.y + z * zdir.y, x * xdir.z + y * ydir.z + z * zdir.z);
                    orig.set(pos);
                    if (randomizeOrigin) {
                        map.randomizePoint(orig, SpotlightPhotonSource.this.light.getRadius());
                    }
                    r.newID();
                    map.spawnPhoton(r, SpotlightPhotonSource.this.color, false);
                }

                public void cleanup() {
                    map.getContext().cleanup();
                }
            });
            threads.run();
        }
    }
}

