/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Sphere;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.SurfaceIntersection;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;

public class RTSphere
extends RTObject {
    Sphere theSphere;
    double r;
    double r2;
    double cx;
    double cy;
    double cz;
    double[] param;
    boolean bumpMapped;
    Mat4 toLocal;
    Mat4 fromLocal;
    public static final double TOL = 1.0E-12;

    public RTSphere(Sphere sphere, Mat4 fromLocal, Mat4 toLocal, double[] param) {
        this.theSphere = sphere;
        this.param = param;
        this.cx = fromLocal.m14 / fromLocal.m44;
        this.cy = fromLocal.m24 / fromLocal.m44;
        this.cz = fromLocal.m34 / fromLocal.m44;
        this.r = sphere.getRadii().x;
        this.r2 = this.r * this.r;
        this.bumpMapped = sphere.getTexture().hasComponent(5);
        if (this.bumpMapped) {
            this.fromLocal = fromLocal;
        }
        this.toLocal = toLocal;
    }

    public final TextureMapping getTextureMapping() {
        return this.theSphere.getTextureMapping();
    }

    public final MaterialMapping getMaterialMapping() {
        return this.theSphere.getMaterialMapping();
    }

    protected SurfaceIntersection checkIntersection(Ray r) {
        double t;
        int numIntersections;
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        Vec3 v1 = r.tempVec1;
        Vec3 v2 = r.tempVec2;
        double t2 = 0.0;
        v1.set(this.cx - orig.x, this.cy - orig.y, this.cz - orig.z);
        double b = dir.x * v1.x + dir.y * v1.y + dir.z * v1.z;
        double c = v1.x * v1.x + v1.y * v1.y + v1.z * v1.z - this.r2;
        if (c > 1.0E-12) {
            if (b <= 0.0) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
            double d = b * b - c;
            if (d < 0.0) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
            numIntersections = 2;
            double root = Math.sqrt(d);
            t = b - root;
            t2 = b + root;
            v2.set(orig.x + t2 * dir.x, orig.y + t2 * dir.y, orig.z + t2 * dir.z);
            this.projectPoint(v2);
        } else if (c < -1.0E-12) {
            double d = b * b - c;
            if (d < 0.0) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
            numIntersections = 1;
            t = b + Math.sqrt(d);
        } else {
            if (b <= 0.0) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
            double d = b * b - c;
            if (d < 0.0) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
            numIntersections = 1;
            t = b + Math.sqrt(d);
        }
        v1.set(orig.x + t * dir.x, orig.y + t * dir.y, orig.z + t * dir.z);
        this.projectPoint(v1);
        return new SphereIntersection(this, numIntersections, v1, v2, t, t2);
    }

    private void projectPoint(Vec3 pos) {
        double dx = pos.x - this.cx;
        double dy = pos.y - this.cy;
        double dz = pos.z - this.cz;
        double scale = this.r / Math.sqrt(dx * dx + dy * dy + dz * dz);
        pos.set(this.cx + dx * scale, this.cy + dy * scale, this.cz + dz * scale);
    }

    public BoundingBox getBounds() {
        return new BoundingBox(this.cx - this.r, this.cx + this.r, this.cy - this.r, this.cy + this.r, this.cz - this.r, this.cz + this.r);
    }

    public boolean intersectsBox(BoundingBox bb) {
        Vec3 c = new Vec3(this.cx, this.cy, this.cz);
        if (this.cx < bb.minx) {
            c.x = bb.minx;
        } else if (this.cx > bb.maxx) {
            c.x = bb.maxx;
        }
        if (this.cy < bb.miny) {
            c.y = bb.miny;
        } else if (this.cy > bb.maxy) {
            c.y = bb.maxy;
        }
        if (this.cz < bb.minz) {
            c.z = bb.minz;
        } else if (this.cz > bb.maxz) {
            c.z = bb.maxz;
        }
        c.set(c.x - this.cx, c.y - this.cy, c.z - this.cz);
        if (c.length2() > this.r2) {
            return false;
        }
        c.set(bb.minx - this.cx, bb.miny - this.cy, bb.minz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.minx - this.cx, bb.miny - this.cy, bb.maxz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.minx - this.cx, bb.maxy - this.cy, bb.minz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.minx - this.cx, bb.maxy - this.cy, bb.maxz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.maxx - this.cx, bb.miny - this.cy, bb.minz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.maxx - this.cx, bb.miny - this.cy, bb.maxz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.maxx - this.cx, bb.maxy - this.cy, bb.minz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.maxx - this.cx, bb.maxy - this.cy, bb.maxz - this.cz);
        return c.length2() > this.r2;
    }

    public Mat4 toLocal() {
        return this.toLocal;
    }

    private static class SphereIntersection
    implements SurfaceIntersection {
        private RTSphere sphere;
        private int numIntersections;
        private double dist1;
        private double dist2;
        private double r1x;
        private double r1y;
        private double r1z;
        private double r2x;
        private double r2y;
        private double r2z;
        private boolean trueNormValid;
        private Vec3 trueNorm;
        private Vec3 pos;

        public SphereIntersection(RTSphere sphere, int numIntersections, Vec3 point1, Vec3 point2, double dist1, double dist2) {
            this.sphere = sphere;
            this.numIntersections = numIntersections;
            this.dist1 = dist1;
            this.dist2 = dist2;
            this.r1x = point1.x;
            this.r1y = point1.y;
            this.r1z = point1.z;
            this.r2x = point2.x;
            this.r2y = point2.y;
            this.r2z = point2.z;
            this.trueNorm = new Vec3();
            this.pos = new Vec3();
        }

        public int numIntersections() {
            return this.numIntersections;
        }

        public void intersectionPoint(int n, Vec3 p) {
            if (n == 0) {
                p.set(this.r1x, this.r1y, this.r1z);
            } else {
                p.set(this.r2x, this.r2y, this.r2z);
            }
        }

        public double intersectionDist(int n) {
            if (n == 0) {
                return this.dist1;
            }
            return this.dist2;
        }

        public void intersectionProperties(TextureSpec spec, Vec3 n, Vec3 viewDir, double size, double time) {
            this.calcTrueNorm();
            n.set(this.trueNorm);
            TextureMapping map = this.sphere.theSphere.getTextureMapping();
            this.pos.set(this.r1x, this.r1y, this.r1z);
            if (map instanceof UniformMapping) {
                map.getTextureSpec(this.pos, spec, -n.dot(viewDir), size, time, this.sphere.param);
            } else {
                this.sphere.toLocal.transform(this.pos);
                map.getTextureSpec(this.pos, spec, -n.dot(viewDir), size, time, this.sphere.param);
            }
            if (this.sphere.bumpMapped) {
                this.sphere.fromLocal.transformDirection(spec.bumpGrad);
                n.scale(spec.bumpGrad.dot(n) + 1.0);
                n.subtract(spec.bumpGrad);
                n.normalize();
            }
        }

        public void intersectionTransparency(int n, RGBColor trans, double angle, double size, double time) {
            TextureMapping map = this.sphere.theSphere.getTextureMapping();
            if (n == 0) {
                this.pos.set(this.r1x, this.r1y, this.r1z);
            } else {
                this.pos.set(this.r2x, this.r2y, this.r2z);
            }
            if (map instanceof UniformMapping) {
                map.getTransparency(this.pos, trans, angle, size, time, this.sphere.param);
            } else {
                this.sphere.toLocal.transform(this.pos);
                map.getTransparency(this.pos, trans, angle, size, time, this.sphere.param);
            }
        }

        public void trueNormal(Vec3 n) {
            this.calcTrueNorm();
            n.set(this.trueNorm);
        }

        private final void calcTrueNorm() {
            if (this.trueNormValid) {
                return;
            }
            this.trueNormValid = true;
            this.trueNorm.set(this.r1x - this.sphere.cx, this.r1y - this.sphere.cy, this.r1z - this.sphere.cz);
            this.trueNorm.normalize();
        }
    }
}

