/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.RTDisplacedTriangle;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.Raytracer;
import artofillusion.texture.TextureSpec;
import artofillusion.util.ThreadManager;

public class DisplacedTrianglePhotonSource
implements PhotonSource {
    private RTDisplacedTriangle tri;
    private RGBColor color;
    private float lightIntensity;

    public DisplacedTrianglePhotonSource(RTDisplacedTriangle tri, PhotonMap map) {
        this.tri = tri;
        Vec3 vert1 = tri.tri.theMesh.vert[tri.tri.v1];
        Vec3 vert2 = tri.tri.theMesh.vert[tri.tri.v2];
        Vec3 vert3 = tri.tri.theMesh.vert[tri.tri.v3];
        Vec3 e1 = vert2.minus(vert1);
        Vec3 e2 = vert3.minus(vert1);
        double area = 0.5 * e1.cross(e2).length();
        double dist1 = e1.length();
        double dist2 = e2.length();
        double dist3 = vert2.distance(vert3);
        double avgSize = (dist1 + dist2 + dist3) * 0.16666666666666666;
        area += avgSize * (tri.maxheight - tri.minheight);
        TextureSpec spec = map.getContext().surfSpec[0];
        double third = 0.3333333333333333;
        this.color = new RGBColor();
        tri.tri.getTextureSpec(spec, 1.0, third, third, third, avgSize, map.getRaytracer().time);
        this.color.copy(spec.emissive);
        tri.tri.getTextureSpec(spec, -1.0, third, third, third, avgSize, map.getRaytracer().time);
        this.color.add(spec.emissive);
        this.lightIntensity = 0.5f * (this.color.getRed() + this.color.getGreen() + this.color.getBlue()) * (float)area;
    }

    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    public void generatePhotons(PhotonMap map, double intensity, ThreadManager threads) {
        Raytracer rt = map.getRaytracer();
        TextureSpec spec = map.getContext().surfSpec[0];
        Ray r = new Ray(map.getContext());
        Vec3 vert1 = this.tri.tri.theMesh.vert[this.tri.tri.v1];
        Vec3 vert2 = this.tri.tri.theMesh.vert[this.tri.tri.v2];
        Vec3 vert3 = this.tri.tri.theMesh.vert[this.tri.tri.v3];
        Vec3 norm1 = this.tri.tri.theMesh.norm[this.tri.tri.n1];
        Vec3 norm2 = this.tri.tri.theMesh.norm[this.tri.tri.n2];
        Vec3 norm3 = this.tri.tri.theMesh.norm[this.tri.tri.n3];
        Vec3 temp1 = new Vec3();
        Vec3 temp2 = new Vec3();
        Vec3 temp3 = new Vec3();
        Vec3 temp4 = new Vec3();
        Vec3 normal = new Vec3();
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        double emittedIntensity = 0.0;
        double tol = rt.surfaceError;
        while (emittedIntensity < intensity) {
            double dot;
            double absdot;
            double v;
            double u;
            double w;
            while ((w = 1.0 - (u = map.random.nextDouble()) - (v = map.random.nextDouble())) < 0.0) {
            }
            double disp = this.tri.tri.getDisplacement(u, v, w, tol, rt.time);
            orig.set(vert1.x + disp * norm1.x, vert1.y + disp * norm1.y, vert1.z + disp * norm1.z);
            double dhdu = (this.tri.tri.getDisplacement(u + 1.0E-5, v, w - 1.0E-5, tol, rt.time) - disp) * 100000.0;
            double dhdv = (this.tri.tri.getDisplacement(u, v + 1.0E-5, w - 1.0E-5, tol, rt.time) - disp) * 100000.0;
            normal.set(u * norm1.x + v * norm2.x + w * norm3.x, u * norm1.y + v * norm2.y + w * norm3.y, u * norm1.z + v * norm2.z + w * norm3.z);
            normal.normalize();
            temp1.set(vert1.x + disp * norm1.x, vert1.y + disp * norm1.y, vert1.z + disp * norm1.z);
            temp2.set(vert2.x + disp * norm2.x, vert2.y + disp * norm2.y, vert2.z + disp * norm2.z);
            temp3.set(vert3.x + disp * norm3.x, vert3.y + disp * norm3.y, vert3.z + disp * norm3.z);
            temp1.set(temp1.x - temp3.x, temp1.y - temp3.y, temp1.z - temp3.z);
            temp2.set(temp3.x - temp2.x, temp3.y - temp2.y, temp3.z - temp2.z);
            temp3.set(temp1.y * normal.z - temp1.z * normal.y, temp1.z * normal.x - temp1.x * normal.z, temp1.x * normal.y - temp1.y * normal.x);
            temp4.set(temp2.y * normal.z - temp2.z * normal.y, temp2.z * normal.x - temp2.x * normal.z, temp2.x * normal.y - temp2.y * normal.x);
            temp3.scale(-1.0 / temp3.dot(temp2));
            temp4.scale(1.0 / temp4.dot(temp1));
            temp1.set(dhdu * temp4.x + dhdv * temp3.x, dhdu * temp4.y + dhdv * temp3.y, dhdu * temp4.z + dhdv * temp3.z);
            normal.scale(temp1.dot(normal) + 1.0);
            normal.subtract(temp1);
            normal.normalize();
            do {
                dir.set(0.0, 0.0, 0.0);
                map.randomizePoint(dir, 1.0);
                dir.normalize();
            } while ((absdot = (dot = normal.dot(dir)) > 0.0 ? dot : -dot) < map.random.nextDouble());
            this.tri.tri.getTextureSpec(spec, dot, u, v, w, rt.smoothScale, rt.time);
            this.color.copy(spec.emissive);
            float sum = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
            emittedIntensity += (double)sum;
            if (emittedIntensity > intensity && (emittedIntensity - intensity) / (double)sum > (double)map.random.nextFloat()) {
                return;
            }
            if (sum < 1.0f) {
                if (sum < map.random.nextFloat()) continue;
                this.color.scale(1.0f / sum);
            }
            r.newID();
            map.spawnPhoton(r, this.color, true);
        }
    }
}

