/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raster;

import artofillusion.math.RGBColor;
import artofillusion.raster.Fragment;
import artofillusion.raster.ObjectMaterialInfo;

public class TransparentFragment
implements Fragment {
    private int additiveColor;
    private int multiplicativeColor;
    private float depth;
    private Fragment next;

    public TransparentFragment(int additiveColor, int multiplicativeColor, float depth, Fragment next) {
        this.additiveColor = additiveColor;
        this.multiplicativeColor = multiplicativeColor;
        this.depth = depth;
        this.next = next;
    }

    public void getAdditiveColor(RGBColor color) {
        color.setERGB(this.additiveColor);
    }

    public void getMultiplicativeColor(RGBColor color) {
        color.setERGB(this.multiplicativeColor);
    }

    public boolean isOpaque() {
        return false;
    }

    public float getDepth() {
        return this.depth;
    }

    public float getOpaqueDepth() {
        return this.next.getOpaqueDepth();
    }

    public ObjectMaterialInfo getMaterialMapping() {
        return null;
    }

    public boolean isEntering() {
        return false;
    }

    public Fragment getNextFragment() {
        return this.next;
    }

    public Fragment insertNextFragment(Fragment fragment) {
        fragment = fragment.getDepth() < this.next.getDepth() ? fragment.insertNextFragment(this.next) : this.next.insertNextFragment(fragment);
        this.next = fragment;
        return this;
    }
}

