/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class StringEncrypter {
    Cipher ecipher;
    Cipher dcipher;

    StringEncrypter(SecretKey key, String algorithm) {
        try {
            this.ecipher = Cipher.getInstance(algorithm);
            this.dcipher = Cipher.getInstance(algorithm);
            this.ecipher.init(1, key);
            this.dcipher.init(2, key);
        }
        catch (NoSuchPaddingException e) {
            System.out.println("EXCEPTION: NoSuchPaddingException");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("EXCEPTION: NoSuchAlgorithmException");
        }
        catch (InvalidKeyException e) {
            System.out.println("EXCEPTION: InvalidKeyException");
        }
    }

    StringEncrypter(String passPhrase) {
        byte[] salt = new byte[]{-87, -101, -56, 50, 86, 52, -29, 3};
        int iterationCount = 19;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.ecipher = Cipher.getInstance("PBEWithMD5AndDES");
            this.dcipher = Cipher.getInstance("PBEWithMD5AndDES");
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (InvalidAlgorithmParameterException e) {
            System.out.println("EXCEPTION: InvalidAlgorithmParameterException");
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            System.out.println("EXCEPTION: InvalidKeySpecException");
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            System.out.println("EXCEPTION: NoSuchPaddingException");
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("EXCEPTION: NoSuchAlgorithmException");
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            System.out.println("EXCEPTION: InvalidKeyException");
            e.printStackTrace();
        }
    }

    public String encrypt(String str) {
        try {
            byte[] utf8 = str.getBytes("UTF8");
            byte[] enc = this.ecipher.doFinal(utf8);
            return new BASE64Encoder().encode(enc);
        }
        catch (BadPaddingException e) {
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String decrypt(String str) {
        try {
            byte[] dec = new BASE64Decoder().decodeBuffer(str);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, "UTF8");
        }
        catch (BadPaddingException e) {
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void testUsingSecretKey() {
        try {
            System.out.println();
            System.out.println("+----------------------------------------+");
            System.out.println("|  -- Test Using Secret Key Method --    |");
            System.out.println("+----------------------------------------+");
            System.out.println();
            String secretString = "Attack at dawn!";
            SecretKey desKey = KeyGenerator.getInstance("DES").generateKey();
            SecretKey blowfishKey = KeyGenerator.getInstance("Blowfish").generateKey();
            SecretKey desedeKey = KeyGenerator.getInstance("DESede").generateKey();
            StringEncrypter desEncrypter = new StringEncrypter(desKey, desKey.getAlgorithm());
            StringEncrypter blowfishEncrypter = new StringEncrypter(blowfishKey, blowfishKey.getAlgorithm());
            StringEncrypter desedeEncrypter = new StringEncrypter(desedeKey, desedeKey.getAlgorithm());
            String desEncrypted = desEncrypter.encrypt(secretString);
            String blowfishEncrypted = blowfishEncrypter.encrypt(secretString);
            String desedeEncrypted = desedeEncrypter.encrypt(secretString);
            String desDecrypted = desEncrypter.decrypt(desEncrypted);
            String blowfishDecrypted = blowfishEncrypter.decrypt(blowfishEncrypted);
            String desedeDecrypted = desedeEncrypter.decrypt(desedeEncrypted);
            System.out.println(desKey.getAlgorithm() + " Encryption algorithm");
            System.out.println("    Original String  : " + secretString);
            System.out.println("    Encrypted String : " + desEncrypted);
            System.out.println("    Decrypted String : " + desDecrypted);
            System.out.println();
            System.out.println(blowfishKey.getAlgorithm() + " Encryption algorithm");
            System.out.println("    Original String  : " + secretString);
            System.out.println("    Encrypted String : " + blowfishEncrypted);
            System.out.println("    Decrypted String : " + blowfishDecrypted);
            System.out.println();
            System.out.println(desedeKey.getAlgorithm() + " Encryption algorithm");
            System.out.println("    Original String  : " + secretString);
            System.out.println("    Encrypted String : " + desedeEncrypted);
            System.out.println("    Decrypted String : " + desedeDecrypted);
            System.out.println();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public static void testUsingPassPhrase() {
        System.out.println();
        System.out.println("+----------------------------------------+");
        System.out.println("|  -- Test Using Pass Phrase Method --   |");
        System.out.println("+----------------------------------------+");
        System.out.println();
        String secretString = "Attack at dawn!";
        String passPhrase = "My Pass Phrase";
        StringEncrypter desEncrypter = new StringEncrypter(passPhrase);
        String desEncrypted = desEncrypter.encrypt(secretString);
        String desDecrypted = desEncrypter.decrypt(desEncrypted);
        System.out.println("PBEWithMD5AndDES Encryption algorithm");
        System.out.println("    Original String  : " + secretString);
        System.out.println("    Encrypted String : " + desEncrypted);
        System.out.println("    Decrypted String : " + desDecrypted);
        System.out.println();
    }
}

