/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.Plugin;
import artofillusion.PluginRegistry;
import artofillusion.spmanager.HttpSPMFileSystem;
import artofillusion.spmanager.InstallSplitPane;
import artofillusion.spmanager.SPMObjectInfo;
import artofillusion.spmanager.SPMTranslate;
import artofillusion.spmanager.SPManagerFrame;
import artofillusion.spmanager.StatusDialog;
import artofillusion.ui.Translate;
import artofillusion.util.SearchlistClassLoader;
import buoy.event.CommandEvent;
import buoy.widget.BButton;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BMenuItem;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextArea;
import buoy.widget.BTextField;
import buoy.widget.ColumnContainer;
import buoy.widget.MenuWidget;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SPManagerPlugin
implements Plugin {
    public static String AOI_VERSION;
    public static String TEMP_DIR;
    public static String APP_DIR;
    public static String PLUGIN_DIR;
    public static String TOOL_SCRIPT_DIR;
    public static String OBJECT_SCRIPT_DIR;
    public static String STARTUP_SCRIPT_DIR;
    public static final int DOWNLOAD = -1;
    private static SPManagerFrame spmFrame;
    protected static HashMap plugins;
    static /* synthetic */ Class class$buoy$event$ValueChangedEvent;

    public void processMessage(int message, Object[] args) {
        if (AOI_VERSION == null) {
            try {
                Field vers = ModellingApp.class.getField("MAJOR_VERSION");
                AOI_VERSION = vers.get(null).toString();
            }
            catch (Exception e) {
                System.out.println("SPManager: cannot get AOI version" + e);
            }
        }
        switch (message) {
            case 0: {
                Object obj;
                int i;
                SPMTranslate.setLocale(ModellingApp.getPreferences().getLocale());
                APP_DIR = ModellingApp.APP_DIRECTORY;
                PLUGIN_DIR = ModellingApp.PLUGIN_DIRECTORY;
                TOOL_SCRIPT_DIR = ModellingApp.TOOL_SCRIPT_DIRECTORY;
                OBJECT_SCRIPT_DIR = ModellingApp.OBJECT_SCRIPT_DIRECTORY;
                STARTUP_SCRIPT_DIR = ModellingApp.STARTUP_SCRIPT_DIRECTORY;
                System.out.println("SPManager starting...");
                ClassLoader ldr = null;
                URLClassLoader urlldr = null;
                SearchlistClassLoader searchldr = null;
                List list = PluginRegistry.getPluginClassLoaders();
                HashMap loaders = new HashMap(list.size());
                for (i = 0; i < list.size(); ++i) {
                    obj = list.get(i);
                    URL[] urlList = obj instanceof URLClassLoader ? ((URLClassLoader)obj).getURLs() : ((SearchlistClassLoader)obj).getURLs();
                    if (urlList.length <= 0) continue;
                    loaders.put(urlList[0], obj);
                }
                Object[] urlarg = new URL[1];
                Class[] sig = new Class[]{URL.class};
                Method addUrl = null;
                try {
                    addUrl = URLClassLoader.class.getDeclaredMethod("addURL", sig);
                    addUrl.setAccessible(true);
                }
                catch (Exception e) {
                    System.out.println("Error getting addURL method: " + e);
                }
                File plugdir = new File(PLUGIN_DIR);
                if (plugdir.exists()) {
                    File[] files = plugdir.listFiles();
                    for (i = 0; i < files.length; ++i) {
                        URL url;
                        SPMObjectInfo info = new SPMObjectInfo(files[i].getAbsolutePath());
                        if (info.actions == null || info.actions.size() <= 0) continue;
                        try {
                            url = files[i].toURI().toURL();
                        }
                        catch (Exception e) {
                            continue;
                        }
                        obj = loaders.get(url);
                        if (obj == null) {
                            System.out.println("SPManager: could not find classloader: " + files[i].getPath());
                            continue;
                        }
                        if (obj instanceof SearchlistClassLoader) {
                            searchldr = (SearchlistClassLoader)obj;
                        } else {
                            urlldr = (URLClassLoader)obj;
                        }
                        Iterator iter = info.actions.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry entry = iter.next();
                            String key = entry.getKey().toString();
                            try {
                                File urlfile = new File(plugdir, key);
                                url = urlfile.toURI().toURL();
                            }
                            catch (Exception e) {
                                System.out.println("Error making url: " + e);
                                continue;
                            }
                            String value = entry.getValue().toString();
                            if ("classpath".equalsIgnoreCase(value)) {
                                if (searchldr != null) {
                                    searchldr.add(url);
                                    continue;
                                }
                                if (addUrl != null) {
                                    try {
                                        urlarg[0] = url;
                                        addUrl.invoke((Object)urlldr, urlarg);
                                    }
                                    catch (Exception e) {
                                        System.out.println("Error invoking: " + e);
                                    }
                                    continue;
                                }
                                System.out.println("Could not add path" + url);
                                continue;
                            }
                            if (!"import".equalsIgnoreCase(value)) continue;
                            ldr = (ClassLoader)loaders.get(url);
                            if (obj != null) {
                                searchldr.add(ldr);
                                continue;
                            }
                            System.out.println("SPM: could not find loader for: " + url);
                        }
                    }
                } else {
                    System.out.println("SPManager: could not find plugin dir: " + PLUGIN_DIR);
                }
                this.init();
                break;
            }
            case 2: {
                LayoutWindow layout = (LayoutWindow)args[0];
                BMenuBar menuBar = layout.getMenuBar();
                BMenu toolsMenu = menuBar.getChild(3);
                toolsMenu.addSeparator();
                BMenuItem menuItem = SPMTranslate.bMenuItem("SPManager", this, "doMenu");
                toolsMenu.add((MenuWidget)menuItem);
                break;
            }
            case -1: {
                System.out.println("DOWNLOAD...");
                BFrame frame = (BFrame)args[0];
                URL from = (URL)args[1];
                URL to = (URL)(args.length > 2 ? args[2] : null);
                this.download(frame, from, to);
                break;
            }
        }
    }

    public void init() {
        File subfolder;
        ArrayList<String> err = new ArrayList<String>(8);
        System.out.println("SPManager: java temp dir is " + System.getProperty("java.io.tmpdir"));
        File temp = new File(System.getProperty("java.io.tmpdir"), "SPManager");
        if (!(temp.exists() && temp.isDirectory() || temp.mkdir())) {
            System.out.println("SPManager: could not open/create temp dir: " + temp.getAbsolutePath());
            temp = new File(APP_DIR, "temp");
        }
        if (!(temp.exists() && temp.isDirectory() || temp.mkdir())) {
            System.out.println("Cannot create temp folder: " + temp.getAbsolutePath());
            temp = new File(System.getProperty("user.dir"), "SPMtemp");
        }
        if (!(temp.exists() && temp.isDirectory() || temp.mkdir())) {
            err.add("Cannot create temp folder: " + temp.getAbsolutePath());
        }
        TEMP_DIR = temp.getAbsolutePath();
        System.out.println("SPManager: temp dir set to: " + temp.getAbsolutePath());
        if (!temp.canWrite()) {
            err.add("Write permission denied to temp folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(TEMP_DIR, (subfolder = new File(PLUGIN_DIR)).getName())).exists() && !temp.mkdirs()) {
            err.add("Cannot create temp plugin folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(TEMP_DIR, (subfolder = new File(TOOL_SCRIPT_DIR)).getName())).exists() && !temp.mkdirs()) {
            err.add("Cannot create temp script folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(TEMP_DIR, (subfolder = new File(OBJECT_SCRIPT_DIR)).getName())).exists() && !temp.mkdirs()) {
            err.add("Cannot create temp script folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(TEMP_DIR, (subfolder = new File(STARTUP_SCRIPT_DIR)).getName())).exists() && !temp.mkdirs()) {
            err.add("Cannot create temp script folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(PLUGIN_DIR)).exists() && !temp.mkdir()) {
            err.add("Cannot create missing plugin folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(TOOL_SCRIPT_DIR)).exists() && !temp.mkdirs()) {
            err.add("Cannot create missing script folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(OBJECT_SCRIPT_DIR)).exists() && !temp.mkdirs()) {
            err.add("Cannot create missing script folder: " + temp.getAbsolutePath());
        }
        if (!(temp = new File(STARTUP_SCRIPT_DIR)).exists() && !temp.mkdirs()) {
            err.add("Cannot create missing script folder: " + temp.getAbsolutePath());
        }
        if (err.size() > 0) {
            BTextArea txt = new BTextArea(5, 45);
            txt.setEditable(false);
            for (int i = 0; i < err.size(); ++i) {
                txt.append(err.get(i) + "\n");
            }
            BScrollPane detail = new BScrollPane((Widget)txt, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
            BLabel messg = SPMTranslate.bLabel("errMsg");
            new BStandardDialog("SPManager initialise", (Object)new Widget[]{messg, detail}, BStandardDialog.WARNING).showMessageDialog(null);
        }
    }

    public void download(BFrame frame, URL from) {
        this.download(frame, from, null);
    }

    public void download(BFrame frame, URL from, URL to) {
        final BFrame context = frame;
        final URL url = from;
        URL toUrl = to;
        StatusDialog status = new StatusDialog(context){
            SPMObjectInfo info;
            BLabel size;
            BButton okbtn;
            String filename;
            String name;
            ColumnContainer col;
            RowContainer buttons;
            BTextField savePath;
            Thread worker;

            public void setVisible(boolean vis) {
                if (!vis) {
                    super.setVisible(vis);
                    return;
                }
                this.col = (ColumnContainer)this.getContent();
                this.filename = url.getFile();
                int cut = this.filename.lastIndexOf(47);
                if (cut > 0 && cut < this.filename.length()) {
                    this.filename = this.filename.substring(cut + 1);
                }
                if ((cut = this.filename.lastIndexOf(63)) > 0) {
                    this.filename = this.filename.substring(0, cut);
                }
                this.name = new String(this.filename);
                cut = this.name.lastIndexOf(46);
                if (cut > 0) {
                    this.name = this.name.substring(0, cut);
                }
                this.setText(this.name);
                this.setProgressText(SPMTranslate.text("clickStart"));
                this.okbtn = SPMTranslate.bButton("start", (Object)this, "ok");
                this.buttons = new RowContainer();
                this.buttons.add((Widget)this.okbtn);
                this.buttons.add((Widget)SPMTranslate.bButton("cancel", (Object)this, "close"));
                this.okbtn.setActionCommand("ok");
                this.col.add((Widget)this.buttons);
                this.pack();
                super.setVisible(true);
            }

            public void close() {
                if (this.worker != null) {
                    this.worker.interrupt();
                }
                this.doClose();
            }

            public void ok(CommandEvent ev) {
                String cmd = ev.getActionCommand();
                this.okbtn.setEnabled(false);
                final BButton okbut = this.okbtn;
                final 1 stat = this;
                if (cmd.equals("ok")) {
                    this.setProgressText(SPMTranslate.text("contacting"));
                    this.setIdle(true);
                    System.out.println("DOWNLOAD: creating ObjectInfo..." + url.toString());
                    this.worker = new Thread(){

                        public void run() {
                            long total;
                            info = new SPMObjectInfo(url);
                            if (info.length == 0L) {
                                System.out.println("DOWNLOAD: no info");
                                info.length = info.getRemoteFileSize(url.toString());
                            }
                            if (info.name == null || info.name.length() == 0) {
                                System.out.println("need path...");
                                RowContainer row = new RowContainer();
                                row.add((Widget)SPMTranslate.bLabel("savePath"));
                                savePath = new BTextField("", 25);
                                savePath.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = SPManagerPlugin.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "savePath");
                                row.add((Widget)savePath);
                                row.add((Widget)SPMTranslate.bButton("browse", this, "browse"));
                                col.remove((Widget)buttons);
                                col.add((Widget)row);
                                col.add((Widget)buttons);
                                this.pack();
                            }
                            String sz = (total = info.getTotalLength()) > 1000000L ? " " + total / 1000000L + " MB" : (total > 1000L ? " " + total / 1000L + " kB" : (total > 0L ? " " + total + " bytes" : ""));
                            this.setText(info.getName() + " " + sz);
                            this.setIdle(false);
                            this.setProgressText(SPMTranslate.text("ready"));
                            okbut.setActionCommand("install");
                            okbut.setText(SPMTranslate.text("install"));
                            okbut.setEnabled(true);
                            this.pack();
                        }

                        public void savePath() {
                            String val = savePath.getText();
                            okbtn.setEnabled(val != null && val.length() > 0);
                        }

                        public void browse() {
                            BFileChooser fc = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text((String)"savePath"));
                            File file = null;
                            String path = null;
                            String fname = savePath.getText();
                            if (fname == null || fname.length() == 0) {
                                path = System.getProperty("user.home");
                                fname = filename;
                            }
                            if (fname != null) {
                                file = path != null ? new File(path, fname) : new File(fname);
                                fc.setDirectory(file.getParentFile());
                                fc.setSelectedFile(file);
                            } else {
                                fc.setDirectory(new File(path));
                            }
                            if (fc.showDialog((Widget)context)) {
                                savePath.setText(fc.getSelectedFile().getAbsolutePath());
                            }
                        }
                    };
                    this.worker.start();
                } else if (cmd.equals("install")) {
                    System.out.println("DOWNLOAD: downloading " + url.toString());
                    this.setText(SPMTranslate.text("downloading", this.info.getName()));
                    this.pack();
                    final ArrayList errs = new ArrayList();
                    this.worker = new Thread(){

                        public void run() {
                            long total = info.getTotalLength();
                            String path = null;
                            if (savePath != null) {
                                path = savePath.getText();
                            } else if (info.name != null) {
                                path = ModellingApp.PLUGIN_DIRECTORY + File.separatorChar + info.name + ".jar";
                            }
                            if (path == null || path.length() == 0) {
                                System.out.println("DOWNLOAD: no save location");
                                new BStandardDialog("SPManager", (Object)SPMTranslate.text("noSaveLocation"), BStandardDialog.ERROR).showMessageDialog(null);
                                this.doClose();
                            }
                            System.out.println("DOWNLOAD: downloading file...");
                            if (total > 0L) {
                                this.setBarValue(total > 0L ? 0 : -1);
                            }
                            long dl = HttpSPMFileSystem.downloadRemoteBinaryFile(url, path, info.length, stat, total, 0L, errs);
                            for (int i = 0; info.files != null && i < info.files.length; ++i) {
                                1 v0 = this;
                                if (v0.worker.interrupted()) {
                                    this.doClose();
                                    return;
                                }
                                name = ModellingApp.PLUGIN_DIRECTORY + File.separatorChar + info.destination.get(i) + info.files[i];
                                this.setText(SPMTranslate.text("downloading", info.files[i]));
                                this.pack();
                                dl += HttpSPMFileSystem.downloadRemoteBinaryFile(info.getAddFileURL(i), name, info.fileSizes[i], stat, total, dl, errs);
                            }
                            if (errs != null && errs.size() > 0) {
                                InstallSplitPane.showErrors(errs);
                            } else {
                                new BStandardDialog("SPManager", (Object)SPMTranslate.text("modified"), BStandardDialog.ERROR).showMessageDialog(null);
                            }
                            System.out.println("DOWNLOAD: done");
                            this.doClose();
                        }
                    };
                    this.worker.start();
                } else {
                    System.out.println("?? cmd=" + cmd);
                }
            }
        };
    }

    public void doMenu() {
        if (spmFrame == null) {
            spmFrame = new SPManagerFrame();
        }
        ((Window)spmFrame.getComponent()).toFront();
        ((Window)spmFrame.getComponent()).show();
    }

    public static void restart() {
        SPManagerFrame old = spmFrame;
        spmFrame = new SPManagerFrame();
        ((Window)spmFrame.getComponent()).toFront();
        ((Window)spmFrame.getComponent()).show();
        old.dispose();
    }

    public void close() {
        if (spmFrame != null) {
            spmFrame.setVisible(false);
            spmFrame.dispose();
        }
    }

    public String getName() {
        return "Script and Plugin Manager";
    }

    public static SPManagerFrame getFrame() {
        return spmFrame;
    }

    public static void updatePlugin(String name, String action, String target) {
    }

    public static void main(String[] argv) {
        char slash = File.separatorChar;
        APP_DIR = System.getProperty("user.dir");
        try {
            int cut;
            URL url = SPManagerPlugin.class.getResource("/artofillusion/spmanager/SPManagerPlugin.class");
            System.out.println("SPManager.main: url=" + url);
            System.out.println("SPManager.main: path=" + url.getPath());
            String furl = url.getPath();
            if (furl.indexOf(33) < 0) {
                furl = url.toString();
            }
            if ((cut = furl.indexOf(33)) > 0) {
                if ((cut = (furl = furl.substring(0, cut)).indexOf("jar:")) >= 0) {
                    furl = furl.substring(cut + "jar:".length());
                }
                if (!furl.startsWith("file:")) {
                    furl = "file:" + furl;
                }
                System.out.println("SPManager.main: furl=" + furl);
                File dir = new File(new URL(furl).getPath()).getParentFile().getParentFile();
                System.out.println("SPManager.main: dir=" + dir.getAbsolutePath());
                APP_DIR = dir.exists() ? dir.getAbsolutePath() : System.getProperty("user.dir");
                System.out.println("SPManager.main: app_dir=" + APP_DIR);
            }
        }
        catch (Exception ex) {
            System.out.println("Error looking up app_dir: " + ex);
        }
        SPMTranslate.setLocale(Locale.getDefault());
        PLUGIN_DIR = APP_DIR + slash + "Plugins";
        TOOL_SCRIPT_DIR = APP_DIR + slash + "Scripts" + slash + "Tools";
        OBJECT_SCRIPT_DIR = APP_DIR + slash + "Scripts" + slash + "Objects";
        STARTUP_SCRIPT_DIR = APP_DIR + slash + "Scripts" + slash + "Startup";
        SPManagerPlugin spm = new SPManagerPlugin();
        spm.init();
        spmFrame = new SPManagerFrame(){

            protected void hideSPManager() {
                this.setVisible(false);
                this.dispose();
            }
        };
        spm.doMenu();
    }
}

