/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.spmanager.SPMParameters;
import artofillusion.spmanager.SPMTranslate;
import artofillusion.spmanager.SPManagerFrame;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BPasswordField;
import buoy.widget.BScrollPane;
import buoy.widget.BTextField;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class SPMSetupFrame
extends BDialog {
    private SPManagerFrame frame;
    private BComboBox repositoriesCB;
    private ColumnContainer filterContainer;
    private BButton okButton;
    private BButton cancelButton;
    private BButton addButton;
    private BButton removeButton;
    private BTextField repEntry;
    private BTextField proxyHostEntry;
    private BTextField proxyPortEntry;
    private BTextField usernameEntry;
    private BPasswordField passwordEntry;
    private BLabel proxyHostLabel;
    private BLabel proxyPortLabel;
    private BLabel usernameLabel;
    private BLabel passwordLabel;
    private BCheckBox useProxyCB;
    private BCheckBox useCacheCB;
    private SPMParameters parameters;
    private String[] rep;

    public SPMSetupFrame(SPManagerFrame fr) {
        super((WindowWidget)fr, true);
        this.frame = fr;
        this.setTitle(SPMTranslate.text("SPManagerSetup"));
        SPMSetupFrame sPMSetupFrame = this;
        this.parameters = sPMSetupFrame.frame.getParameters();
        this.addEventLink(WindowClosingEvent.class, (Object)this, "doCancel");
        ColumnContainer cc = new ColumnContainer();
        LayoutInfo topLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(5, 3, 3, 3), new Dimension(0, 0));
        cc.add((Widget)SPMTranslate.bLabel("chooseRepository"), topLayout);
        LayoutInfo layout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(3, 3, 5, 3), new Dimension(0, 0));
        this.rep = this.parameters.getRepositories();
        this.repositoriesCB = new BComboBox((Object[])this.rep);
        cc.add((Widget)this.repositoriesCB, layout);
        this.repositoriesCB.addEventLink(ValueChangedEvent.class, (Object)this, "doRepositoriesCBChanged");
        this.repositoriesCB.setSelectedIndex(this.parameters.getCurrentRepositoryIndex());
        this.filterContainer = new ColumnContainer();
        HashMap filters = this.parameters.getFilters();
        if (filters.size() > 0) {
            Iterator iter = filters.entrySet().iterator();
            RowContainer line = null;
            BComboBox sel = null;
            LayoutInfo right = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE);
            LayoutInfo left = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE);
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String filtName = (String)entry.getKey();
                String filtVal = (String)entry.getValue();
                System.out.println("filter: " + filtName + "=" + filtVal);
                line = new RowContainer();
                line.add((Widget)new BLabel(filtName));
                sel = new BComboBox();
                line.add((Widget)sel);
                for (int i = 0; i < 5; ++i) {
                    String filtType = SPMParameters.FILTER_NAMES[i];
                    sel.add((Object)filtType);
                    if (!filtVal.equals(filtType)) continue;
                    sel.setSelectedValue((Object)filtType);
                }
                this.filterContainer.add((Widget)line, right);
            }
            BScrollPane sp = new BScrollPane((Widget)this.filterContainer);
            sp.setVerticalScrollbarPolicy(BScrollPane.SCROLLBAR_AS_NEEDED);
            Dimension dim = new Dimension();
            dim.setSize(this.filterContainer.getPreferredSize().getWidth(), line.getPreferredSize().getHeight() * (double)Math.min(filters.size(), 5));
            sp.setPreferredViewSize(dim);
            BOutline bo = new BOutline((Widget)sp, (Border)BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(1), SPMTranslate.text("filters")));
            cc.add((Widget)bo, layout);
        }
        this.useCacheCB = SPMTranslate.bCheckBox("useCache", this.parameters.getUseCache(), (Object)this, "doUseCacheCB");
        cc.add((Widget)this.useCacheCB, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 3, 2, 3), new Dimension(0, 0)));
        LayoutInfo buttonLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.BOTH, new Insets(2, 0, 2, 0), new Dimension(0, 0));
        LayoutInfo rcLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(4, 3, 4, 3), new Dimension(0, 0));
        FormContainer fm = new FormContainer(2, 5);
        LayoutInfo formLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(2, 4, 2, 4), new Dimension(0, 0));
        this.useProxyCB = SPMTranslate.bCheckBox("useProxy", this.parameters.useProxy(), (Object)this, "doUseProxyCB");
        fm.add((Widget)this.useProxyCB, 0, 0, formLayout);
        this.proxyHostLabel = SPMTranslate.bLabel("proxyHost");
        fm.add((Widget)this.proxyHostLabel, 0, 1, formLayout);
        this.proxyHostEntry = new BTextField(this.parameters.getProxyHost(), 25);
        fm.add((Widget)this.proxyHostEntry, 1, 1, formLayout);
        this.proxyPortLabel = SPMTranslate.bLabel("proxyPort");
        fm.add((Widget)this.proxyPortLabel, 0, 2, formLayout);
        this.proxyPortEntry = new BTextField(this.parameters.getProxyPort(), 25);
        fm.add((Widget)this.proxyPortEntry, 1, 2, formLayout);
        this.usernameLabel = SPMTranslate.bLabel("username");
        fm.add((Widget)this.usernameLabel, 0, 3, formLayout);
        this.usernameEntry = new BTextField(this.parameters.getUsername(), 15);
        fm.add((Widget)this.usernameEntry, 1, 3, formLayout);
        this.passwordLabel = SPMTranslate.bLabel("password");
        fm.add((Widget)this.passwordLabel, 0, 4, formLayout);
        this.passwordEntry = new BPasswordField(this.parameters.getPassword(), 15);
        fm.add((Widget)this.passwordEntry, 1, 4, formLayout);
        formLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 0, 0, 0), new Dimension(0, 0));
        cc.add((Widget)fm, rcLayout);
        if (!this.useProxyCB.getState()) {
            this.proxyHostEntry.setEnabled(false);
            this.proxyPortEntry.setEnabled(false);
            this.usernameEntry.setEnabled(false);
            this.passwordEntry.setEnabled(false);
            this.proxyHostLabel.setEnabled(false);
            this.proxyPortLabel.setEnabled(false);
            this.usernameLabel.setEnabled(false);
            this.passwordLabel.setEnabled(false);
        }
        RowContainer buttons = new RowContainer();
        this.okButton = SPMTranslate.bButton("ok", (Object)this, "doOK");
        buttons.add((Widget)this.okButton);
        this.cancelButton = SPMTranslate.bButton("cancel", (Object)this, "doCancel");
        buttons.add((Widget)this.cancelButton);
        cc.add((Widget)buttons, new LayoutInfo());
        this.setContent((Widget)cc);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "doCancel");
        this.pack();
        ((JDialog)this.getComponent()).setLocationRelativeTo(this.frame.getComponent());
        this.parameters.setChanged(false);
        this.setVisible(true);
    }

    private void doUseProxyCB() {
        if (!this.useProxyCB.getState()) {
            this.proxyHostEntry.setEnabled(false);
            this.proxyPortEntry.setEnabled(false);
            this.usernameEntry.setEnabled(false);
            this.passwordEntry.setEnabled(false);
            this.proxyHostLabel.setEnabled(false);
            this.proxyPortLabel.setEnabled(false);
            this.usernameLabel.setEnabled(false);
            this.passwordLabel.setEnabled(false);
        } else {
            this.proxyHostEntry.setEnabled(true);
            this.proxyPortEntry.setEnabled(true);
            this.usernameEntry.setEnabled(true);
            this.passwordEntry.setEnabled(true);
            this.proxyHostLabel.setEnabled(true);
            this.proxyPortLabel.setEnabled(true);
            this.usernameLabel.setEnabled(true);
            this.passwordLabel.setEnabled(true);
        }
    }

    private void doAdd() {
        int i;
        String[] newRep = new String[this.rep.length + 1];
        for (i = 0; i < this.rep.length; ++i) {
            newRep[i] = this.rep[i];
        }
        newRep[i] = this.repEntry.getText();
        this.rep = newRep;
        this.repositoriesCB.setContents((Object[])newRep);
        this.repositoriesCB.setSelectedIndex(i);
        if (this.rep.length > 1) {
            this.removeButton.setEnabled(true);
        }
    }

    private void doRemove() {
        String[] newRep = new String[this.rep.length - 1];
        int j = 0;
        int removed = 0;
        String s = this.repEntry.getText();
        for (int i = 0; i < this.rep.length && j < newRep.length; ++i) {
            if (!s.equals(this.rep[i])) {
                newRep[j] = this.rep[i];
                ++j;
                continue;
            }
            removed = i;
        }
        this.rep = newRep;
        if (removed >= this.rep.length) {
            --removed;
        }
        this.repositoriesCB.setContents((Object[])this.rep);
        this.repositoriesCB.setSelectedIndex(removed);
        if (this.rep.length <= 1) {
            this.removeButton.setEnabled(false);
        }
    }

    private void doOK() {
        this.parameters.setURLs(this.rep, this.repositoriesCB.getSelectedIndex());
        this.parameters.setProxyParameters(this.useProxyCB.getState(), this.proxyHostEntry.getText(), this.proxyPortEntry.getText(), this.usernameEntry.getText(), this.passwordEntry.getText());
        HashMap filters = this.parameters.getFilters();
        filters.clear();
        for (int i = 0; i < this.filterContainer.getChildCount(); ++i) {
            RowContainer line = (RowContainer)this.filterContainer.getChild(i);
            String filtName = ((BLabel)line.getChild(0)).getText();
            BComboBox sel = (BComboBox)line.getChild(1);
            String filtVal = sel.getSelectedIndex() >= 0 ? sel.getSelectedValue().toString() : SPMParameters.FILTER_NAMES[0];
            filters.put(filtName, filtVal);
        }
        this.parameters.setChanged(true);
        this.dispose();
    }

    private void doCancel() {
        this.dispose();
    }

    private void doUseCacheCB() {
        this.parameters.setUseCache(this.useCacheCB.getState());
    }

    private void doRepositoriesCBChanged() {
        this.parameters.setCurrentRepository(this.repositoriesCB.getSelectedIndex());
    }

    private void doRepEntryChanged() {
        try {
            String text = this.repEntry.getText();
            new URL(text);
            ((JTextField)this.repEntry.getComponent()).setForeground(Color.black);
            String[] s = this.parameters.getRepositories();
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(false);
            for (int i = 0; i < s.length; ++i) {
                if (!s[i].equals(text)) continue;
                this.addButton.setEnabled(false);
                this.removeButton.setEnabled(true);
            }
        }
        catch (MalformedURLException e) {
            ((JTextField)this.repEntry.getComponent()).setForeground(Color.red);
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }
}

