/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.spmanager.SPMParameters;
import artofillusion.spmanager.SPMTranslate;
import artofillusion.spmanager.SPManagerFrame;
import artofillusion.spmanager.SPManagerUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SPMObjectInfo {
    public String author = "?";
    public String name = "";
    public String date = "00/00/0000";
    public String version = "0.0";
    public long length;
    public int beta = -1;
    public int restriction = 1;
    public int refcount = 0;
    public String flags;
    private String description = null;
    private String comments = null;
    private HashMap externals;
    private Vector changeLog;
    private Vector details;
    protected HashMap exports;
    public HashMap actions;
    public String fileName = "**Uninitialised**";
    static String textBoxString = "";
    public URL httpFile;
    public String[] files;
    public String[] httpFiles;
    public ArrayList destination;
    public long[] fileSizes;
    public Document xmlDescription;
    public boolean loaded = false;
    char separatorChar;
    boolean selected = false;
    boolean deletable = true;
    private boolean remote;
    private boolean filesetRecord;

    public SPMObjectInfo() {
    }

    public SPMObjectInfo(String fn) {
        this.fileName = fn;
        this.separatorChar = File.separatorChar;
        this.getName();
        this.remote = false;
        if (fn.endsWith(".bsh")) {
            this.loadXmlInfoFromScript();
        } else if (fn.endsWith(".jar")) {
            this.loadXmlInfoFromJarFile();
        }
        File f = new File(fn);
        this.length = f.length();
    }

    public SPMObjectInfo(URL hf) {
        this.httpFile = hf;
        this.remote = true;
        this.fileName = this.httpFile.toString();
        this.fileName = this.fileName.replaceAll("%20", " ");
        this.separatorChar = (char)47;
        this.getName();
        String s = hf.toString();
        if (s.endsWith(".bsh")) {
            this.loadXmlInfoFromRemoteScript();
        } else if (s.endsWith(".jar")) {
            this.loadXmlInfoFromRemoteJarFile();
        }
    }

    public SPMObjectInfo(Node n, URL hf, long length) {
        this.httpFile = hf;
        this.remote = true;
        this.fileName = this.httpFile.toString();
        this.fileName = this.fileName.replaceAll("%20", " ");
        this.separatorChar = (char)47;
        this.getName();
        this.readInfoFromDocumentNode(n);
        this.length = length;
    }

    public String getName() {
        if (this.name.equals("")) {
            int cut = this.fileName.lastIndexOf(this.separatorChar);
            this.name = cut >= 0 && cut < this.fileName.length() - 1 ? this.fileName.substring(cut + 1) : this.fileName;
            cut = this.name.lastIndexOf(46);
            if (cut >= 0) {
                this.name = this.name.substring(0, cut);
            }
        }
        return this.name;
    }

    public String getFullName() {
        long kbsize;
        String betaString = "";
        if (this.beta > -1) {
            betaString = "b" + this.beta;
        }
        String addFiles = "";
        if (this.files != null) {
            addFiles = " (" + SPMTranslate.text("additionalFiles") + " ";
            for (int i = 0; i < this.files.length; ++i) {
                kbsize = Math.round(this.fileSizes[i] / 1000L);
                if (kbsize < 1L) {
                    kbsize = 1L;
                }
                addFiles = addFiles + this.files[i] + " " + kbsize + "kb";
                addFiles = i != this.files.length - 1 ? addFiles + "," : addFiles + ")";
            }
        }
        if ((kbsize = (long)Math.round(this.length / 1000L)) < 1L) {
            kbsize = 1L;
        }
        return SPMTranslate.text("fullname", new Object[]{this.getName(), this.author, this.version + betaString, this.date, String.valueOf(kbsize)}) + addFiles;
    }

    public String toString() {
        return this.getName();
    }

    private String getXmlHeaderAsString(BufferedReader reader) {
        char c1 = ' ';
        char c2 = ' ';
        StringBuffer sb = new StringBuffer(1024);
        int status = 0;
        try {
            c1 = (char)reader.read();
            c2 = (char)reader.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while ((c1 != '/' || c2 != '*') && status != -1) {
            c1 = c2;
            try {
                status = reader.read();
                c2 = (char)status;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        while (c1 != '<') {
            try {
                status = reader.read();
                if (status == -1) {
                    return null;
                }
                c1 = (char)status;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        sb.append(c1);
        while ((c1 != '*' || c2 != '/') && status != -1) {
            c1 = c2;
            try {
                status = reader.read();
                c2 = (char)status;
                sb.append(c2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (sb.length() > 2) {
            return sb.substring(0, sb.length() - 3);
        }
        return null;
    }

    private void loadXmlInfoFromScript() {
        BufferedReader fileReader = null;
        String s = null;
        try {
            fileReader = new BufferedReader(new FileReader(this.fileName));
            s = this.getXmlHeaderAsString(fileReader);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        try {
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (s == null) {
            return;
        }
        try {
            byte[] xmlByteArray = s.getBytes();
            BufferedInputStream xmlStream = new BufferedInputStream(new ByteArrayInputStream(xmlByteArray));
            this.xmlDescription = SPManagerUtils.builder.parse(xmlStream);
            this.readInfoFromXmlHeader(this.xmlDescription);
            xmlStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadXmlInfoFromJarFile() {
        block7: {
            String fn = "extensions.xml";
            try {
                InputStream is;
                URL url = new URL("jar:file:" + this.fileName + "!/" + fn);
                try {
                    is = url.openStream();
                }
                catch (Exception e) {
                    is = null;
                }
                if (is == null) {
                    fn = this.getName() + ".xml";
                    url = new URL("jar:file:" + this.fileName + "!/" + fn);
                    is = url.openStream();
                }
                try {
                    BufferedInputStream xmlStream = new BufferedInputStream(is);
                    this.xmlDescription = SPManagerUtils.builder.parse(xmlStream);
                    this.readInfoFromXmlHeader(this.xmlDescription);
                    xmlStream.close();
                }
                catch (Throwable t) {
                    System.out.println("Reading: " + url);
                    t.printStackTrace();
                }
            }
            catch (Exception e) {
                if (e instanceof IOException) break block7;
                e.printStackTrace();
            }
        }
    }

    private void loadXmlInfoFromRemoteScript() {
        BufferedReader in = null;
        String s = null;
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection connection = (HttpURLConnection)this.httpFile.openConnection();
            String header = connection.getHeaderField(0);
            int i = 1;
            while ((header = connection.getHeaderField(i)) != null) {
                String key = connection.getHeaderFieldKey(i);
                if (key != null && key.equals("Content-Length")) {
                    this.length = Long.parseLong(header);
                }
                ++i;
            }
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            s = this.getXmlHeaderAsString(in);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (s == null) {
            return;
        }
        try {
            byte[] xmlByteArray = s.getBytes();
            BufferedInputStream xmlStream = new BufferedInputStream(new ByteArrayInputStream(xmlByteArray));
            this.xmlDescription = SPManagerUtils.builder.parse(xmlStream);
            this.readInfoFromXmlHeader(this.xmlDescription);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadXmlInfoFromRemoteJarFile() {
        BufferedReader in = null;
        String s = null;
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection connection = (HttpURLConnection)this.httpFile.openConnection();
            String header = connection.getHeaderField(0);
            int i = 1;
            while ((header = connection.getHeaderField(i)) != null) {
                String key = connection.getHeaderFieldKey(i);
                if (key != null && key.equals("Content-Length")) {
                    this.length = Long.parseLong(header);
                }
                ++i;
            }
            InputStream is = null;
            s = this.httpFile.toString();
            s = s.substring(0, s.lastIndexOf(47) + 1) + "extensions.xml";
            try {
                is = new URL(s).openStream();
            }
            catch (Exception e) {
                in = null;
            }
            if (in == null) {
                s = this.httpFile.toString();
                s = s.substring(0, s.lastIndexOf(46)) + ".xml";
                is = new URL(s).openStream();
            }
            BufferedInputStream xmlStream = new BufferedInputStream(is);
            this.xmlDescription = SPManagerUtils.builder.parse(xmlStream);
            this.readInfoFromXmlHeader(this.xmlDescription);
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getTotalLength() {
        if (this.files == null) {
            return this.length;
        }
        long l = this.length;
        for (int i = 0; i < this.files.length; ++i) {
            l += this.fileSizes[i];
        }
        return l;
    }

    public String getAddFileName(int index) {
        int i = this.fileName.lastIndexOf(this.separatorChar);
        String name = this.fileName.substring(0, i + 1) + this.files[index];
        return name;
    }

    public URL getAddFileURL(int index) {
        int i = this.fileName.lastIndexOf(this.separatorChar);
        String name = this.fileName.substring(0, i + 1) + this.httpFiles[index];
        URL url = null;
        try {
            url = new URL(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    public long getRemoteFileSize(String url) {
        try {
            URL addFile = new URL(url);
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection connection = (HttpURLConnection)addFile.openConnection();
            String key = connection.getHeaderField(0);
            int i = 1;
            while ((key = connection.getHeaderFieldKey(i)) != null) {
                if (key.equals("Content-Length")) {
                    return Long.parseLong(connection.getHeaderField(i));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    private long getRemoteAddFileSize(String addFileName) {
        int i = this.fileName.lastIndexOf(this.separatorChar);
        long fileSize = 0L;
        String name = this.fileName.substring(0, i + 1);
        return this.getRemoteFileSize(name + addFileName);
    }

    private long getAddFileSize(String addFileName) {
        int i = this.fileName.lastIndexOf(this.separatorChar);
        long fileSize = 0L;
        String name = this.fileName.substring(0, i + 1) + addFileName;
        File file = new File(name);
        fileSize = file.length();
        if (fileSize < 1L) {
            fileSize = 1L;
        }
        return fileSize;
    }

    private void readInfoFromXmlHeader(Document doc) {
        this.readInfoFromDocumentNode(doc.getDocumentElement());
    }

    private void readInfoFromDocumentNode(Node script) {
        Node fileSet;
        String extName;
        Node node;
        SPMParameters params = SPManagerFrame.getParameters();
        if (this.changeLog == null) {
            this.changeLog = new Vector(16);
            this.details = new Vector(16);
            this.externals = new HashMap(16);
            this.destination = new ArrayList(16);
            this.actions = new HashMap(16);
            this.exports = new HashMap(32);
        } else {
            this.changeLog.clear();
            this.details.clear();
            this.externals.clear();
            this.destination.clear();
            this.actions.clear();
            this.exports.clear();
        }
        this.flags = "";
        this.name = SPManagerUtils.getAttribute(script, "name");
        this.version = SPManagerUtils.getAttribute(script, "version");
        if (this.name == null) {
            this.name = SPManagerUtils.getNodeValue(script, "name", "", 0);
        }
        if (this.version == null) {
            this.version = SPManagerUtils.getNodeValue(script, "version", "", 0);
        }
        this.author = SPManagerUtils.getNodeValue(script, "author", "", 0);
        this.date = SPManagerUtils.getNodeValue(script, "date", "", 0);
        String b = SPManagerUtils.getNodeValue(script, "beta", "", 0);
        if (!"".equals(b)) {
            try {
                this.beta = SPManagerUtils.parseInt(b, 0, -1);
            }
            catch (Exception e) {
                this.beta = -1;
            }
        } else {
            this.beta = -1;
        }
        if (this.beta > 0) {
            if (params != null) {
                this.restriction = params.getFilter("beta");
            }
            if (this.flags.length() > 0) {
                this.flags = this.flags + "; ";
            }
            this.flags = this.flags + "beta";
        }
        NodeList nl = script.getChildNodes();
        int i = 0;
        while ((node = SPManagerUtils.getNodeFromNodeList(nl, "import", i)) != null) {
            extName = SPManagerUtils.getAttribute(node, "name");
            if (!this.externals.containsKey(extName)) {
                this.externals.put(extName, extName + ":plugin= required");
            }
            ++i;
        }
        i = 0;
        while ((node = SPManagerUtils.getNodeFromNodeList(nl, "external", i)) != null) {
            extName = SPManagerUtils.getAttribute(node, "name");
            String extType = SPManagerUtils.getAttribute(node, "type");
            String extAssoc = SPManagerUtils.getAttribute(node, "association");
            this.externals.put(extName, extName + ":" + extType + "= " + extAssoc);
            String extAction = SPManagerUtils.getAttribute(node, "action");
            if (extAction != null && extAction.length() > 0) {
                this.actions.put(extName, extAction);
            }
            ++i;
        }
        String exportList = "";
        i = 0;
        while ((node = SPManagerUtils.getNodeFromNodeList(nl, "plugin", i)) != null) {
            Node subnode;
            String plugClass = SPManagerUtils.getAttribute(node, "class");
            NodeList sl = node.getChildNodes();
            int j = 0;
            while ((subnode = SPManagerUtils.getNodeFromNodeList(sl, "export", j)) != null) {
                String methName = SPManagerUtils.getAttribute(subnode, "method");
                if (methName != null && methName.length() != 0) {
                    String methId = SPManagerUtils.getAttribute(subnode, "id");
                    this.exports.put(methId, plugClass + "." + methName);
                    if (subnode.getChildNodes() != null && subnode.getChildNodes().item(0) != null) {
                        String methHelp = subnode.getChildNodes().item(0).getNodeValue();
                        if (exportList.length() > 0) {
                            exportList = exportList + "========================\n";
                        }
                        exportList = exportList + methId + "\n" + methHelp + "\n";
                    }
                }
                ++j;
            }
            ++i;
        }
        String val = SPManagerUtils.getNodeValue(script, "description", "none", 0);
        if (val != null) {
            this.setDescription(val);
        }
        if ((val = SPManagerUtils.getNodeValue(script, "comments", "", 0)) != null) {
            this.setComments(val);
        }
        String extList = "";
        Iterator iter = this.externals.entrySet().iterator();
        while (iter.hasNext()) {
            extList = extList + (extList.length() > 0 ? "\n" : "") + iter.next().getValue().toString();
        }
        this.setLog(SPMTranslate.text("flags"), this.flags, 1);
        this.setLog(SPMTranslate.text("otherFiles"), extList, 2);
        this.setLog(SPMTranslate.text("exports"), exportList, 3);
        this.setLog(SPMTranslate.text("history"), "none", 4);
        node = SPManagerUtils.getNodeFromNodeList(nl, "filter", 0);
        if (params != null && node != null) {
            NamedNodeMap nm = node.getAttributes();
            for (i = 0; i < nm.getLength(); ++i) {
                node = nm.item(i);
                String filtName = node.getNodeName();
                String filtVal = params.getFilterString(filtName);
                int filtType = SPMParameters.getFilterType(filtVal);
                if (filtType == 0) {
                    filtType = SPMParameters.getFilterType(node.getNodeValue());
                }
                if (filtType > this.restriction) {
                    this.restriction = filtType;
                }
                if (filtVal == null && filtType != 0) {
                    params.addFilter(filtName, 0);
                }
                if (this.flags.length() > 0) {
                    this.flags = this.flags + "; ";
                }
                this.flags = this.flags + filtName;
            }
        }
        if (this.flags.length() > 0) {
            this.setLog(SPMTranslate.text("flags"), this.flags, 1);
        }
        String history = "";
        node = SPManagerUtils.getNodeFromNodeList(nl, "history", 0);
        if (node != null) {
            NodeList hl = node.getChildNodes();
            i = 0;
            while ((node = SPManagerUtils.getNodeFromNodeList(hl, "log", i)) != null) {
                String name = "v ";
                String str = SPManagerUtils.getAttribute(node, "version");
                name = name + (str != null ? str : "??");
                str = SPManagerUtils.getAttribute(node, "date");
                if (str != null) {
                    name = name + " " + str;
                }
                if ((str = SPManagerUtils.getAttribute(node, "author")) != null) {
                    name = name + " ; " + str;
                }
                str = node.getChildNodes().item(0).getNodeValue();
                history = history + (history.length() > 0 ? "\n" : "") + name + str;
                ++i;
            }
            if (history.length() > 0) {
                this.setLog(SPMTranslate.text("history"), history, 4);
            }
        }
        if ((fileSet = SPManagerUtils.getNodeFromNodeList(nl, "fileset", 0)) != null) {
            NodeList filesList = fileSet.getChildNodes();
            Vector<String> fileNames = new Vector<String>();
            for (i = 0; i < filesList.getLength(); ++i) {
                if (!"file".equals(filesList.item(i).getNodeName())) continue;
                String todir = SPManagerUtils.getAttribute(filesList.item(i), "todir");
                NodeList tmp = filesList.item(i).getChildNodes();
                if (tmp.getLength() <= 0) continue;
                fileNames.add(tmp.item(0).getNodeValue());
                this.destination.add(todir != null ? todir + this.separatorChar : "");
                System.out.println("file: " + tmp.item(0).getNodeValue());
            }
            if (fileNames.size() > 0) {
                this.files = new String[fileNames.size()];
                for (i = 0; i < this.files.length; ++i) {
                    this.files[i] = (String)fileNames.elementAt(i);
                }
                this.httpFiles = new String[this.files.length];
                this.fileSizes = new long[this.files.length];
                for (i = 0; i < this.files.length; ++i) {
                    this.files[i] = this.files[i].trim();
                    this.httpFiles[i] = this.files[i].replaceAll(" ", "%20");
                    this.fileSizes[i] = this.remote ? this.getRemoteAddFileSize(this.httpFiles[i]) : this.getAddFileSize(this.files[i]);
                }
            }
        }
    }

    public void setSelected(boolean sel) {
        if (this.refcount <= 0 && this.restriction < 3) {
            this.selected = sel;
        }
    }

    public boolean isSelected() {
        return this.selected || this.refcount > 0;
    }

    public int getMajor() {
        int index = this.version.indexOf(46);
        if (index > 0) {
            return SPManagerUtils.parseInt(this.version, 0, index);
        }
        return 0;
    }

    public int getMinor() {
        int index = this.version.indexOf(46) + 1;
        if (index < this.version.length()) {
            if (this.version.length() - index < 2) {
                return SPManagerUtils.parseInt(this.version + "0", index, -1);
            }
            return SPManagerUtils.parseInt(this.version, index, -1);
        }
        return 0;
    }

    public boolean isBeta() {
        return this.beta != -1;
    }

    public int getBeta() {
        return this.beta;
    }

    public String getDescription() {
        return this.description;
    }

    public String getComments() {
        return this.comments;
    }

    public Collection getExternals() {
        return this.externals != null ? this.externals.values() : null;
    }

    public Vector getChangeLog() {
        return this.changeLog;
    }

    public Vector getDetails() {
        return this.details;
    }

    public void setDescription(String text) {
        this.description = text.replace('\n', ' ');
        this.description = this.description.replaceAll("   ", "\n\n");
        this.description = this.description.replaceAll("  ", "\n");
        this.description = this.description.trim();
        String desc = new String(this.description);
        if (this.comments != null && this.comments.length() > 0) {
            desc = desc + "\n\n" + this.comments;
        }
        this.setLog(SPMTranslate.text("description"), desc, 0);
    }

    public void setComments(String text) {
        this.comments = text.replace('\n', ' ');
        this.comments = this.comments.replaceAll("   ", "\n\n");
        this.comments = this.comments.replaceAll("  ", "\n");
        this.comments = this.comments.trim();
        String desc = new String(this.comments);
        if (this.description != null && this.description.length() > 0) {
            desc = this.description + "\n\n" + this.comments;
        }
        this.setLog(SPMTranslate.text("description"), desc, 0);
    }

    public void setLog(String name, String text, int index) {
        if (index >= this.changeLog.size()) {
            this.changeLog.add(name);
        } else {
            this.changeLog.set(index, name);
        }
        if (text.startsWith("\n")) {
            text = text.substring(1);
        }
        if (index >= this.details.size()) {
            this.details.add(text);
        } else {
            this.details.set(index, text);
        }
    }
}

