/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.spmanager;

import artofillusion.spmanager.SPMFileSystem;
import artofillusion.spmanager.SPMObjectInfo;
import artofillusion.spmanager.SPMTranslate;
import artofillusion.spmanager.SPManagerFrame;
import artofillusion.spmanager.SPManagerPlugin;
import artofillusion.spmanager.SPManagerUtils;
import artofillusion.spmanager.StatusDialog;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BProgressBar;
import buoy.widget.BStandardDialog;
import buoy.widget.ColumnContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpSPMFileSystem
extends SPMFileSystem {
    boolean unknownHost = false;
    private URL repository;
    private HttpStatusDialog statusDialog;
    private boolean isDownloading;
    private Vector callbacks;
    private Document pluginsDoc;
    private Document objectsDoc;
    private Document startupDoc;
    private Document toolsDoc;
    private File file;
    static /* synthetic */ Class class$buoy$event$WindowClosingEvent;

    public HttpSPMFileSystem(URL rep) {
        this.repository = rep;
        this.pluginsDoc = null;
        this.objectsDoc = null;
        this.startupDoc = null;
        this.toolsDoc = null;
    }

    public void setRepository(URL rep) {
        this.pluginsInfo = new Vector();
        this.toolInfo = new Vector();
        this.objectInfo = new Vector();
        this.startupInfo = new Vector();
        this.initialized = false;
        this.unknownHost = false;
        this.repository = rep;
        this.pluginsDoc = null;
        this.objectsDoc = null;
        this.startupDoc = null;
        this.toolsDoc = null;
        SPManagerPlugin.getFrame();
        SPManagerFrame.getParameters().initHttp();
    }

    public void getRemoteInfo(Runnable cb) {
        if (!this.initialized) {
            super.initialize();
            this.unknownHost = false;
            if (!this.isDownloading) {
                this.callbacks = new Vector();
                this.callbacks.add(cb);
                this.isDownloading = true;
                this.statusDialog = new HttpStatusDialog();
                new Thread(){

                    public void run() {
                        HttpSPMFileSystem.this.scanPlugins();
                        if (!HttpSPMFileSystem.this.unknownHost) {
                            HttpSPMFileSystem.this.scanToolScripts();
                        }
                        if (!HttpSPMFileSystem.this.unknownHost) {
                            HttpSPMFileSystem.this.scanObjectScripts();
                        }
                        if (!HttpSPMFileSystem.this.unknownHost) {
                            HttpSPMFileSystem.this.scanStartupScripts();
                        }
                        HttpSPMFileSystem.this.isDownloading = false;
                        HttpSPMFileSystem.this.initialized = true;
                        for (int i = 0; i < HttpSPMFileSystem.this.callbacks.size(); ++i) {
                            ((Runnable)HttpSPMFileSystem.this.callbacks.elementAt(i)).run();
                        }
                        HttpSPMFileSystem.this.statusDialog.dispose();
                        HttpSPMFileSystem.this.statusDialog = null;
                    }
                }.start();
            } else {
                this.callbacks.add(cb);
            }
        } else {
            cb.run();
        }
    }

    public void initialize() {
        super.initialize();
        this.statusDialog = null;
        this.scanPlugins();
        if (!this.unknownHost) {
            this.scanToolScripts();
        }
        if (!this.unknownHost) {
            this.scanObjectScripts();
        }
        if (!this.unknownHost) {
            this.scanStartupScripts();
        }
        this.initialized = true;
    }

    private void scanPlugins() {
        if (!SPManagerFrame.getParameters().getUseCache()) {
            SPManagerFrame.getInstance().setRemoteStatusText(SPMTranslate.text("scanningPluginsFrom", new String[]{this.repository.toString()}), 5000);
        } else {
            String s = this.repository.toString();
            s = s.substring(0, s.lastIndexOf(47));
            s = s + "/cgi-bin/scripts.cgi?Plugins%20" + SPManagerPlugin.AOI_VERSION;
            SPManagerFrame.getInstance().setRemoteStatusText(SPMTranslate.text("scanningPluginsFrom", new String[]{s}), 5000);
        }
        if (this.statusDialog != null) {
            this.statusDialog.setText(SPMTranslate.text("scanningPlugins"));
        }
        this.pluginsInfo = new Vector();
        if (SPManagerFrame.getParameters().getUseCache()) {
            this.scanFiles("Plugins", this.pluginsInfo);
        } else {
            try {
                URL pluginsURL = new URL(this.repository, "Plugins/");
                this.scanFiles(pluginsURL, this.pluginsInfo, ".jar");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private void scanToolScripts() {
        if (!SPManagerFrame.getParameters().getUseCache()) {
            SPManagerFrame.getInstance().setRemoteStatusText(SPMTranslate.text("scanningToolScriptsFrom", new String[]{this.repository.toString()}), 5000);
        } else {
            String s = this.repository.toString();
            s = s.substring(0, s.lastIndexOf(47));
            s = s + "/cgi-bin/scripts.cgi?Scripts/Tools%20" + SPManagerPlugin.AOI_VERSION;
            SPManagerFrame.getInstance().setRemoteStatusText(SPMTranslate.text("scanningToolScriptsFrom", new String[]{s}), 5000);
        }
        if (this.statusDialog != null) {
            this.statusDialog.setText(SPMTranslate.text("scanningToolScripts"));
        }
        this.toolInfo = new Vector();
        if (SPManagerFrame.getParameters().getUseCache()) {
            this.scanFiles("Scripts/Tools", this.toolInfo);
        } else {
            try {
                URL toolScriptURL = new URL(this.repository, "Scripts/Tools/");
                this.scanFiles(toolScriptURL, this.toolInfo, ".bsh");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private void scanObjectScripts() {
        if (!SPManagerFrame.getParameters().getUseCache()) {
            SPManagerFrame.getInstance().setRemoteStatusText(SPMTranslate.text("scanningObjectScriptsFrom", new String[]{this.repository.toString()}), 5000);
        } else {
            String s = this.repository.toString();
            s = s.substring(0, s.lastIndexOf(47));
            s = s + "/cgi-bin/scripts.cgi?Scripts/Objects%20" + SPManagerPlugin.AOI_VERSION;
            SPManagerFrame.getInstance().setRemoteStatusText(SPMTranslate.text("scanningObjectScriptsFrom", new String[]{s}), 5000);
        }
        if (this.statusDialog != null) {
            this.statusDialog.setText(SPMTranslate.text("scanningObjectScripts"));
        }
        this.objectInfo = new Vector();
        if (SPManagerFrame.getParameters().getUseCache()) {
            this.scanFiles("Scripts/Objects", this.objectInfo);
        } else {
            try {
                URL objectScriptURL = new URL(this.repository, "Scripts/Objects/");
                this.scanFiles(objectScriptURL, this.objectInfo, ".bsh");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private void scanStartupScripts() {
        if (!SPManagerFrame.getParameters().getUseCache()) {
            SPManagerFrame.getInstance().setRemoteStatusText(SPMTranslate.text("scanningStartupScriptsFrom", new String[]{this.repository.toString()}), 5000);
        } else {
            String s = this.repository.toString();
            s = s.substring(0, s.lastIndexOf(47));
            s = s + "/cgi-bin/scripts.cgi?Scripts/Startup%20" + SPManagerPlugin.AOI_VERSION;
            SPManagerFrame.getInstance().setRemoteStatusText(SPMTranslate.text("scanningStartupScriptsFrom", new String[]{s}), 5000);
        }
        if (this.statusDialog != null) {
            this.statusDialog.setText(SPMTranslate.text("scanningStartupScripts"));
        }
        this.startupInfo = new Vector();
        if (SPManagerFrame.getParameters().getUseCache()) {
            this.scanFiles("Scripts/Startup", this.startupInfo);
        } else {
            try {
                URL startupScriptURL = new URL(this.repository, "Scripts/Startup/");
                this.scanFiles(startupScriptURL, this.startupInfo, ".bsh");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private void scanFiles(URL from, Vector addTo, String suffix) {
        Vector v = null;
        try {
            Object obj = from.getContent();
            if (obj instanceof InputStream) {
                v = this.htmlFindFilesVersioning((InputStream)obj, from);
            }
            ((InputStream)obj).close();
        }
        catch (IOException e) {
            if (e instanceof UnknownHostException) {
                JOptionPane.showMessageDialog(null, from.toString() + ": " + SPMTranslate.text("unknownHost"), SPMTranslate.text("error"), 0);
                this.unknownHost = true;
            }
            if (e instanceof FileNotFoundException) {
                JOptionPane.showMessageDialog(null, from.toString() + ": " + SPMTranslate.text("fileNotFound"), SPMTranslate.text("error"), 0);
                this.unknownHost = true;
            }
            e.printStackTrace();
        }
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                String s = (String)v.elementAt(i);
                System.out.println(s);
                if (!s.endsWith(suffix)) continue;
                boolean eligible = true;
                String name = s.substring(0, s.length() - 4);
                if (suffix.equals(".jar")) {
                    eligible = true;
                    String sxml = s.substring(0, s.lastIndexOf(47)) + "extensions.xml";
                    URL xmlURL = null;
                    try {
                        xmlURL = new URL(from, sxml);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    try {
                        HttpURLConnection.setFollowRedirects(false);
                        HttpURLConnection conn = (HttpURLConnection)xmlURL.openConnection();
                        if (conn.getResponseCode() != 200) {
                            eligible = false;
                        } else {
                            sxml = s.substring(0, s.lastIndexOf(46)) + ".xml";
                            xmlURL = new URL(from, sxml);
                            conn = (HttpURLConnection)xmlURL.openConnection();
                            if (conn.getResponseCode() != 200) {
                                eligible = false;
                            }
                        }
                        if (eligible) {
                            InputStreamReader in = new InputStreamReader(conn.getInputStream());
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        eligible = false;
                    }
                }
                SPMObjectInfo info = null;
                if (eligible) {
                    System.out.println("adding: " + s);
                    try {
                        info = new SPMObjectInfo(new URL(from, s));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (info == null) continue;
                addTo.add(info);
            }
        }
    }

    private void scanFiles(String dir, Vector addTo) {
        URL cgiUrl = null;
        try {
            String s = this.repository.toString();
            String err = "";
            s = s.substring(0, s.lastIndexOf(47));
            cgiUrl = new URL(s + "/cgi-bin/scripts.cgi?" + dir + "%20" + SPManagerPlugin.AOI_VERSION);
            Object content = null;
            boolean received = false;
            int attempts = 0;
            System.out.println(cgiUrl);
            while (!received && attempts++ < 5) {
                HttpURLConnection conn = (HttpURLConnection)cgiUrl.openConnection();
                if (conn.getResponseCode() != 200) {
                    err = conn.getResponseMessage();
                    Thread.sleep(250L);
                    continue;
                }
                InputStream is = conn.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(is);
                Document doc = SPManagerUtils.builder.parse(bis);
                NodeList tst = doc.getElementsByTagName("scriptcollection");
                if (tst.getLength() > 0) {
                    received = true;
                    NodeList nl = doc.getElementsByTagName("scriptreference");
                    String location = "";
                    long length = 0L;
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node n = nl.item(i);
                        NodeList nnl = n.getChildNodes();
                        Node script = null;
                        location = null;
                        for (int j = 0; j < nnl.getLength(); ++j) {
                            if ("scriptlocation".equals(nnl.item(j).getNodeName())) {
                                location = this.repository.toString() + "/" + dir + "/" + nnl.item(j).getChildNodes().item(0).getNodeValue();
                                continue;
                            }
                            if ("scriptlength".equals(nnl.item(j).getNodeName())) {
                                length = Long.parseLong(nnl.item(j).getChildNodes().item(0).getNodeValue());
                                continue;
                            }
                            if ("extension".equals(nnl.item(j).getNodeName())) {
                                script = nnl.item(j);
                                continue;
                            }
                            if (!"script".equals(nnl.item(j).getNodeName())) continue;
                            script = nnl.item(j);
                        }
                        if (script == null || location == null) continue;
                        addTo.add(new SPMObjectInfo(script, new URL(location), length));
                    }
                }
                bis.close();
            }
            if (!received) {
                JOptionPane.showMessageDialog(null, cgiUrl.toString() + ": " + SPMTranslate.text("scriptServerFailed"), SPMTranslate.text("error") + " " + err, 0);
                return;
            }
        }
        catch (Exception e) {
            if (e instanceof UnknownHostException) {
                JOptionPane.showMessageDialog(null, cgiUrl.toString() + ": " + SPMTranslate.text("unknownHost"), SPMTranslate.text("error"), 0);
                this.unknownHost = true;
            }
            if (e instanceof FileNotFoundException) {
                JOptionPane.showMessageDialog(null, cgiUrl.toString() + ": " + SPMTranslate.text("fileNotFound"), SPMTranslate.text("error"), 0);
                this.unknownHost = true;
            }
            JOptionPane.showMessageDialog(null, cgiUrl.toString() + ": " + SPMTranslate.text("httpError"), SPMTranslate.text("error") + ": " + e.getMessage(), 0);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long downloadRemoteTextFile(URL from, String fileName, long size, StatusDialog status, long totalDownload, long downloadedLength, ArrayList errors) {
        BufferedReader in = null;
        BufferedWriter file = null;
        long initialValue = downloadedLength;
        try {
            HttpURLConnection conn = (HttpURLConnection)from.openConnection();
            if (conn.getResponseCode() != 200) {
                new BStandardDialog("SPManager", (Object)new String[]{SPMTranslate.text("httpError"), conn.getResponseMessage() + " (" + conn.getResponseCode() + ")"}, BStandardDialog.ERROR).showMessageDialog((Widget)SPManagerFrame.getInstance());
                long l = 0L;
                return l;
            }
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            file = new BufferedWriter(new FileWriter(fileName));
            double b = totalDownload;
            int value = status.getBarValue();
            int i = in.read();
            while (i != -1) {
                double a;
                int newValue;
                file.write(i);
                i = in.read();
                if (status == null || (newValue = (int)Math.round((a = (double)(++downloadedLength)) * 100.0 / b)) <= value) continue;
                status.setBarValue(newValue);
                status.setProgressText(newValue + "%");
                value = newValue;
            }
            file.flush();
            file.close();
            long received = downloadedLength - initialValue;
            if (received != size) {
                throw new IOException("SPManager: file incomplete. Only received " + received + " bytes of " + size);
            }
        }
        catch (Exception e) {
            errors.add(SPMTranslate.text("error") + "(" + fileName + ")" + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                System.out.println("SPManager: error closing " + fileName + ": " + e);
            }
        }
        return downloadedLength - initialValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long downloadRemoteBinaryFile(URL from, String fileName, long size, StatusDialog status, long totalDownload, long downloadedLength, ArrayList errors) {
        System.out.println("download: size=" + size + "; total=" + totalDownload + "; downloaded=" + downloadedLength);
        File update = new File(fileName);
        Thread thread = Thread.currentThread();
        BufferedInputStream in = null;
        FilterOutputStream file = null;
        long initialValue = downloadedLength;
        try {
            long received;
            HttpURLConnection conn = (HttpURLConnection)from.openConnection();
            if (conn.getResponseCode() != 200) {
                new BStandardDialog("SPManager", (Object)new String[]{SPMTranslate.text("httpError"), conn.getResponseMessage() + " (" + conn.getResponseCode() + ")"}, BStandardDialog.ERROR).showMessageDialog((Widget)SPManagerFrame.getInstance());
                long l = 0L;
                return l;
            }
            in = new BufferedInputStream(conn.getInputStream());
            file = new BufferedOutputStream(new FileOutputStream(update));
            double b = totalDownload;
            int value = status.getBarValue();
            String mod = "";
            if (b <= 0.0) {
                status.setIdle(true);
            }
            int result = 0;
            while ((result = in.read()) != -1) {
                if (thread.interrupted()) {
                    thread.interrupt();
                    if (!update.delete()) {
                        RandomAccessFile raf = new RandomAccessFile(update, "rw");
                        raf.setLength(0L);
                        raf.close();
                    }
                    throw new InterruptedException("download cancelled: " + fileName);
                }
                ((BufferedOutputStream)file).write((byte)result);
                double a = ++downloadedLength;
                if (b > a) {
                    int newValue = (int)Math.round(a * 100.0 / b);
                    if (newValue <= value) continue;
                    status.setBarValue(newValue);
                    status.setProgressText(newValue + "%");
                    value = newValue;
                    continue;
                }
                String newMod = a > 1000000.0 ? (double)((int)(a / 100000.0)) / 10.0 + " MB" : (a > 1000.0 ? (double)((int)(a / 1000.0)) / 10.0 + " kB" : a + " bytes");
                if (newMod.equals(mod)) continue;
                status.setProgressText(newMod);
            }
            ((BufferedOutputStream)file).flush();
            file.close();
            if (size > 0L && (received = downloadedLength - initialValue) != size) {
                throw new IOException("SPManager: file incomplete. Only received " + received + " bytes of " + size);
            }
            if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
                new ZipFile(update);
                System.out.println("SPManager: ZipFile ok");
            }
        }
        catch (Exception e) {
            errors.add(SPMTranslate.text("error") + "(" + fileName + ")" + e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                System.out.println("SPManager: error closing " + fileName + ": " + e);
            }
        }
        return downloadedLength - initialValue;
    }

    private Vector htmlFindFiles(InputStream is) {
        Vector v = new Vector();
        HtmlParserCallback callback = new HtmlParserCallback(v);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        try {
            new ParserDelegator().parse(bufferedReader, callback, false);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return v;
    }

    private Vector htmlFindFilesVersioning(InputStream is, URL from) {
        Vector v = new Vector();
        HtmlVersioningParserCallback callback = new HtmlVersioningParserCallback(v, from);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        try {
            new ParserDelegator().parse(bufferedReader, callback, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return v;
    }

    private class HttpStatusDialog
    extends BDialog {
        private BLabel label;
        private BProgressBar progressBar;

        public HttpStatusDialog() {
            super((WindowWidget)SPManagerPlugin.getFrame(), SPMTranslate.text("remoteStatus"), false);
            ColumnContainer cc = new ColumnContainer();
            LayoutInfo layout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(10, 10, 10, 10), new Dimension(0, 0));
            this.label = SPMTranslate.bLabel("status");
            cc.add((Widget)this.label, layout);
            this.label.setText(SPMTranslate.text("scanningPlugins"));
            layout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(10, 10, 10, 10), new Dimension(0, 0));
            this.progressBar = new BProgressBar();
            cc.add((Widget)this.progressBar, layout);
            this.progressBar.setIndeterminate(true);
            this.setContent((Widget)cc);
            this.pack();
            this.centerAndSizeWindow();
            this.setVisible(true);
            this.layoutChildren();
            this.addEventLink(class$buoy$event$WindowClosingEvent == null ? (class$buoy$event$WindowClosingEvent = HttpSPMFileSystem.class$("buoy.event.WindowClosingEvent")) : class$buoy$event$WindowClosingEvent, (Object)this, "doClose");
        }

        public void setText(String text) {
            this.label.setText(text);
            this.layoutChildren();
        }

        private void centerAndSizeWindow() {
            Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension d2 = this.getComponent().getSize();
            d2.width = new Long(Math.round((double)d2.width * 1.3)).intValue();
            int x = (d1.width - d2.width) / 2;
            int y = (d1.height - d2.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setBounds(new Rectangle(x, y, d2.width, d2.height + 2));
        }

        private void doClose() {
            this.setVisible(false);
        }
    }

    private class HtmlVersioningParserCallback
    extends HTMLEditorKit.ParserCallback {
        private Vector v;
        private URL from;

        public HtmlVersioningParserCallback(Vector v, URL from) {
            this.v = v;
            this.from = from;
        }

        public void handleText(char[] data, int pos) {
        }

        private String findCorrectVersion(String AoIversion, String[] versions) {
            String[] tmps = AoIversion.split("[^0-9]");
            int maj = Integer.parseInt(tmps[0]);
            int min = Integer.parseInt(tmps[1]);
            String result = null;
            while (result == null && maj >= 0) {
                for (int i = 0; i < versions.length; ++i) {
                    String[] versionsplit = versions[i].split(" ");
                    tmps = versionsplit[0].split("[^0-9]");
                    if (maj != Integer.parseInt(tmps[0]) || min != Integer.parseInt(tmps[1])) continue;
                    result = versionsplit[2];
                }
                if (result != null || --min >= 0) continue;
                min = 9;
                --maj;
            }
            if (result == null) {
                return "";
            }
            if (result.equals("-")) {
                return "";
            }
            return result;
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            String s;
            if (t == HTML.Tag.A && (s = (String)a.getAttribute(HTML.Attribute.HREF)).endsWith("/")) {
                String[] ss = s.split("/");
                s = ss[ss.length - 1];
                String txt = s + "/" + s + ".txt";
                try {
                    URL fileURL = new URL(this.from, txt);
                    HttpURLConnection.setFollowRedirects(false);
                    HttpURLConnection connection = (HttpURLConnection)fileURL.openConnection();
                    String header = connection.getHeaderField(0);
                    InputStreamReader in = new InputStreamReader(connection.getInputStream());
                    int status = 0;
                    String content = "";
                    while (status != -1) {
                        try {
                            status = in.read();
                            if (status == -1) continue;
                            content = content + (char)status;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    in.close();
                    String[] versions = content.split("\n");
                    String name = this.findCorrectVersion(SPManagerPlugin.AOI_VERSION, versions);
                    if (!name.equals("")) {
                        this.v.add(s + "/" + name);
                    }
                }
                catch (IOException e) {
                    return;
                }
            }
        }

        public void handleEndTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        }
    }

    private class HtmlParserCallback
    extends HTMLEditorKit.ParserCallback {
        private Vector v;

        public HtmlParserCallback(Vector v) {
            this.v = v;
        }

        public void handleText(char[] data, int pos) {
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.A) {
                String s = (String)a.getAttribute(HTML.Attribute.HREF);
                this.v.add(s);
            }
        }

        public void handleEndTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        }
    }
}

