/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.antlr.xjlib.appkit.swing.XJTable;
import org.antlr.xjlib.appkit.swing.XJTableAlternateRenderer;
import org.antlr.xjlib.foundation.XJSystem;

public class XJTableView
extends JScrollPane {
    private XJTable table = new XJTable();
    private boolean alternateBackground = true;

    public XJTableView() {
        this.setViewportView(this.table);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                XJTableView.this.autoresizeColumns();
            }
        });
        this.table.setDefaultRenderer(Object.class, new XJTableAlternateRenderer());
        this.table.setShowGrid(false);
        this.table.setAutoResizeMode(0);
        this.setWheelScrollingEnabled(true);
        this.getViewport().setBackground(Color.white);
    }

    public XJTable getTable() {
        return this.table;
    }

    public boolean isAlternateBackground() {
        return this.alternateBackground;
    }

    public void setAlternateBackground(boolean alternateBackground) {
        this.alternateBackground = alternateBackground;
        if (alternateBackground) {
            this.table.setDefaultRenderer(Object.class, new XJTableAlternateRenderer());
        } else {
            this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        }
    }

    public void autoresizeColumns() {
        XJTableView.resizeTableColumnsToFitContent(this.table, 20);
        TableColumnModel model = this.table.getColumnModel();
        int columnTotalWidth = 0;
        for (int i = 0; i < model.getColumnCount() - 1; ++i) {
            columnTotalWidth += model.getColumn(i).getPreferredWidth();
        }
        int offset = this.getVerticalScrollBar().isVisible() ? (XJSystem.isWindows() ? 20 : 20) : (XJSystem.isWindows() ? 3 : 4);
        int spWidth = this.getWidth();
        if (spWidth == 0) {
            spWidth = this.getPreferredSize().width;
        }
        if (model.getColumnCount() > 0) {
            TableColumn c = model.getColumn(model.getColumnCount() - 1);
            int prefWidth = c.getPreferredWidth();
            c.setPreferredWidth(Math.max(spWidth - columnTotalWidth - offset, prefWidth));
        }
    }

    public static void resizeTableColumnsToFitContent(JTable table, int margin) {
        for (int c = 0; c < table.getColumnCount(); ++c) {
            XJTableView.resizeColumnToFitContent(table, c, margin);
        }
    }

    public static void resizeColumnToFitContent(JTable table, int columnIndex, int margin) {
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component c = renderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, 0);
        int maxWidth = c.getPreferredSize().width;
        for (int row = 0; row < table.getRowCount(); ++row) {
            renderer = table.getCellRenderer(row, columnIndex);
            c = renderer.getTableCellRendererComponent(table, table.getValueAt(row, columnIndex), false, false, row, columnIndex);
            maxWidth = Math.max(maxWidth, c.getPreferredSize().width);
        }
        column.setPreferredWidth(maxWidth + margin);
    }

    public void scrollToLastRow() {
        this.table.scrollRectToVisible(this.table.getCellRect(this.table.getRowCount() - 1, 0, true));
    }
}

