/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Map;

public class XJGraphics2DPS
extends Graphics2D {
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected StringBuilder ps = new StringBuilder();
    protected Font font;
    protected Color color;
    protected Color background;
    protected Stroke stroke;
    protected AffineTransform transform;
    protected FontRenderContext fontRenderContext;
    protected Point upperLeftCorner = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Point lowerRightCorner = new Point();
    protected DecimalFormat df;
    protected int marginWidth;
    protected int marginHeight;
    protected static final int BytesPerComponent = 1;
    protected static final int BitsPerComponent = 8;
    protected static final int ComponentsPerPixel = 3;
    protected static char[] hexmap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public XJGraphics2DPS() {
        this.transform = new AffineTransform();
        this.fontRenderContext = new FontRenderContext(null, false, true);
        DecimalFormatSymbols s = new DecimalFormatSymbols();
        s.setDecimalSeparator('.');
        this.df = new DecimalFormat("###.##", s);
        this.setFont(null);
        this.setStroke(new BasicStroke());
        this.setMargins(0, 0);
    }

    public void setMargins(int width, int height) {
        this.marginWidth = width;
        this.marginHeight = height;
    }

    public String redefineOperator(String op, String operator) {
        return "/" + op + " { " + operator + " } bind def" + NEWLINE;
    }

    public String getPSText() {
        this.lowerRightCorner.x += this.marginWidth;
        this.lowerRightCorner.y += this.marginHeight;
        this.upperLeftCorner.x -= this.marginWidth;
        this.upperLeftCorner.y -= this.marginHeight;
        StringBuilder eps = new StringBuilder();
        eps.append("%!PS-Adobe-3.0 EPSF-3.0");
        eps.append(NEWLINE);
        eps.append("%%Creator: XJGraphics2DPS (c) 2005 by Jean Bovet and Terence Parr");
        eps.append(NEWLINE);
        eps.append("%%BoundingBox: 0 0 ");
        eps.append(this.lowerRightCorner.x - this.upperLeftCorner.x);
        eps.append(" ");
        eps.append(this.lowerRightCorner.y - this.upperLeftCorner.y);
        eps.append(NEWLINE);
        eps.append("%%Origin: 0 0");
        eps.append(NEWLINE);
        eps.append("%%Pages: 1");
        eps.append(NEWLINE);
        eps.append("%%Page: 1 1");
        eps.append(NEWLINE);
        eps.append("%%EndComments");
        eps.append(NEWLINE);
        eps.append(this.redefineOperator("tr", "translate"));
        eps.append(this.redefineOperator("sc", "scale"));
        eps.append(this.redefineOperator("gs", "gsave"));
        eps.append(this.redefineOperator("gr", "grestore"));
        eps.append(this.redefineOperator("m", "moveto"));
        eps.append(this.redefineOperator("l", "lineto"));
        eps.append(this.redefineOperator("c", "curveto"));
        eps.append(this.redefineOperator("f", "fill"));
        eps.append(this.redefineOperator("s", "stroke"));
        eps.append(this.redefineOperator("cp", "closepath"));
        eps.append(this.redefineOperator("rgb", "setrgbcolor"));
        eps.append(this.redefineOperator("sw", "setlinewidth"));
        eps.append(this.redefineOperator("sm", "setmiterlimit"));
        eps.append(this.redefineOperator("sj", "setlinejoin"));
        eps.append(this.redefineOperator("slc", "setlinecap"));
        eps.append(this.redefineOperator("sd", "setdash"));
        eps.append(-this.upperLeftCorner.x);
        eps.append(" ");
        eps.append(this.upperLeftCorner.y + (this.lowerRightCorner.y - this.upperLeftCorner.y));
        eps.append(" tr");
        eps.append(NEWLINE);
        eps.append((CharSequence)this.ps);
        return eps.toString();
    }

    public void psAppend(double v) {
        this.psAppend(this.df.format(v));
    }

    public void psAppend(String s) {
        char c;
        if (this.ps.length() > 0 && (c = this.ps.charAt(this.ps.length() - 1)) != ' ' && !String.valueOf(c).equals(NEWLINE)) {
            this.ps.append(' ');
        }
        this.ps.append(s);
    }

    public void psGSave() {
        this.psAppend("gs");
        this.psAppend(NEWLINE);
    }

    public void psGRestore() {
        this.psAppend("gr");
        this.psAppend(NEWLINE);
    }

    public void psMoveTo(double x, double y) {
        this.psAppend(x);
        this.psAppend(y);
        this.psAppend("m");
        this.psAppend(NEWLINE);
    }

    public void psLineTo(double x, double y) {
        this.psAppend(x);
        this.psAppend(y);
        this.psAppend("l");
        this.psAppend(NEWLINE);
    }

    public void psCurveTo(double x0, double y0, double x1, double y1, double x2, double y2) {
        this.psAppend(x0);
        this.psAppend(y0);
        this.psAppend(x1);
        this.psAppend(y1);
        this.psAppend(x2);
        this.psAppend(y2);
        this.psAppend("c");
        this.psAppend(NEWLINE);
    }

    public void psTranslate(double x, double y) {
        this.psAppend(x);
        this.psAppend(y);
        this.psAppend("tr");
        this.psAppend(NEWLINE);
    }

    public void psScale(double x, double y) {
        this.psAppend(x);
        this.psAppend(y);
        this.psAppend("sc");
        this.psAppend(NEWLINE);
    }

    public void psFill() {
        this.psAppend("f");
        this.psAppend(NEWLINE);
    }

    public void psStroke() {
        this.psAppend("s");
        this.psAppend(NEWLINE);
    }

    public void psClosePath() {
        this.psAppend("cp");
        this.psAppend(NEWLINE);
    }

    public void psDrawShape(Shape s, boolean fill) {
        double[] coord = new double[6];
        double cpx = 0.0;
        double cpy = 0.0;
        s = this.transform.createTransformedShape(s);
        Rectangle2D r = s.getBounds2D();
        this.upperLeftCorner.x = (int)Math.min((double)this.upperLeftCorner.x, r.getMinX());
        this.upperLeftCorner.y = (int)Math.min((double)this.upperLeftCorner.y, r.getMinY());
        this.lowerRightCorner.x = (int)Math.max((double)this.lowerRightCorner.x, r.getMaxX());
        this.lowerRightCorner.y = (int)Math.max((double)this.lowerRightCorner.y, r.getMaxY());
        PathIterator iter = s.getPathIterator(null);
        while (!iter.isDone()) {
            int seg = iter.currentSegment(coord);
            double x0 = coord[0];
            double y0 = -coord[1];
            double x1 = coord[2];
            double y1 = -coord[3];
            double x2 = coord[4];
            double y2 = -coord[5];
            switch (seg) {
                case 0: {
                    this.psMoveTo(x0, y0);
                    cpx = x0;
                    cpy = y0;
                    break;
                }
                case 1: {
                    this.psLineTo(x0, y0);
                    cpx = x0;
                    cpy = y0;
                    break;
                }
                case 3: {
                    this.psCurveTo(x0, y0, x1, y1, x2, y2);
                    cpx = x2;
                    cpy = y2;
                    break;
                }
                case 2: {
                    this.psCurveTo(cpx + 0.6666666666666666 * (x0 - cpx), cpy + 0.6666666666666666 * (y0 - cpy), x0 + 0.3333333333333333 * (x1 - x0), y0 + 0.3333333333333333 * (y1 - y0), x1, y1);
                    cpx = x1;
                    cpy = y1;
                    break;
                }
                case 4: {
                    this.psClosePath();
                }
            }
            iter.next();
        }
        if (fill) {
            this.psFill();
        } else {
            this.psStroke();
        }
    }

    public String arrayToString(float[] array) {
        StringBuilder sb = new StringBuilder();
        if (array != null) {
            for (int index = 0; index < array.length; ++index) {
                sb.append(array[index]);
                if (index >= array.length - 1) continue;
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public void draw(Shape s) {
        this.psDrawShape(s, false);
    }

    public void fill(Shape s) {
        this.psDrawShape(s, true);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void drawString(String s, float x, float y) {
        if (s == null || s.length() == 0) {
            return;
        }
        AttributedString as = new AttributedString(s);
        as.addAttribute(TextAttribute.FONT, this.getFont());
        this.drawString(as.getIterator(), x, y);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
        Shape shape = layout.getOutline(AffineTransform.getTranslateInstance(x, y));
        this.fill(shape);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.drawString(new String(data, offset, length), x, y);
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.drawString(new String(data, 0, offset, length), x, y);
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.fill(g.getOutline(x, y));
    }

    public Graphics create() {
        return new XJGraphics2DPS();
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void translate(double tx, double ty) {
        this.transform(AffineTransform.getTranslateInstance(tx, ty));
    }

    public void rotate(double theta) {
        this.transform(AffineTransform.getRotateInstance(theta));
    }

    public void rotate(double theta, double x, double y) {
        this.transform(AffineTransform.getRotateInstance(theta, x, y));
    }

    public void scale(double sx, double sy) {
        this.transform(AffineTransform.getScaleInstance(sx, sy));
    }

    public void shear(double shx, double shy) {
        this.transform(AffineTransform.getShearInstance(shx, shy));
    }

    public void transform(AffineTransform Tx) {
        this.transform.concatenate(Tx);
    }

    public void setTransform(AffineTransform Tx) {
        this.transform = Tx == null ? new AffineTransform() : Tx;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font == null ? Font.decode(null) : font;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
        this.psAppend((double)c.getRed() / 255.0);
        this.psAppend((double)c.getGreen() / 255.0);
        this.psAppend((double)c.getBlue() / 255.0);
        this.psAppend("rgb");
        this.psAppend(NEWLINE);
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
        if (s instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)s;
            this.psAppend(bs.getLineWidth() + " sw" + NEWLINE);
            this.psAppend(Math.max(1.0f, bs.getMiterLimit()) + " sm" + NEWLINE);
            this.psAppend(bs.getLineJoin() + " sj" + NEWLINE);
            this.psAppend(bs.getEndCap() + " slc" + NEWLINE);
            this.psAppend("[" + this.arrayToString(bs.getDashArray()) + "] " + bs.getDashPhase() + " sd" + NEWLINE);
        }
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font f) {
        BufferedImage image = new BufferedImage(1, 1, 1);
        Graphics g = image.getGraphics();
        return g.getFontMetrics(f);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.draw(new Line2D.Float(x1, y1, x2, y2));
    }

    public void drawRect(int x, int y, int width, int height) {
        this.draw(new Rectangle(x, y, width, height));
    }

    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    public void clearRect(int x, int y, int width, int height) {
        Color oldColor = this.getColor();
        this.setColor(this.background);
        this.fillRect(x, y, width, height);
        this.setColor(oldColor);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Float(x, y, width, height));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Float(x, y, width, height));
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0));
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2));
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints == 0) {
            return;
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(xPoints[0], yPoints[0]);
        for (int p = 1; p < nPoints; ++p) {
            path.lineTo(xPoints[p], yPoints[p]);
        }
        this.draw(path);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(new Polygon(xPoints, yPoints, nPoints));
    }

    public void drawPolygon(Polygon p) {
        this.draw(p);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(new Polygon(xPoints, yPoints, nPoints));
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, Color.white, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, Color.white, observer);
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(null), img.getHeight(null), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, width, height, bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, Color.white, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        int width = dx2 - dx1;
        int height = dy2 - dy1;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        g.drawImage(img, 0, 0, width, height, sx1, sy1, sx2, sy2, bgcolor, observer);
        this.psGSave();
        this.psTranslate(dx1, -(dy1 + height));
        this.psAppend("/picstr " + width * 3 + " string def" + NEWLINE);
        this.psScale(width, height);
        this.psAppend("/displayimage {" + NEWLINE);
        this.psAppend(width + " " + height + " " + 8 + " [" + width + " 0 0 -" + height + " 0 " + height + "]" + NEWLINE);
        this.psAppend("{currentfile picstr readhexstring pop} false 3 colorimage} def" + NEWLINE);
        this.psAppend("displayimage" + NEWLINE);
        boolean success = true;
        try {
            this.getPixels(img, 0, 0, width, height);
        }
        catch (Exception e) {
            System.err.println("XJGraphics2DPS: draw image error (" + e + ")");
            success = false;
        }
        this.psGRestore();
        return success;
    }

    public void getPixels(Image img, int x, int y, int w, int h) throws Exception {
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, x, y, w, h, pixels, 0, w);
        pg.grabPixels();
        if ((pg.getStatus() & 0x80) != 0) {
            throw new Exception("image fetch aborted or errored");
        }
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                this.getSinglePixel(x + i, y + j, pixels[j * w + i]);
            }
            this.ps.append(NEWLINE);
        }
    }

    public void getSinglePixel(int x, int y, int pixel) {
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        char[] hexValue = new char[2];
        XJGraphics2DPS.ASCIIHexEncode(red, hexValue);
        this.ps.append(hexValue);
        XJGraphics2DPS.ASCIIHexEncode(green, hexValue);
        this.ps.append(hexValue);
        XJGraphics2DPS.ASCIIHexEncode(blue, hexValue);
        this.ps.append(hexValue);
    }

    public static void ASCIIHexEncode(int b, char[] c) {
        c[0] = hexmap[b >> 4];
        c[1] = hexmap[b & 0xF];
    }

    public void dispose() {
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public void setComposite(Composite comp) {
    }

    public void setPaint(Paint paint) {
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    public void setRenderingHints(Map hints) {
    }

    public void addRenderingHints(Map hints) {
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color c1) {
    }

    public Rectangle getClipBounds() {
        return null;
    }

    public void clipRect(int x, int y, int width, int height) {
    }

    public void setClip(int x, int y, int width, int height) {
    }

    public Shape getClip() {
        return null;
    }

    public void setClip(Shape clip) {
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public Paint getPaint() {
        return null;
    }

    public Composite getComposite() {
        return null;
    }

    public void clip(Shape s) {
    }
}

