/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.menu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuBar;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJWindow;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuBarCustomizer;
import org.antlr.xjlib.appkit.menu.XJMenuBarDelegate;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemCheck;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.utils.XJLocalizable;
import org.antlr.xjlib.foundation.XJSystem;

public class XJMainMenuBar
implements XJMenuItemDelegate {
    public static final int MI_NEW = 10000;
    public static final int MI_OPEN = 10001;
    public static final int MI_SAVE = 10002;
    public static final int MI_SAVEAS = 10003;
    public static final int MI_CLOSE = 10004;
    public static final int MI_QUIT = 10005;
    public static final int MI_HELP = 10020;
    public static final int MI_ABOUT = 10021;
    public static final int MI_PREFS = 10022;
    public static final int MI_UNDO = 10023;
    public static final int MI_REDO = 10024;
    public static final int MI_CUT = 10025;
    public static final int MI_COPY = 10026;
    public static final int MI_PASTE = 10027;
    public static final int MI_SELECT_ALL = 10028;
    public static final int MI_GC = 11000;
    public static final int MI_CLEAR_RECENT_FILES = 20000;
    public static final int MI_RECENT_FILES = 20001;
    public static final int MI_NO_WINDOW = 21000;
    public static final int MI_WINDOW = 21001;
    protected JMenuBar menuBar = null;
    protected XJMenu menuFile = null;
    protected XJMenu menuRecentFiles = null;
    protected XJMenu menuEdit = null;
    protected XJMenu menuWindow = null;
    protected XJMenu menuHelp = null;
    protected XJMenuItem menuItemUndo = null;
    protected XJMenuItem menuItemRedo = null;
    protected XJMenuBarCustomizer customizer = null;
    protected XJMenuBarDelegate delegate = null;
    protected List<XJMenu> customMenus = new ArrayList<XJMenu>();
    protected static List<XJMainMenuBar> mmbs = new ArrayList<XJMainMenuBar>();
    public static final int IGNORE_FILEMENU = 1;
    public static final int IGNORE_EDITMENU = 2;
    public static final int IGNORE_WINDOWMENU = 4;
    public static final int IGNORE_HELPMENU = 8;

    public static synchronized XJMainMenuBar createInstance() {
        XJMainMenuBar mmb = new XJMainMenuBar();
        mmbs.add(mmb);
        return mmb;
    }

    public static synchronized void removeInstance(XJMainMenuBar mmb) {
        mmbs.remove(mmb);
    }

    public static synchronized void refreshAllRecentFilesMenu() {
        for (XJMainMenuBar mmb : mmbs) {
            mmb.rebuildRecentFilesMenu();
        }
    }

    public static synchronized void refreshAllMenuBars() {
        for (XJMainMenuBar mmb : mmbs) {
            mmb.refresh();
        }
    }

    public static synchronized void setActiveWindowToAllMenuBar(XJWindow window) {
        for (XJMainMenuBar mmb : mmbs) {
            mmb.setActiveWindow(window);
        }
    }

    public static boolean isRecentFilesItem(XJMenuItem item) {
        return item.getTag() >= 20000 && item.getTag() < 21000;
    }

    public void setCustomizer(XJMenuBarCustomizer customizer) {
        this.customizer = customizer;
    }

    public void setDelegate(XJMenuBarDelegate delegate) {
        this.delegate = delegate;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public XJMenu getFileMenu() {
        return this.menuFile;
    }

    public void refresh() {
        this.refreshContent();
        this.refreshState();
    }

    public void refreshState() {
        this.refreshMenuState(this.menuFile);
        this.refreshMenuState(this.menuEdit);
        this.refreshMenuState(this.menuHelp);
        for (XJMenu customMenu : this.customMenus) {
            this.refreshMenuState(customMenu);
        }
    }

    public void refreshMenuEditState() {
        this.refreshMenuState(this.menuEdit);
    }

    public void refreshMenuState(XJMenu menu) {
        if (menu == null) {
            return;
        }
        for (int i = 0; i < menu.getItemCount(); ++i) {
            XJMenuItem item = menu.getItemAtIndex(i);
            if (item instanceof XJMenu) {
                this.refreshMenuState((XJMenu)item);
                continue;
            }
            this.refreshMenuItemState(item);
        }
    }

    public void refreshMenuItemState(XJMenuItem item) {
        if (this.delegate != null) {
            this.delegate.menuItemState(item);
        }
    }

    public void refreshContent() {
        this.rebuildRecentFilesMenu();
        this.rebuildWindowMenu();
    }

    public void menuUndoRedoItemState(XJUndo undo) {
        if (undo == null) {
            this.menuItemUndo.setEnabled(false);
            this.menuItemRedo.setEnabled(false);
        } else {
            this.menuItemUndo.setEnabled(undo.canUndo());
            this.menuItemRedo.setEnabled(undo.canRedo());
        }
    }

    public void setActiveWindow(XJWindow window) {
        XJMenuItem item;
        if (this.menuWindow == null) {
            return;
        }
        int index = XJApplication.shared().getWindows().indexOf(window);
        if (index >= 0 && (item = this.menuWindow.getItemAtIndex(index)) != null) {
            item.setSelected(true);
        }
    }

    public void setupMenuItem(XJMenuItem item, String name, int keystroke, int modifiers, int tag) {
        item.setTitle(name);
        item.setTag(tag);
        if (keystroke > 0 && modifiers > 0) {
            item.setAccelerator(keystroke, modifiers);
        } else if (keystroke > 0) {
            item.setAccelerator(keystroke);
        }
        item.setDelegate(this);
    }

    public XJMenuItem buildMenuItem(String name, int keystroke, int modifiers, int tag) {
        XJMenuItem item = new XJMenuItem();
        this.setupMenuItem(item, name, keystroke, modifiers, tag);
        return item;
    }

    public XJMenuItem buildMenuItem(String name, int keystroke, int tag) {
        XJMenuItem item = new XJMenuItem();
        this.setupMenuItem(item, name, keystroke, -1, tag);
        return item;
    }

    public XJMenuItemCheck buildMenuItemCheck(String name, int keystroke, int tag) {
        XJMenuItemCheck item = new XJMenuItemCheck();
        this.setupMenuItem(item, name, keystroke, -1, tag);
        return item;
    }

    public XJMenuItem buildMenuItem(String name, int tag) {
        return this.buildMenuItem(name, -1, tag);
    }

    public void createMenuBar() {
        this.createMenuBar(0);
    }

    public void createMenuBar(int ignore) {
        this.customMenus.clear();
        this.menuBar = new JMenuBar();
        if ((ignore & 1) == 0) {
            this.addMenu(this.createFileMenu());
        }
        if ((ignore & 2) == 0) {
            this.addMenu(this.createEditMenu());
        }
        if (this.customizer != null) {
            this.customizer.customizeMenuBar(this);
        }
        if ((ignore & 4) == 0) {
            this.addMenu(this.createWindowMenu());
        }
        if ((ignore & 8) == 0) {
            this.addMenu(this.createHelpMenu());
        }
        if ("true".equals(System.getProperty("org.antlr.xjlib.debug.menu"))) {
            this.createDebugMenu();
        }
    }

    private void createDebugMenu() {
        XJMenu menu = new XJMenu();
        menu.setTitle("*");
        menu.addItem(this.buildMenuItem("Garbage Collector", 11000));
        this.addMenu(menu);
    }

    public XJMenu createFileMenu() {
        XJMenu menu = this.buildFileMenu();
        if (this.customizer != null) {
            this.customizer.customizeFileMenu(menu);
        }
        XJApplication.getAppDelegate().customizeFileMenu(menu);
        return menu;
    }

    public XJMenu createEditMenu() {
        XJMenu menu = this.buildEditMenu();
        if (this.customizer != null) {
            this.customizer.customizeEditMenu(menu);
        }
        XJApplication.getAppDelegate().customizeEditMenu(menu);
        return menu;
    }

    public XJMenu createWindowMenu() {
        XJMenu menu = this.buildWindowMenu();
        if (this.customizer != null) {
            this.customizer.customizeWindowMenu(menu);
        }
        XJApplication.getAppDelegate().customizeWindowMenu(menu);
        return menu;
    }

    public XJMenu createHelpMenu() {
        XJMenu menu = this.buildHelpMenu();
        if (this.customizer != null) {
            this.customizer.customizeHelpMenu(menu);
        }
        XJApplication.getAppDelegate().customizeHelpMenu(menu);
        return menu;
    }

    public void addCustomMenu(XJMenu menu) {
        if (menu == null) {
            return;
        }
        this.customMenus.add(menu);
        this.addMenu(menu);
    }

    private void addMenu(XJMenu menu) {
        this.menuBar.add(menu.getSwingComponent());
        menu.setMainMenuBar(this);
    }

    private XJMenu buildFileMenu() {
        boolean persistence = XJApplication.shared().supportsPersistence();
        this.menuFile = new XJMenu();
        this.menuFile.setTitle(XJLocalizable.getXJString("File"));
        this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("New"), 78, 10000));
        if (persistence) {
            this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("Open"), 79, 10001));
            this.menuFile.addItem(this.createRecentFilesMenu());
        }
        this.menuFile.addSeparator();
        this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("Close"), 87, 10004));
        if (persistence) {
            this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("Save"), 83, 10002));
            this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("SaveAs"), 10003));
        }
        if (!XJSystem.isMacOS()) {
            this.menuFile.addSeparator();
            if (XJApplication.shared().hasPreferencesMenuItem()) {
                this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("Preferences"), 44, 10022));
                this.menuFile.addSeparator();
            }
            this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("Quit"), 81, 10005));
        }
        return this.menuFile;
    }

    public XJMenu createRecentFilesMenu() {
        this.menuRecentFiles = new XJMenu();
        this.rebuildRecentFilesMenu();
        return this.menuRecentFiles;
    }

    public void rebuildRecentFilesMenu() {
        if (this.menuRecentFiles == null) {
            return;
        }
        this.menuRecentFiles.clear();
        this.menuRecentFiles.setTitle(XJLocalizable.getXJString("OpenRecent"));
        int f = 0;
        for (Object o : XJApplication.shared().recentFiles()) {
            this.menuRecentFiles.addItem(this.buildMenuItem((String)o, 20001 + f++));
        }
        this.menuRecentFiles.addSeparator();
        this.menuRecentFiles.addItem(this.buildMenuItem(XJLocalizable.getXJString("ClearMenu"), 20000));
    }

    private XJMenu buildEditMenu() {
        this.menuEdit = new XJMenu();
        this.menuEdit.setTitle(XJLocalizable.getXJString("Edit"));
        this.menuItemUndo = this.buildMenuItem(XJLocalizable.getXJString("Undo"), 90, 10023);
        this.menuEdit.addItem(this.menuItemUndo);
        this.menuItemRedo = this.buildMenuItem(XJLocalizable.getXJString("Redo"), 90, XJMenuItem.getKeyModifier() | 1, 10024);
        this.menuEdit.addItem(this.menuItemRedo);
        this.menuEdit.addSeparator();
        this.menuEdit.addItem(this.buildMenuItem(XJLocalizable.getXJString("Cut"), 88, 10025));
        this.menuEdit.addItem(this.buildMenuItem(XJLocalizable.getXJString("Copy"), 67, 10026));
        this.menuEdit.addItem(this.buildMenuItem(XJLocalizable.getXJString("Paste"), 86, 10027));
        this.menuEdit.addSeparator();
        this.menuEdit.addItem(this.buildMenuItem(XJLocalizable.getXJString("SelectAll"), 65, 10028));
        return this.menuEdit;
    }

    private void buildWindowMenu_() {
        Iterator<XJWindow> iterator = XJApplication.shared().getWindows().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            XJWindow window = iterator.next();
            if (!window.shouldAppearsInWindowMenu()) continue;
            XJMenuItemCheck item = this.buildMenuItemCheck(window.getTitle(), count < 10 ? 48 + count : -1, 21001 + count);
            item.setSelected(window.isActive());
            this.menuWindow.addItem(item);
            ++count;
        }
        if (count == 0) {
            XJMenuItem item = new XJMenuItem(XJLocalizable.getXJString("NoWindows"), 21000, null);
            item.setEnabled(false);
            this.menuWindow.addItem(item);
        }
    }

    private XJMenu buildWindowMenu() {
        this.menuWindow = new XJMenu();
        this.menuWindow.setTitle(XJLocalizable.getXJString("Window"));
        this.buildWindowMenu_();
        return this.menuWindow;
    }

    private void rebuildWindowMenu() {
        if (this.menuWindow == null) {
            return;
        }
        for (int index = this.menuWindow.getItemCount() - 1; index >= 0; --index) {
            XJMenuItem item = this.menuWindow.getItemAtIndex(index);
            if (item == null || item.getTag() < 21000) continue;
            this.menuWindow.removeItem(index);
        }
        this.buildWindowMenu_();
    }

    private XJMenu buildHelpMenu() {
        this.menuHelp = new XJMenu();
        this.menuHelp.setTitle(XJLocalizable.getXJString("Help"));
        this.menuHelp.addItem(this.buildMenuItem(XJLocalizable.getXJString("Help"), 10020));
        if (!XJSystem.isMacOS()) {
            this.menuHelp.addSeparator();
            this.menuHelp.addItem(this.buildMenuItem(XJLocalizable.getXJString("About"), 10021));
        }
        return this.menuHelp;
    }

    public void handleMenuEvent(XJMenu menu, XJMenuItem item) {
        XJWindow activeWindow = XJApplication.shared().getActiveWindow();
        switch (item.tag) {
            case 10000: {
                XJApplication.shared().newDocument();
                break;
            }
            case 10001: {
                XJApplication.shared().openDocument();
                break;
            }
            case 10002: {
                if (activeWindow == null) break;
                for (XJDocument doc : activeWindow.getDocuments()) {
                    if (!doc.save(false)) continue;
                    doc.changeReset();
                }
                break;
            }
            case 10003: {
                if (activeWindow == null) break;
                for (XJDocument doc : activeWindow.getDocuments()) {
                    if (!doc.save(true)) continue;
                    doc.changeReset();
                }
                break;
            }
            case 20000: {
                XJApplication.shared().clearRecentFiles();
                break;
            }
            case 10005: {
                XJApplication.shared().performQuit();
                break;
            }
            case 10022: {
                XJApplication.shared().displayPrefs();
                break;
            }
            case 10021: {
                XJApplication.shared().displayAbout();
                break;
            }
            case 10020: {
                XJApplication.shared().displayHelp();
                break;
            }
            case 11000: {
                System.gc();
                break;
            }
            default: {
                if (item.tag >= 21001) {
                    XJWindow window = XJApplication.shared().getWindowsInWindowMenu().get(item.tag - 21001);
                    window.bringToFront();
                    item.setSelected(true);
                    break;
                }
                if (item.tag >= 20001 && item.tag <= 20011) {
                    if (XJApplication.shared().openDocument(item.getTitle())) break;
                    XJApplication.shared().removeRecentFile(item.getTitle());
                    break;
                }
                if (this.delegate == null) break;
                this.delegate.handleMenuEvent(menu, item);
            }
        }
    }

    public void menuSelected(XJMenu menu) {
        if (this.delegate != null) {
            this.delegate.handleMenuSelected(menu);
        }
    }
}

