/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.event;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.xjlib.appkit.gview.event.GAbstractEvent;
import org.antlr.xjlib.appkit.gview.event.GEventDelegate;
import org.antlr.xjlib.appkit.gview.object.GElement;

public class GEventManager {
    private List<GAbstractEvent> eventObjects = new ArrayList<GAbstractEvent>();
    private Set exclusiveValueSet = new HashSet();
    private GEventDelegate eventDelegate = null;
    public static final int EVENT_DRAW = 1;
    public static final int EVENT_MOUSE_PRESSED = 2;
    public static final int EVENT_MOUSE_RELEASED = 3;
    public static final int EVENT_MOUSE_DRAGGED = 4;
    public static final int EVENT_MOUSE_MOVED = 5;
    public static final Integer EXCLUSIVE_DRAG_VALUE = new Integer(99);
    public static final Integer EXCLUSIVE_CREATE_LINK_VALUE = new Integer(100);

    public GEventManager(GEventDelegate delegate) {
        this.eventDelegate = delegate;
    }

    public void add(GAbstractEvent event) {
        event.setManager(this);
        event.setDelegate(this.eventDelegate);
        this.eventObjects.add(event);
    }

    public boolean canFocusOnElement(GElement element) {
        for (GAbstractEvent eventObject : this.eventObjects) {
            if (eventObject.shouldFocusOnElement(element)) continue;
            return false;
        }
        return true;
    }

    public void addExclusiveValue(Object value) {
        this.exclusiveValueSet.add(value);
    }

    public void removeExclusiveValue(Object value) {
        this.exclusiveValueSet.remove(value);
    }

    public boolean hasExclusiveValue(Object value) {
        return this.exclusiveValueSet.contains(value);
    }

    public void performEventObjects(int action, Object event, Point mousePosition, Object param) {
        for (GAbstractEvent eventObject : this.eventObjects) {
            switch (action) {
                case 1: {
                    eventObject.draw((Graphics)param);
                    break;
                }
                case 2: {
                    eventObject.mousePressed((MouseEvent)event, mousePosition);
                    break;
                }
                case 3: {
                    eventObject.mouseReleased((MouseEvent)event, mousePosition);
                    break;
                }
                case 4: {
                    eventObject.mouseDragged((MouseEvent)event, mousePosition);
                    break;
                }
                case 5: {
                    eventObject.mouseMoved((MouseEvent)event, mousePosition);
                }
            }
        }
    }
}

