/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.base;

import java.awt.Point;
import java.awt.Rectangle;
import org.antlr.xjlib.appkit.gview.base.Vector2D;

public class Rect {
    public Rectangle r;

    public Rect(Rectangle r) {
        this.r = r;
    }

    public Rect(Vector2D c1, Vector2D c2) {
        this.create(c1, c2, 0.0, 0.0);
    }

    public Rect(Vector2D c1, Vector2D c2, double min_dx, double min_dy) {
        this.create(c1, c2, min_dx, min_dy);
    }

    public void create(Vector2D c1, Vector2D c2, double min_dx, double min_dy) {
        double x = Math.min(c1.getX(), c2.getX());
        double y = Math.min(c1.getY(), c2.getY());
        double dx = Math.max(min_dx, Math.abs(c1.getX() - c2.getX()));
        double dy = Math.max(min_dy, Math.abs(c1.getY() - c2.getY()));
        this.r = new Rectangle((int)x, (int)y, (int)dx, (int)dy);
    }

    public Rect(double x, double y, double dx, double dy) {
        if (dx < 0.0) {
            x += dx;
            dx = -dx;
        }
        if (dy < 0.0) {
            y += dy;
            dy = -dy;
        }
        this.r = new Rectangle((int)x, (int)y, (int)dx, (int)dy);
    }

    public Rect union(Rect r) {
        return new Rect((Rectangle)this.rectangle().createUnion(r.rectangle()));
    }

    public Rectangle rectangle() {
        return this.r;
    }

    public static boolean intersect(Rect r1, Rect r2) {
        return r1.rectangle().intersects(r2.rectangle());
    }

    public boolean contains(double x, double y) {
        return this.r.contains(x, y);
    }

    public boolean contains(Point p) {
        return this.r.contains(p);
    }

    public void inset(double f) {
        this.r.x = (int)((double)this.r.x + f);
        this.r.y = (int)((double)this.r.y + f);
        this.r.width = (int)((double)this.r.width - 2.0 * f);
        this.r.height = (int)((double)this.r.height - 2.0 * f);
    }

    public String toString() {
        if (this.r == null) {
            return super.toString();
        }
        return this.r.toString();
    }
}

