/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.skin.syntaxdiagram;

import java.awt.Font;
import java.awt.Point;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.shape.GLink;

public class SDLink {
    public static boolean linkContainsPoint(GLink link, Point p) {
        GContext context = link.getContext();
        float ox = link.source.getX();
        float oy = link.source.getY();
        float width = link.source.linkDimension.getPixelWidth(context);
        return (float)p.x >= ox && (float)p.x <= ox + width && (float)p.y >= oy - context.getPixelBoxDown() && (float)p.y <= oy + context.getPixelBoxDown() + context.getPixelBoxUp();
    }

    public static void draw(GLink link) {
        GContext context = link.getContext();
        float sx = link.source.getX();
        float sy = link.source.getY();
        float tx = link.target.getX();
        float ty = link.target.getY();
        float sloopBaseWidth = context.getPixelValue("w");
        context.setColor(context.linkColor);
        if (link.transition.isEpsilon()) {
            if (link.virtualPosition != null) {
                SDLink.drawDownSloop(context, link, sx, sy, sx + sloopBaseWidth, link.getVirtualY());
                context.drawLine(sx + sloopBaseWidth, link.getVirtualY(), tx - sloopBaseWidth, link.getVirtualY());
                SDLink.drawUpSloop(context, link, tx - sloopBaseWidth, link.getVirtualY(), tx, ty);
            } else if (sy > ty) {
                if (tx - sx > sloopBaseWidth && sloopBaseWidth > 0.0f) {
                    context.drawLine(sx, sy, tx - sloopBaseWidth, sy);
                    SDLink.drawUpSloop(context, link, tx - sloopBaseWidth, sy, tx, ty);
                } else {
                    SDLink.drawUpSloop(context, link, sx, sy, tx, ty);
                }
            } else if (ty > sy) {
                SDLink.drawDownSloop(context, link, sx, sy, tx, ty);
            } else {
                context.drawLine(sx, sy, tx, ty);
                if (link.target.lastNodeOfRule) {
                    context.drawRightArrow(tx, ty, context.getPixelArrowWidth(), context.getPixelArrowHeight());
                }
            }
        } else {
            SDLink.drawBox(context, link);
        }
    }

    public static void drawUpSloop(GContext context, GLink link, float x0, float y0, float x1, float y1) {
        float xm = x1;
        if (link.last) {
            float r = (x1 - x0) / 4.0f;
            if (link.transition.loop) {
                context.drawLine(x0, y0, xm - r, y0);
                context.drawArc(xm - 2.0f * r, y0, 2.0f * r, 2.0f * r, 0, 90);
                context.drawLine(xm, y0 + r, xm, y1);
            } else {
                context.drawLine(x0, y0, xm - r, y0);
                context.drawArc(xm - 2.0f * r, y0 - 2.0f * r, 2.0f * r, 2.0f * r, 0, -90);
                context.drawLine(xm, y0 - r, xm, y1);
            }
        } else {
            context.drawLine(x0, y0, xm, y0);
            context.drawLine(xm, y0, xm, y1);
            context.drawRightArrow(xm, y0, context.getPixelArrowWidth(), context.getPixelArrowHeight());
        }
        if (!link.transition.loop) {
            context.drawUpArrow(xm, y1, context.getPixelArrowWidth(), context.getPixelArrowHeight());
        }
    }

    public static void drawDownSloop(GContext context, GLink link, float x0, float y0, float x1, float y1) {
        float r = (x1 - x0) / 4.0f;
        if (link.last) {
            if (link.transition.loop) {
                context.drawLine(x0, y0, x0, y1 + r);
                context.drawArc(x0, y1, 2.0f * r, 2.0f * r, 90, 90);
                context.drawLine(x0 + r, y1, x1, y1);
                context.drawDownArrow(x0, y0, context.getPixelArrowWidth(), context.getPixelArrowHeight());
            } else {
                context.drawLine(x0, y0, x0, y1 - r);
                context.drawArc(x0, y1 - 2.0f * r, 2.0f * r, 2.0f * r, -90, -90);
                context.drawLine(x0 + r, y1, x1, y1);
            }
        } else {
            context.drawLine(x0, y0 + r, x0, y1);
            context.drawLine(x0, y1, x1, y1);
        }
    }

    public static void drawBox(GContext context, GLink link) {
        Font font;
        float ox = link.source.getX();
        float oy = link.source.getY();
        float width = link.source.linkDimension.getPixelWidth(context);
        context.drawLine(ox, oy, ox + context.getPixelBoxEdge(), oy);
        context.drawRightArrow(ox + context.getPixelBoxEdge(), oy, context.getPixelArrowWidth(), context.getPixelArrowHeight());
        if (link.transition.externalRuleRef) {
            font = context.getRuleFont();
            context.drawRoundRect(ox + context.getPixelBoxEdge(), oy - context.getPixelBoxDown(), width - 2.0f * context.getPixelBoxEdge(), context.getPixelBoxDown() + context.getPixelBoxUp(), 8.0f, 8.0f, true);
        } else {
            font = context.getBoxFont();
            context.drawRect(ox + context.getPixelBoxEdge(), oy - context.getPixelBoxDown(), width - 2.0f * context.getPixelBoxEdge(), context.getPixelBoxDown() + context.getPixelBoxUp(), true);
        }
        context.drawLine(ox + width - context.getPixelBoxEdge(), oy, ox + width, oy);
        context.setColor(context.getColorForLabel(link.transition.label));
        context.drawString(font, link.transition.label, ox + width / 2.0f, oy, 0);
    }
}

