/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import org.antlr.works.utils.TextPaneDelegate;

public class TextPane
extends JTextPane {
    protected TextPaneDelegate delegate = null;
    protected boolean wrap = false;

    public void setDelegate(TextPaneDelegate delegate) {
        this.delegate = delegate;
    }

    public void setWordWrap(boolean flag) {
        this.wrap = flag;
    }

    public boolean getWordWrap() {
        return this.wrap;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (!this.wrap) {
            Container parent = this.getParent();
            return parent == null || this.getUI().getPreferredSize((JComponent)this).width < parent.getSize().width;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public void setBounds(int x, int y, int width, int height) {
        if (!this.wrap) {
            Dimension size = this.getPreferredSize();
            super.setBounds(x, y, Math.max(size.width, width), Math.max(size.height, height));
        } else {
            super.setBounds(x, y, width, height);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.delegate != null) {
            this.delegate.textPaneDidPaint(g);
        }
    }

    public int getTextIndexAtLocation(Point point) {
        int index = this.viewToModel(point);
        try {
            Rectangle r = this.modelToView(index);
            if (point.x <= r.x) {
                return index - 1;
            }
        }
        catch (BadLocationException e1) {
            return -1;
        }
        return index;
    }
}

