/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stringtemplate.syntax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.works.ate.syntax.generic.ATESyntaxParser;
import org.antlr.works.ate.syntax.misc.ATEScope;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.stringtemplate.element.ElementTemplateArgumentBlock;
import org.antlr.works.stringtemplate.element.ElementTemplateCommentScope;
import org.antlr.works.stringtemplate.element.ElementTemplateExpressionBlock;
import org.antlr.works.stringtemplate.element.ElementTemplateMapDefinition;
import org.antlr.works.stringtemplate.element.ElementTemplateName;
import org.antlr.works.stringtemplate.element.ElementTemplateReference;
import org.antlr.works.stringtemplate.element.ElementTemplateRule;

public class ATEStringTemplateSyntaxParser
extends ATESyntaxParser {
    private static final ElementTemplateArgumentBlock ARGUMENT_BLOCK = new ElementTemplateArgumentBlock();
    private static final ElementTemplateExpressionBlock EXPR_BLOCK = new ElementTemplateExpressionBlock();
    private static final ElementTemplateCommentScope COMMENT_SCOPE = new ElementTemplateCommentScope();
    public final List<ElementTemplateRule> templateRules = new ArrayList<ElementTemplateRule>();
    public final List<ElementTemplateReference> references = new ArrayList<ElementTemplateReference>();
    public final List<ElementTemplateMapDefinition> mapDefinitions = new ArrayList<ElementTemplateMapDefinition>();
    public final List<ATEToken> decls = new ArrayList<ATEToken>();
    public final List<ATEToken> maps = new ArrayList<ATEToken>();
    public List<ATEToken> currentArgs = new ArrayList<ATEToken>();
    public final List<String> currentArgNames = new ArrayList<String>();
    private final List<ATEToken> unresolvedReferences = new ArrayList<ATEToken>();
    private final Set<String> declaredReferenceNames = new HashSet<String>();
    private final Map<ATEToken, ElementTemplateRule> refsToRules = new HashMap<ATEToken, ElementTemplateRule>();
    private final Set<String> declaredMapNames = new HashSet<String>();
    private ElementTemplateName name;
    private ElementTemplateRule currentTemplateRule;
    private ElementTemplateMapDefinition currentTemplateMap;

    public ElementTemplateName getName() {
        return this.name;
    }

    public void close() {
        super.close();
        this.clear();
    }

    public void parseTokens() {
        this.clear();
        if (!this.nextToken()) {
            return;
        }
        while (this.matchNewline(0) || this.matchSingleComment(0) || this.matchComplexComment(0) || this.matchName() || this.matchTemplate() || this.matchMapDefinition() || this.nextToken()) {
        }
        this.resolveReferences();
    }

    private void clear() {
        this.templateRules.clear();
        this.decls.clear();
        this.declaredReferenceNames.clear();
        this.declaredMapNames.clear();
        this.unresolvedReferences.clear();
        this.references.clear();
        this.refsToRules.clear();
        this.currentTemplateRule = null;
    }

    private void resolveReferences() {
        for (int i = this.unresolvedReferences.size() - 1; i >= 0; --i) {
            ATEToken ref = this.unresolvedReferences.get(i);
            if (!this.declaredReferenceNames.contains(ref.getAttribute())) continue;
            ref.type = 116;
            this.references.add(new ElementTemplateReference(this.refsToRules.get(ref), ref));
            this.unresolvedReferences.remove(i);
        }
    }

    private boolean matchName() {
        if (!this.isID(0)) {
            return false;
        }
        this.mark();
        if (this.tryMatchName()) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean matchSuperGroup() {
        this.mark();
        if (this.tryMatchSuperGroup()) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean matchInterface() {
        this.mark();
        if (this.tryMatchInterface()) {
            return true;
        }
        this.rewind();
        return false;
    }

    private boolean tryMatchName() {
        ATEToken start = this.T(0);
        if (!this.matchID(0, "group")) {
            return false;
        }
        ATEToken name = this.T(0);
        if (!this.nextToken()) {
            return false;
        }
        this.matchSuperGroup();
        this.matchInterface();
        if (!this.matchSEMI(0)) {
            return false;
        }
        this.name = new ElementTemplateName(name, start, this.T(-1));
        return true;
    }

    private boolean tryMatchSuperGroup() {
        if (!this.matchCOLON(0)) {
            return false;
        }
        return this.matchID(0);
    }

    private boolean tryMatchInterface() {
        if (!this.matchID(0, "implements")) {
            return false;
        }
        if (!this.isCOMMA(0)) {
            return false;
        }
        while (this.matchCOMMA(0)) {
            if (this.matchID(0)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchTemplate() {
        this.mark();
        try {
            if (this.tryMatchTemplate()) {
                boolean bl = true;
                return bl;
            }
            this.rewind();
            boolean bl = false;
            return bl;
        }
        finally {
            this.currentTemplateRule = null;
        }
    }

    private boolean tryMatchTemplate() {
        ATEToken start = this.T(0);
        if (start == null) {
            return false;
        }
        String name = start.getAttribute();
        if (!this.matchID(0)) {
            return false;
        }
        this.currentArgs = new ArrayList<ATEToken>();
        this.currentArgNames.clear();
        this.matchArguments();
        if (!this.isDEFINED_TO_BE(0)) {
            return false;
        }
        this.nextToken();
        ATEToken definedToBeToken = this.T(-1);
        this.currentTemplateRule = new ElementTemplateRule(this, name, start, definedToBeToken, null, this.currentArgs);
        while (this.matchNewline(0)) {
        }
        return !(this.isOPEN_DOUBLE_ANGLE(0) ? !this.tryMatchTemplateBigString(start) : (this.isDOUBLE_QUOTE(0) ? !this.tryMatchTemplateString(start) : !this.tryMatchTemplateAssign(start)));
    }

    private boolean tryMatchTemplateBigString(ATEToken rule) {
        if (!this.matchOPEN_DOUBLE_ANGLE(0)) {
            return false;
        }
        do {
            if (!this.matchCLOSE_DOUBLE_ANGLE(0)) continue;
            if (rule != null) {
                this.currentTemplateRule.end = this.T(-1);
                rule.type = 113;
                this.addDeclaration(rule);
                this.templateRules.add(this.currentTemplateRule);
            }
            return true;
        } while (this.matchAngleComment(0) || this.matchExpression() || this.matchLiteral() || this.nextToken());
        return false;
    }

    private boolean tryMatchTemplateString(ATEToken rule) {
        if (!this.matchDOUBLE_QUOTE(0)) {
            return false;
        }
        do {
            if (!this.matchDOUBLE_QUOTE(0) && !this.matchNewline(0)) continue;
            if (rule != null) {
                this.currentTemplateRule.end = this.T(-1);
                rule.type = 113;
                this.addDeclaration(rule);
                this.templateRules.add(this.currentTemplateRule);
            }
            return true;
        } while (this.matchAngleComment(0) || this.matchDollarComment(0) || this.matchExpression() || this.matchLiteral() || this.nextToken());
        return false;
    }

    private boolean tryMatchTemplateAssign(ATEToken rule) {
        if (this.isID(0)) {
            this.unresolvedReferences.add(this.T(0));
            this.addReference(this.T(0));
            if (rule != null) {
                this.currentTemplateRule.end = this.T(0);
                rule.type = 113;
                this.addDeclaration(rule);
                this.templateRules.add(this.currentTemplateRule);
            }
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchExpression() {
        if (this.T(0) == null || this.T((int)0).type != 104) {
            return false;
        }
        this.mark();
        int balance = 0;
        block0: while (true) {
            this.T((int)0).scope = EXPR_BLOCK;
            if (this.T((int)0).type == 104) {
                ++balance;
            } else if (this.T((int)0).type == 105 && --balance == 0) {
                this.nextToken();
                return true;
            }
            if (this.isID(0)) {
                String refName = this.T(0).getAttribute();
                if (this.currentArgNames.contains(refName)) {
                    this.T((int)0).type = 118;
                } else {
                    this.unresolvedReferences.add(this.T(0));
                    this.addReference(this.T(0));
                }
                this.nextToken();
                do {
                    if (!this.isChar(0, ".") || !this.isID(1)) continue block0;
                } while (this.skip(2));
                return false;
            }
            if (!this.nextToken()) break;
        }
        this.rewind();
        return false;
    }

    private boolean matchLiteral() {
        ATEToken t = this.T(0);
        if (t == null) {
            return false;
        }
        t.type = 115;
        this.nextToken();
        return true;
    }

    private boolean matchArguments() {
        if (this.T(0) == null || this.T((int)0).type != 7) {
            return false;
        }
        this.mark();
        do {
            this.T((int)0).scope = ARGUMENT_BLOCK;
            if (this.T((int)0).type == 8) {
                this.nextToken();
                return true;
            }
            if (this.T((int)0).type == 126) {
                this.nextToken();
                if (!this.matchTemplateString()) {
                    return false;
                }
            }
            if (!this.isID(0)) continue;
            this.T((int)0).type = 119;
            this.currentArgs.add(this.T(0));
            this.currentArgNames.add(this.T(0).getAttribute());
        } while (this.nextToken());
        this.rewind();
        return false;
    }

    private boolean matchTemplateString() {
        this.mark();
        if (this.tryMatchTemplateString(null)) {
            return true;
        }
        this.rewind();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchMapDefinition() {
        this.mark();
        try {
            if (this.tryMapDefinition()) {
                boolean bl = true;
                return bl;
            }
            this.rewind();
            boolean bl = false;
            return bl;
        }
        finally {
            this.currentTemplateRule = null;
        }
    }

    private boolean tryMapDefinition() {
        ATEToken start = this.T(0);
        if (start == null) {
            return false;
        }
        String name = start.getAttribute();
        if (!this.matchID(0)) {
            return false;
        }
        if (!this.isDEFINED_TO_BE(0)) {
            return false;
        }
        this.nextToken();
        ATEToken definedToBeToken = this.T(-1);
        this.currentTemplateMap = new ElementTemplateMapDefinition(name, start, definedToBeToken, null);
        while (this.matchNewline(0)) {
        }
        return this.tryMatchMapDefinitionBody(start);
    }

    private boolean tryMatchMapDefinitionBody(ATEToken rule) {
        if (!this.isLBRACK(0)) {
            return false;
        }
        do {
            if (!this.isRBRACK(0)) continue;
            this.nextToken();
            this.currentTemplateMap.end = this.T(-1);
            rule.type = 121;
            this.addMapDefinition(rule);
            this.mapDefinitions.add(this.currentTemplateMap);
            return true;
        } while (this.matchSingleComment(0) || this.matchComplexComment(0) || this.matchValuePair() || this.nextToken());
        return false;
    }

    private boolean matchValuePair() {
        this.matchSingleComment(0);
        this.matchComplexComment(0);
        if (!this.tryMatchKey()) {
            return false;
        }
        if (!this.matchCOLON(0)) {
            return false;
        }
        if (this.isOPEN_DOUBLE_ANGLE(0) ? !this.tryMatchTemplateBigString(null) : (this.isDOUBLE_QUOTE(0) ? !this.tryMatchTemplateString(null) : !this.tryMatchTemplateAssign(null))) {
            return false;
        }
        this.matchSingleComment(0);
        this.matchComplexComment(0);
        while (this.matchCOMMA(0)) {
            if (this.matchValuePair()) continue;
            return false;
        }
        return true;
    }

    private boolean tryMatchKey() {
        if (this.matchID(0, "default")) {
            return true;
        }
        if (!this.isDOUBLE_QUOTE(0)) {
            return false;
        }
        ATEToken start = this.T(0);
        start.type = 2;
        this.nextToken();
        do {
            ATEToken t = this.T(0);
            if (this.isDOUBLE_QUOTE(0) || this.isNewline(0)) {
                t.type = 2;
                this.nextToken();
                return true;
            }
            t.type = 2;
        } while (this.nextToken());
        return false;
    }

    private void addReference(ATEToken ref) {
        this.refsToRules.put(ref, this.currentTemplateRule);
    }

    private void addDeclaration(ATEToken token) {
        this.decls.add(token);
        this.declaredReferenceNames.add(token.getAttribute());
    }

    private void addMapDefinition(ATEToken token) {
        this.maps.add(token);
        this.declaredMapNames.add(token.getAttribute());
    }

    private boolean matchCommentScope(int open, int close, ATEScope scope) {
        if (this.T(0) == null || this.T((int)0).type != open) {
            return false;
        }
        this.mark();
        boolean balance = false;
        do {
            this.T((int)0).scope = scope;
            if (this.T((int)0).type != close) continue;
            this.nextToken();
            return true;
        } while (this.nextToken());
        this.rewind();
        return false;
    }

    private boolean matchID(int index) {
        if (this.isID(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchID(int index, String text) {
        if (this.isID(index, text)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchCOLON(int index) {
        if (this.isCOLON(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchSEMI(int index) {
        if (this.isSEMI(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchCOMMA(int index) {
        if (this.isCOMMA(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchDOUBLE_QUOTE(int index) {
        if (this.isDOUBLE_QUOTE(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchOPEN_DOUBLE_ANGLE(int index) {
        if (this.isOPEN_DOUBLE_ANGLE(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchCLOSE_DOUBLE_ANGLE(int index) {
        if (this.isCLOSE_DOUBLE_ANGLE(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchAngleComment(int index) {
        if (this.isAngleComment(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchDollarComment(int index) {
        if (this.isDollarComment(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchNewline(int index) {
        if (this.isNewline(index)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public boolean matchSingleComment(int index) {
        return this.matchCommentScope(122, 117, COMMENT_SCOPE);
    }

    public boolean matchComplexComment(int index) {
        return this.matchCommentScope(123, 124, COMMENT_SCOPE);
    }

    private boolean isLPAREN(int index) {
        return this.isTokenType(index, 7);
    }

    private boolean isSEMI(int index) {
        return this.isTokenType(index, 14);
    }

    private boolean isCOLON(int index) {
        return this.isTokenType(index, 13);
    }

    private boolean isCOMMA(int index) {
        return this.isTokenType(index, 112);
    }

    private boolean isDEFINED_TO_BE(int index) {
        return this.isTokenType(index, 101);
    }

    private boolean isDOUBLE_QUOTE(int index) {
        return this.isTokenType(index, 106);
    }

    private boolean isOPEN_DOUBLE_ANGLE(int index) {
        return this.isTokenType(index, 102);
    }

    private boolean isLBRACK(int index) {
        return this.isTokenType(index, 11);
    }

    private boolean isRBRACK(int index) {
        return this.isTokenType(index, 12);
    }

    private boolean isCLOSE_DOUBLE_ANGLE(int index) {
        return this.isTokenType(index, 103);
    }

    private boolean isAngleComment(int index) {
        return this.isTokenType(index, 107);
    }

    private boolean isDollarComment(int index) {
        return this.isTokenType(index, 108);
    }

    private boolean isNewline(int index) {
        return this.isTokenType(index, 117);
    }

    private boolean isStartSingleComment(int index) {
        return this.isTokenType(index, 122);
    }

    private boolean isStartComplexComment(int index) {
        return this.isTokenType(index, 123);
    }

    private boolean isEndComplexComment(int index) {
        return this.isTokenType(index, 124);
    }
}

