/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.menu;

import org.antlr.works.components.GrammarWindow;
import org.antlr.works.stats.StatisticsAW;

public class DebugMenu {
    private final GrammarWindow window;

    public DebugMenu(GrammarWindow window) {
        this.window = window;
    }

    public void runInterpreter() {
        try {
            StatisticsAW.shared().recordEvent(90);
            this.window.selectInterpreterTab();
            this.window.interpreterTab.interpret();
        }
        catch (Exception e) {
            this.window.consoleTab.println(e);
        }
    }

    public void run() {
        this.window.getConsoleTab().print("TODO: run and send output to this console", 0);
    }

    public void debug() {
        this.window.getDebuggerTab().launchLocalDebugger(0);
    }

    public void debugAgain() {
        this.window.getDebuggerTab().launchLocalDebugger(1);
    }

    public void debugRemote() {
        this.window.getDebuggerTab().launchRemoteDebugger();
    }

    public void toggleInputTokens() {
        this.window.getDebuggerTab().toggleInputTokensBox();
        StatisticsAW.shared().recordEvent(147);
    }

    public void showEditTestRig() {
        this.window.getDebuggerTab().showEditTestRig();
    }

    public boolean isInputTokenVisible() {
        return this.window.getDebuggerTab().isInputTokenVisible();
    }

    public boolean isRunning() {
        return this.window.getDebuggerTab().isRunning();
    }

    public boolean canDebugAgain() {
        return this.window.getDebuggerTab().canDebugAgain();
    }

    public String getEventsAsString() {
        return this.window.getDebuggerTab().getEventsAsString();
    }
}

