/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.grammar.element;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.antlr.works.ate.folding.ATEFoldingEntity;
import org.antlr.works.ate.gutter.ATEGutterItem;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.editor.EditorPersistentObject;
import org.antlr.works.grammar.antlr.GrammarError;
import org.antlr.works.grammar.element.ElementAction;
import org.antlr.works.grammar.element.ElementBlock;
import org.antlr.works.grammar.element.ElementReference;
import org.antlr.works.grammar.element.ElementScopable;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.grammar.syntax.GrammarSyntaxParser;
import org.antlr.works.utils.IconManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementRule
extends ElementScopable
implements Comparable,
EditorPersistentObject,
ATEFoldingEntity,
ATEGutterItem {
    public String name;
    public ATEToken start;
    public ATEToken colon;
    public ATEToken end;
    public boolean ignored = false;
    public boolean expanded = true;
    public boolean breakpoint = false;
    public boolean lexer = false;
    public boolean hasLeftRecursion = false;
    public boolean leftRecursionAnalyzed = false;
    public Set leftRecursiveRulesSet;
    public boolean hierarchyAnalyzed = false;
    public List<GrammarError> errors;
    public boolean needsToBuildErrors = true;
    protected GrammarSyntaxParser parser;
    protected int refsStartIndex = -1;
    protected int refsEndIndex = -1;
    protected int blocksStartIndex = -1;
    protected int blocksEndIndex = -1;
    protected int actionsStartIndex = -1;
    protected int actionsEndIndex = -1;
    private GrammarEngine engine;
    public static final int ITEM_TYPE_OVERRIDE = 1;
    public static final int ITEM_TYPE_OVERRIDDEN = 2;
    public boolean override = false;
    public List<String> overrideGrammars;
    public boolean isOverridden = false;
    public List<String> overriddenGrammars;
    public List<Integer> types = new ArrayList<Integer>();

    public ElementRule(String name) {
        this.name = name;
        this.lexer = ATEToken.isLexerName(name);
    }

    public ElementRule(GrammarSyntaxParser parser, String name, ATEToken start, ATEToken colon, ATEToken end) {
        this.parser = parser;
        this.name = name;
        this.start = start;
        this.colon = colon;
        this.end = end;
        this.lexer = ATEToken.isLexerName(name);
    }

    public void completed() {
        this.leftRecursionAnalyzed = false;
    }

    public void resetHierarchy() {
        this.hierarchyAnalyzed = false;
    }

    public GrammarEngine getEngine() {
        return this.engine;
    }

    public void setEngine(GrammarEngine engine) {
        this.engine = engine;
    }

    public void setReferencesIndexes(int startIndex, int endIndex) {
        this.refsStartIndex = Math.max(0, startIndex);
        this.refsEndIndex = endIndex;
    }

    public List<ElementReference> getReferences() {
        if (this.refsStartIndex != -1 && this.refsEndIndex != -1) {
            return this.parser.references.subList(this.refsStartIndex, this.refsEndIndex + 1);
        }
        return null;
    }

    public void setBlocksIndexes(int startIndex, int endIndex) {
        this.blocksStartIndex = Math.max(0, startIndex);
        this.blocksEndIndex = endIndex;
    }

    public List<ElementBlock> getBlocks() {
        if (this.blocksStartIndex != -1 && this.blocksEndIndex != -1) {
            return this.parser.blocks.subList(this.blocksStartIndex, this.blocksEndIndex + 1);
        }
        return null;
    }

    public void setActionsIndexes(int startIndex, int endIndex) {
        this.actionsStartIndex = Math.max(0, startIndex);
        this.actionsEndIndex = endIndex;
    }

    public List<ElementAction> getActions() {
        if (this.actionsStartIndex != -1 && this.actionsEndIndex != -1) {
            return this.parser.actions.subList(this.actionsStartIndex, this.actionsEndIndex + 1);
        }
        return null;
    }

    public int getStartIndex() {
        return this.start.getStartIndex();
    }

    public int getEndIndex() {
        return this.end.getEndIndex();
    }

    public int getLength() {
        return this.getEndIndex() - this.getStartIndex();
    }

    public int getInternalTokensStartIndex() {
        Iterator<ATEToken> iter = this.getTokens().iterator();
        while (iter.hasNext()) {
            ATEToken token = iter.next();
            if (!token.getAttribute().equals(":")) continue;
            token = iter.next();
            return token.getStartIndex();
        }
        return -1;
    }

    public int getInternalTokensEndIndex() {
        ATEToken token = this.parser.getTokens().get(this.end.index - 1);
        return token.getEndIndex();
    }

    public List<ATEToken> getTokens() {
        ArrayList<ATEToken> t = new ArrayList<ATEToken>();
        for (int index = this.start.index; index < this.end.index; ++index) {
            t.add(this.parser.getTokens().get(index));
        }
        return t;
    }

    public List<List<ATEToken>> getAlternatives() {
        ArrayList<List<ATEToken>> alts = new ArrayList<List<ATEToken>>();
        ArrayList<ATEToken> alt = null;
        boolean findColon = true;
        int level = 0;
        for (ATEToken token : this.getTokens()) {
            if (findColon) {
                if (!token.getAttribute().equals(":")) continue;
                findColon = false;
                alt = new ArrayList<ATEToken>();
                continue;
            }
            if (token.getAttribute().equals("(")) {
                ++level;
            } else if (token.getAttribute().equals(")")) {
                --level;
            } else if (level == 0 && token.getAttribute().equals("|")) {
                alts.add(alt);
                alt = new ArrayList();
                continue;
            }
            alt.add(token);
        }
        if (alt != null && !alt.isEmpty()) {
            alts.add((List<ATEToken>)alt);
        }
        return alts;
    }

    public void setErrors(List<GrammarError> errors) {
        this.errors = errors;
    }

    public List<GrammarError> getErrors() {
        return this.errors;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setLeftRecursiveRulesSet(Set rulesSet) {
        this.leftRecursiveRulesSet = rulesSet;
    }

    public Set getLeftRecursiveRulesSet() {
        return this.leftRecursiveRulesSet;
    }

    public boolean hasLeftRecursion() {
        if (!this.leftRecursionAnalyzed) {
            this.leftRecursionAnalyzed = true;
            this.hasLeftRecursion = this.detectLeftRecursion();
        }
        return this.hasLeftRecursion;
    }

    public boolean detectLeftRecursion() {
        for (List<ATEToken> alts : this.getAlternatives()) {
            ATEToken firstTokenInAlt;
            if (alts.isEmpty() || !(firstTokenInAlt = alts.get(0)).getAttribute().equals(this.name)) continue;
            return true;
        }
        return false;
    }

    public String getTextRuleAfterRemovingLeftRecursion() {
        StringBuilder head = new StringBuilder();
        StringBuilder star = new StringBuilder();
        for (List<ATEToken> alts : this.getAlternatives()) {
            int end;
            int start;
            ATEToken firstTokenInAlt = alts.get(0);
            if (firstTokenInAlt.getAttribute().equals(this.name)) {
                if (alts.size() <= 1) continue;
                if (star.length() > 0) {
                    star.append(" | ");
                }
                start = alts.get(1).getStartIndex();
                end = alts.get(alts.size() - 1).getEndIndex();
                star.append(firstTokenInAlt.getText().substring(start, end));
                continue;
            }
            if (head.length() > 0) {
                head.append(" | ");
            }
            start = firstTokenInAlt.getStartIndex();
            end = alts.get(alts.size() - 1).getEndIndex();
            head.append(firstTokenInAlt.getText().substring(start, end));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append((CharSequence)head);
        sb.append(")");
        if (star.length() > 0) {
            sb.append(" (");
            sb.append((CharSequence)star);
            sb.append(")*");
        }
        return sb.toString();
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public void setNeedsToBuildErrors(boolean flag) {
        this.needsToBuildErrors = flag;
    }

    public boolean needsToBuildErrors() {
        return this.needsToBuildErrors;
    }

    public String getErrorMessageString(int index) {
        GrammarError error = this.errors.get(index);
        return error.messageText;
    }

    public String getErrorMessageHTML() {
        StringBuilder message = new StringBuilder();
        message.append("<html>");
        Iterator<GrammarError> iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            GrammarError error = iterator.next();
            message.append(error.messageText);
            if (!iterator.hasNext()) continue;
            message.append("<br>");
        }
        message.append("</html>");
        return message.toString();
    }

    public String toString() {
        return this.name;
    }

    public boolean containsIndex(int index) {
        return index >= this.getStartIndex() && index <= this.getEndIndex();
    }

    public int compareTo(Object o) {
        ElementRule otherRule = (ElementRule)o;
        return this.name.compareTo(otherRule.name);
    }

    public int getUniqueIdentifier() {
        return this.name.hashCode();
    }

    public boolean canBeCollapsed() {
        return this.colon.startLineNumber <= this.end.startLineNumber - 1;
    }

    @Override
    public void foldingEntitySetExpanded(boolean expanded) {
        this.setExpanded(expanded);
    }

    @Override
    public boolean foldingEntityIsExpanded() {
        return this.isExpanded();
    }

    @Override
    public boolean foldingEntityCanBeCollapsed() {
        return this.canBeCollapsed();
    }

    @Override
    public int foldingEntityGetStartParagraphIndex() {
        return this.getStartIndex();
    }

    @Override
    public int foldingEntityGetStartIndex() {
        return this.colon.getStartIndex();
    }

    @Override
    public int foldingEntityGetEndIndex() {
        return this.getEndIndex();
    }

    @Override
    public int foldingEntityGetStartLine() {
        return this.colon.startLineNumber;
    }

    @Override
    public int foldingEntityGetEndLine() {
        return this.end.endLineNumber;
    }

    @Override
    public String foldingEntityPlaceholderString() {
        return ": ... ;";
    }

    @Override
    public String foldingEntityID() {
        return String.valueOf(this.getUniqueIdentifier());
    }

    @Override
    public int foldingEntityLevel() {
        return 0;
    }

    @Override
    public int getItemIndex() {
        return this.getStartIndex();
    }

    @Override
    public void setItemIndex(int index) {
        this.start.start = index;
    }

    private void analyzeHierarchy() {
        this.overrideGrammars = this.engine.getGrammarsOverriddenByRule(this.name);
        this.override = !this.overrideGrammars.isEmpty();
        this.overriddenGrammars = this.engine.getGrammarsOverridingRule(this.name);
        this.isOverridden = !this.overriddenGrammars.isEmpty();
    }

    @Override
    public synchronized List<Integer> getItemTypes() {
        if (!this.hierarchyAnalyzed) {
            this.analyzeHierarchy();
            this.hierarchyAnalyzed = true;
            this.types.clear();
            if (this.override) {
                this.types.add(1);
            }
            if (this.isOverridden) {
                this.types.add(2);
            }
        }
        return this.types;
    }

    @Override
    public int getItemWidth() {
        int width = 0;
        for (int type : this.getItemTypes()) {
            width += this.getItemIcon(type).getIconWidth();
        }
        return width;
    }

    @Override
    public int getItemHeight() {
        int height = 0;
        for (int type : this.getItemTypes()) {
            height = Math.max(height, this.getItemIcon(type).getIconHeight());
        }
        return height;
    }

    @Override
    public ImageIcon getItemIcon(int type) {
        if (type == 1) {
            return IconManager.shared().getIconOverride();
        }
        if (type == 2) {
            return IconManager.shared().getIconOverridden();
        }
        return null;
    }

    @Override
    public String getItemTooltip(int type) {
        if (type == 1) {
            return "Overrides rule in " + this.overrideGrammars;
        }
        if (type == 2) {
            return "Is overridden in " + this.overriddenGrammars;
        }
        return null;
    }

    @Override
    public void itemAction(int type) {
        switch (type) {
            case 1: {
                this.engine.gotoToRule(this.overrideGrammars.get(0), this.name);
                break;
            }
            case 2: {
                this.engine.gotoToRule(this.overriddenGrammars.get(0), this.name);
            }
        }
    }

    @Override
    public Object getPersistentID() {
        return this.getUniqueIdentifier();
    }

    @Override
    public void persistentAssign(EditorPersistentObject otherObject) {
        ElementRule oldRule = (ElementRule)otherObject;
        this.ignored = oldRule.ignored;
        this.expanded = oldRule.expanded;
        this.breakpoint = oldRule.breakpoint;
        this.leftRecursiveRulesSet = oldRule.leftRecursiveRulesSet;
    }
}

