/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.tivo;

import java.util.List;
import java.util.Stack;
import org.antlr.runtime.Token;
import org.antlr.works.debugger.DebuggerTab;
import org.antlr.works.debugger.events.DBEvent;
import org.antlr.works.debugger.events.DBEventAddChild;
import org.antlr.works.debugger.events.DBEventBecomeRoot;
import org.antlr.works.debugger.events.DBEventBeginBacktrack;
import org.antlr.works.debugger.events.DBEventConsumeHiddenToken;
import org.antlr.works.debugger.events.DBEventConsumeToken;
import org.antlr.works.debugger.events.DBEventCreateNode;
import org.antlr.works.debugger.events.DBEventEndBacktrack;
import org.antlr.works.debugger.events.DBEventEnterAlt;
import org.antlr.works.debugger.events.DBEventEnterDecision;
import org.antlr.works.debugger.events.DBEventEnterRule;
import org.antlr.works.debugger.events.DBEventEnterSubRule;
import org.antlr.works.debugger.events.DBEventErrorNode;
import org.antlr.works.debugger.events.DBEventExitDecision;
import org.antlr.works.debugger.events.DBEventExitRule;
import org.antlr.works.debugger.events.DBEventExitSubRule;
import org.antlr.works.debugger.events.DBEventLT;
import org.antlr.works.debugger.events.DBEventLocation;
import org.antlr.works.debugger.events.DBEventMark;
import org.antlr.works.debugger.events.DBEventNilNode;
import org.antlr.works.debugger.events.DBEventRecognitionException;
import org.antlr.works.debugger.events.DBEventRewind;
import org.antlr.works.debugger.events.DBEventSetTokenBoundaries;
import org.antlr.works.debugger.input.DBInputProcessor;
import org.antlr.works.debugger.input.DBInputTextTokenInfo;
import org.antlr.works.debugger.tivo.DBPlayerContextInfo;

public class DBPlayer {
    protected DebuggerTab debuggerTab;
    protected DBInputProcessor processor;
    protected DBPlayerContextInfo contextInfo;
    protected Stack<Integer> markStack;
    protected int resyncing = 0;
    protected int eventPlayedCount = 0;
    protected DBEventLocation lastLocationEvent;

    public DBPlayer(DebuggerTab debuggerTab) {
        this.debuggerTab = debuggerTab;
        this.contextInfo = new DBPlayerContextInfo();
        this.markStack = new Stack();
    }

    public void close() {
        this.debuggerTab = null;
    }

    public void setInputBuffer(DBInputProcessor processor) {
        this.processor = processor;
    }

    public DBPlayerContextInfo getContextInfo() {
        return this.contextInfo;
    }

    public synchronized void resetPlayEvents(boolean first) {
        this.debuggerTab.resetGUI();
        if (first) {
            this.processor.reset();
        } else {
            this.processor.rewindAll();
        }
        this.contextInfo.clear();
        this.markStack.clear();
        this.resyncing = 0;
        this.eventPlayedCount = 0;
    }

    public void playEvents(List events, int lastEventPosition, boolean reset) {
        if (reset) {
            this.resetPlayEvents(false);
        }
        int lastIndex = lastEventPosition - 1;
        for (int i = this.eventPlayedCount; i < lastEventPosition; ++i) {
            DBEvent event = (DBEvent)events.get(i);
            try {
                this.playEvent(event);
            }
            catch (Exception e) {
                this.debuggerTab.getConsole().println(e);
            }
            this.debuggerTab.addEvent(event, this.contextInfo);
            if (i != lastIndex) continue;
            this.playLocation();
        }
        this.eventPlayedCount = lastEventPosition;
    }

    public void playEvent(DBEvent event) {
        switch (event.getEventType()) {
            case 8: {
                this.playEnterRule((DBEventEnterRule)event);
                break;
            }
            case 9: {
                this.playExitRule((DBEventExitRule)event);
                break;
            }
            case 10: {
                this.playEnterSubrule((DBEventEnterSubRule)event);
                break;
            }
            case 11: {
                this.playExitSubrule((DBEventExitSubRule)event);
                break;
            }
            case 12: {
                this.playEnterDecision((DBEventEnterDecision)event);
                break;
            }
            case 13: {
                this.playExitDecision((DBEventExitDecision)event);
                break;
            }
            case 14: {
                this.playEnterAlt((DBEventEnterAlt)event);
                break;
            }
            case 7: {
                this.playLT((DBEventLT)event);
                break;
            }
            case 5: {
                this.playConsumeToken((DBEventConsumeToken)event);
                break;
            }
            case 6: {
                this.playConsumeToken((DBEventConsumeHiddenToken)event);
                break;
            }
            case 4: {
                this.playLocation((DBEventLocation)event);
                break;
            }
            case 15: {
                this.playMark((DBEventMark)event);
                break;
            }
            case 16: {
                this.playRewind((DBEventRewind)event);
                break;
            }
            case 17: {
                this.playBeginBacktrack((DBEventBeginBacktrack)event);
                break;
            }
            case 18: {
                this.playEndBacktrack((DBEventEndBacktrack)event);
                break;
            }
            case 26: {
                this.playRecognitionException((DBEventRecognitionException)event);
                break;
            }
            case 19: {
                this.playBeginResync();
                break;
            }
            case 20: {
                this.playEndResync();
                break;
            }
            case 21: {
                this.playNilNode((DBEventNilNode)event);
                break;
            }
            case 27: {
                this.playErrorNode((DBEventErrorNode)event);
                break;
            }
            case 22: {
                this.playCreateNode((DBEventCreateNode)event);
                break;
            }
            case 23: {
                this.playBecomeRoot((DBEventBecomeRoot)event);
                break;
            }
            case 24: {
                this.playAddChild((DBEventAddChild)event);
                break;
            }
            case 25: {
                this.playSetTokenBoundaries((DBEventSetTokenBoundaries)event);
                break;
            }
        }
    }

    public void playEnterRule(DBEventEnterRule event) {
        this.debuggerTab.playerPushRule(event);
        this.processor.removeAllLT();
    }

    public void playExitRule(DBEventExitRule event) {
        this.debuggerTab.playerPopRule(event);
        this.processor.removeAllLT();
    }

    public void playEnterSubrule(DBEventEnterSubRule event) {
        this.contextInfo.enterSubrule(event.decision);
        this.processor.removeAllLT();
    }

    public void playExitSubrule(DBEventExitSubRule event) {
        this.contextInfo.exitSubrule();
        this.processor.removeAllLT();
    }

    public void playEnterDecision(DBEventEnterDecision event) {
        this.contextInfo.enterDecision(event.decision);
        this.processor.removeAllLT();
    }

    public void playExitDecision(DBEventExitDecision event) {
        this.contextInfo.exitDecision();
        this.processor.removeAllLT();
    }

    public void playEnterAlt(DBEventEnterAlt event) {
    }

    public void playLT(DBEventLT event) {
        if (event.token.getType() == -1) {
            return;
        }
        if (event.index < 0) {
            return;
        }
        if (this.contextInfo.getDecision() == -1) {
            return;
        }
        this.processor.LT(event.token);
    }

    public void playConsumeToken(DBEventConsumeToken event) {
        this.playConsumeToken(event.token, false);
    }

    public void playConsumeToken(DBEventConsumeHiddenToken event) {
        this.playConsumeToken(event.token, true);
    }

    public void playConsumeToken(Token token, boolean hidden) {
        if (this.resyncing > 0) {
            this.processor.consumeToken(token, 3);
            return;
        }
        if (this.contextInfo.isBacktracking()) {
            this.debuggerTab.playerConsumeToken(token);
            return;
        }
        if (!this.markStack.isEmpty()) {
            return;
        }
        if (!hidden) {
            this.debuggerTab.playerConsumeToken(token);
        }
        this.processor.consumeToken(token, hidden ? 2 : 1);
    }

    public void playLocation(DBEventLocation event) {
        this.lastLocationEvent = event;
        this.debuggerTab.playerSetLocation(this.lastLocationEvent);
        this.processor.setLocation(this.lastLocationEvent);
    }

    public void playLocation() {
        this.debuggerTab.resetGrammarLocation();
        this.debuggerTab.setGrammarLocation(this.lastLocationEvent);
    }

    public void playMark(DBEventMark event) {
        this.contextInfo.mark(event.id);
        this.markStack.push(this.processor.getCurrentTokenIndex());
    }

    public void playRewind(DBEventRewind event) {
        this.processor.rewind(this.markStack.peek());
        if (!event.rewindToLastMark()) {
            this.markStack.pop();
            this.contextInfo.rewind();
        }
    }

    public void playBeginBacktrack(DBEventBeginBacktrack event) {
        this.contextInfo.beginBacktrack(event.level);
        this.debuggerTab.playerBeginBacktrack(event.level);
    }

    public void playEndBacktrack(DBEventEndBacktrack event) {
        this.contextInfo.endBacktrack();
        this.debuggerTab.playerEndBacktrack(event.level, event.successful);
    }

    public void playRecognitionException(DBEventRecognitionException event) {
        DBInputTextTokenInfo info = this.processor.getTokenInfoAtTokenIndex(event.e.index);
        if (info != null) {
            event.e.token = info.token;
        }
        this.debuggerTab.playerRecognitionException(event.e);
    }

    public void playBeginResync() {
        ++this.resyncing;
    }

    public void playEndResync() {
        --this.resyncing;
    }

    public void playNilNode(DBEventNilNode event) {
        this.debuggerTab.playerNilNode(event.id);
    }

    public void playErrorNode(DBEventErrorNode event) {
        this.debuggerTab.playerErrorNode(event.id, event.text);
    }

    public void playCreateNode(DBEventCreateNode event) {
        if (event.tokenIndex == -1) {
            this.debuggerTab.playerCreateNode(event.id, event.text, event.type);
        } else {
            DBInputTextTokenInfo info = this.processor.getTokenInfoAtTokenIndex(event.tokenIndex);
            if (info == null) {
                this.debuggerTab.getConsole().println("No token info for token index " + event.tokenIndex);
            } else {
                this.debuggerTab.playerCreateNode(event.id, info.token);
            }
        }
    }

    public void playBecomeRoot(DBEventBecomeRoot event) {
        this.debuggerTab.playerBecomeRoot(event.newRootID, event.oldRootID);
    }

    public void playAddChild(DBEventAddChild event) {
        this.debuggerTab.playerAddChild(event.rootID, event.childID);
    }

    public void playSetTokenBoundaries(DBEventSetTokenBoundaries event) {
        this.debuggerTab.playerSetTokenBoundaries(event.id, event.startIndex, event.stopIndex);
    }
}

